/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class BASE64DecodedMultipartFile
implements MultipartFile {
    private static final Logger logger = LoggerFactory.getLogger(BASE64DecodedMultipartFile.class);
    private final byte[] imgContent;
    private final String header;

    public BASE64DecodedMultipartFile(byte[] imgContent, String header) {
        this.imgContent = imgContent;
        this.header = header.split(";")[0];
    }

    public String getName() {
        return (double)System.currentTimeMillis() + Math.random() + "." + this.header.split("/")[1];
    }

    public String getOriginalFilename() {
        return System.currentTimeMillis() + (long)((int)Math.random() * 10000) + "." + this.header.split("/")[1];
    }

    public String getContentType() {
        return this.header.split(":")[1];
    }

    public boolean isEmpty() {
        return this.imgContent == null || this.imgContent.length == 0;
    }

    public long getSize() {
        return this.imgContent.length;
    }

    public byte[] getBytes() throws IOException {
        return this.imgContent;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.imgContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferTo(File dest) throws IOException, IllegalStateException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(dest);
            fileOutputStream.write(this.imgContent);
        }
        catch (IOException e) {
            logger.error("[\u5546\u54c1\u4e2d\u5fc3-base64\u89e3\u5bc6\u6587\u4ef6\u8f6c\u6362\u65b9\u6cd5]-\u5f02\u5e38|", (Throwable)e);
        }
        finally {
            if (null != fileOutputStream) {
                fileOutputStream.close();
            }
        }
    }
}

