/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.mall.ability.api.UccMallBatchChooseMaterialAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallBatchChooseMaterialAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallBatchChooseMaterialAbilityRspBO;
import com.tydic.commodity.mall.busi.bo.UccMallSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.mall.constants.ModelRuleConstant;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccMallSkuSupplierPO;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallBatchChooseMaterialAbilityService"})
public class UccMallBatchChooseMaterialAbilityServiceImpl
implements UccMallBatchChooseMaterialAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallBatchChooseMaterialAbilityServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Resource(name="uccMalllmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer uccMalllmSyncCommodityMqServiceProvider;

    @PostMapping(value={"batchChooseMaterials"})
    public UccMallBatchChooseMaterialAbilityRspBO batchChooseMaterials(@RequestBody UccMallBatchChooseMaterialAbilityReqBO reqBO) {
        UccMallBatchChooseMaterialAbilityRspBO rspBO = new UccMallBatchChooseMaterialAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("skuIds\u4e3a\u7a7a");
            return rspBO;
        }
        List<UccMallSkuSupplierPO> cnncUccSkuSupplierPOS = this.uccMallSkuMapper.batchQryBySkuIds(reqBO.getSkuIds());
        if (!CollectionUtils.isEmpty(cnncUccSkuSupplierPOS)) {
            this.uccMallSkuMapper.batchUpdateMaterial(reqBO.getSkuIds(), reqBO.getMaterialId(), reqBO.getMaterialName());
            Map<Long, List<UccMallSkuSupplierPO>> collect = cnncUccSkuSupplierPOS.stream().collect(Collectors.groupingBy(UccMallSkuSupplierPO::getSupplierId));
            Set<Long> supplierIds = collect.keySet();
            for (Long supplierId : supplierIds) {
                UccMallSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new UccMallSyncSceneCommodityToEsReqBO();
                List<Long> commodityIds = collect.get(supplierId).stream().map(UccMallSkuSupplierPO::getCommodityId).distinct().collect(Collectors.toList());
                syncSceneCommodityToEsReqBO.setCommodityIds(commodityIds);
                syncSceneCommodityToEsReqBO.setSupplierId(supplierId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                syncSceneCommodityToEsReqBO.setCommodityType(2);
                this.uccMalllmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)((Object)syncSceneCommodityToEsReqBO))));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

