/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.agreement.ability.api.AgrQryAgreementDetailAbilityService;
import com.tydic.agreement.ability.bo.AgrQryAgreementDetailAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementDetailAbilityRspBO;
import com.tydic.commodity.mall.ability.api.UccMallBatchShopingQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccBatchShopQryBo;
import com.tydic.commodity.mall.ability.bo.UccMallBatchShopQryMsgBo;
import com.tydic.commodity.mall.ability.bo.UccMallBatchShopingQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallBatchShopingQryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallOrgSkuLadderPriceBO;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallOrgSkuLadderPriceMapper;
import com.tydic.commodity.mall.dao.UccMallOrgSkuMapper;
import com.tydic.commodity.mall.dao.UccMallOrgSkuWhiteRestrictionMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccCommodityTypePo;
import com.tydic.commodity.mall.po.UccMallBatchShopQryMsgPO;
import com.tydic.commodity.mall.po.UccMallOrgSkuLadderPricePO;
import com.tydic.commodity.mall.po.UccMallOrgSkuWhiteRestrictionPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallBatchShopingQryAbilityService"})
public class UccMallBatchShopingQryAbilityServiceImpl
implements UccMallBatchShopingQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallBatchShopingQryAbilityServiceImpl.class);
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(UccMallBatchShopingQryAbilityServiceImpl.class);
    @Autowired
    private UccMallOrgSkuMapper uccMallOrgSkuMapper;
    @Autowired
    private UccMallOrgSkuWhiteRestrictionMapper uccMallOrgSkuWhiteRestrictionMapper;
    @Autowired
    private UccMallOrgSkuLadderPriceMapper uccMallOrgSkuLadderPriceMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private AgrQryAgreementDetailAbilityService agrQryAgreementDetailAbilityService;

    @PostMapping(value={"qryInfo"})
    public UccMallBatchShopingQryAbilityRspBO qryInfo(@RequestBody UccMallBatchShopingQryAbilityReqBO reqBo) {
        UccMallBatchShopingQryAbilityRspBO rspBo = new UccMallBatchShopingQryAbilityRspBO();
        if (reqBo.getShopQry() == null || reqBo.getShopQry().size() == 0) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5355\u54c1ID \u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBo;
        }
        List<Long> skuIds = reqBo.getShopQry().stream().map(UccBatchShopQryBo::getSkuId).collect(Collectors.toList());
        List<Long> notFindSkuIds = reqBo.getShopQry().stream().map(UccBatchShopQryBo::getSkuId).collect(Collectors.toList());
        List<UccMallBatchShopQryMsgPO> uccMallBatchShopQryMsgPOS = this.uccMallOrgSkuMapper.qryShoppingSkuList(skuIds, reqBo.getQryStr());
        if (CollectionUtils.isEmpty(uccMallBatchShopQryMsgPOS)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5355\u54c1ID!");
            return rspBo;
        }
        ArrayList<UccMallBatchShopQryMsgBo> shopQryMsg = new ArrayList<UccMallBatchShopQryMsgBo>();
        ArrayList<Long> findSkuIds = new ArrayList<Long>();
        for (UccMallBatchShopQryMsgPO uccMallBatchShopQryMsgPO : uccMallBatchShopQryMsgPOS) {
            Object uccCommodityTypePo;
            findSkuIds.add(uccMallBatchShopQryMsgPO.getSkuId());
            UccMallBatchShopQryMsgBo bo = new UccMallBatchShopQryMsgBo();
            BeanUtils.copyProperties((Object)uccMallBatchShopQryMsgPO, (Object)bo);
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(uccMallBatchShopQryMsgPO.getSkuId());
            List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qerySku(uccSkuPo);
            if (uccSkuPos.size() > 0 && (uccCommodityTypePo = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeId(uccSkuPos.get(0).getCommodityTypeId())) != null) {
                bo.setRate(((UccCommodityTypePo)uccCommodityTypePo).getRate());
            }
            uccCommodityTypePo = reqBo.getShopQry().iterator();
            while (uccCommodityTypePo.hasNext()) {
                UccBatchShopQryBo uccBatchShopQryBo = (UccBatchShopQryBo)uccCommodityTypePo.next();
                if (!bo.getSkuId().equals(uccBatchShopQryBo.getSkuId())) continue;
                bo.setSaleNum(uccBatchShopQryBo.getSaleNum());
                if (uccMallBatchShopQryMsgPO.getSwitchOn() != 1) continue;
                ArrayList ladderPriceBos = new ArrayList();
                UccMallOrgSkuLadderPricePO ladderPricePO = new UccMallOrgSkuLadderPricePO();
                ladderPricePO.setVirtualSkuId(uccBatchShopQryBo.getSkuId());
                ladderPricePO.setPriceType(3);
                ladderPricePO.setOrderBy("START ASC");
                List<UccMallOrgSkuLadderPricePO> skuLadderPrice = this.uccMallOrgSkuLadderPriceMapper.getOrgSkuLadderPrice(ladderPricePO);
                if (skuLadderPrice != null && skuLadderPrice.size() > 0) {
                    skuLadderPrice.forEach(po -> {
                        UccMallOrgSkuLadderPriceBO ladderPriceBo = new UccMallOrgSkuLadderPriceBO();
                        BeanUtils.copyProperties((Object)po, (Object)ladderPriceBo);
                        ladderPriceBos.add(ladderPriceBo);
                    });
                }
                bo.setLadderPriceBos(ladderPriceBos);
                ladderPricePO.setStart(new Double(uccBatchShopQryBo.getSaleNum()).longValue());
                ladderPricePO.setPriceType(3);
                ladderPricePO.setOrderBy("START DESC");
                List<UccMallOrgSkuLadderPricePO> ladderPrice = this.uccMallOrgSkuLadderPriceMapper.getOrgSkuLadderPrice(ladderPricePO);
                if (ladderPrice == null || ladderPrice.size() <= 0) continue;
                bo.setPrice(new BigDecimal(ladderPrice.get(0).getPrice()));
            }
            bo.setAvailableSale(Integer.valueOf(1));
            if (uccMallBatchShopQryMsgPO.getStock() == null || uccMallBatchShopQryMsgPO.getStock() == 0L) {
                bo.setAvailableSale(Integer.valueOf(0));
                bo.setNoAvailableSaleDesc("\u5e93\u5b58\u4e0d\u8db3");
            } else if (!(StringUtils.isEmpty((CharSequence)reqBo.getProvince()) && reqBo.getOrgId() == null || StringUtils.isEmpty((CharSequence)reqBo.getProvince()))) {
                UccMallOrgSkuWhiteRestrictionPo param = new UccMallOrgSkuWhiteRestrictionPo();
                param.setAgreementId(bo.getAgreementId());
                List<UccMallOrgSkuWhiteRestrictionPo> whiteList = this.uccMallOrgSkuWhiteRestrictionMapper.qryAreaList(param);
                if (!CollectionUtils.isEmpty(whiteList)) {
                    log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u8d2d\u7269\u8f66\u5546\u54c1\u6279\u91cf\u67e5\u8be2]-\u7701\u4efdwhiteList:{}", (Object)JSONObject.toJSONString(whiteList));
                    for (UccMallOrgSkuWhiteRestrictionPo uccMallOrgSkuWhiteRestrictionPo : whiteList) {
                        bo.setAvailableSale(Integer.valueOf(1));
                        bo.setNoAvailableSaleDesc("\u53ef\u552e");
                        if (uccMallOrgSkuWhiteRestrictionPo.getProvince() == null) continue;
                        if (reqBo.getProvince().equals(String.valueOf(uccMallOrgSkuWhiteRestrictionPo.getProvince()))) {
                            log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u8d2d\u7269\u8f66\u5546\u54c1\u6279\u91cf\u67e5\u8be2]-\u5141\u8bb8\u53ef\u552e\u7701\u4efd|\u7701\u4efdID:{}", (Object)uccMallOrgSkuWhiteRestrictionPo.getProvince());
                            bo.setAvailableSale(Integer.valueOf(1));
                            bo.setNoAvailableSaleDesc("\u53ef\u552e");
                            break;
                        }
                        log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u8d2d\u7269\u8f66\u5546\u54c1\u6279\u91cf\u67e5\u8be2]-\u6709\u6570\u636e\u6ca1\u6709\u5339\u914d\u4e0a|\u7701\u4efd:{}", (Object)JSONObject.toJSONString((Object)uccMallOrgSkuWhiteRestrictionPo));
                        bo.setAvailableSale(Integer.valueOf(2));
                        bo.setNoAvailableSaleDesc("\u533a\u57df\u9650\u5236");
                    }
                }
            }
            bo.setPrice(MoneyUtils.haoToYuan(bo.getPrice(), 4));
            bo.setStock(Long.valueOf(MoneyUtils.haoToYuan(new BigDecimal(bo.getStock())).longValue()));
            if (bo.getAgreementId() != null) {
                AgrQryAgreementDetailAbilityReqBO agreementDetailAbilityReqBO = new AgrQryAgreementDetailAbilityReqBO();
                agreementDetailAbilityReqBO.setAgreementId(bo.getAgreementId());
                AgrQryAgreementDetailAbilityRspBO agreementDetailAbilityRspBO = this.agrQryAgreementDetailAbilityService.qryAgreementDetail(agreementDetailAbilityReqBO);
                if (Objects.nonNull(agreementDetailAbilityRspBO) && "0000".equals(agreementDetailAbilityRspBO.getRespCode()) && Objects.nonNull(agreementDetailAbilityRspBO.getAgrAgreementBO())) {
                    bo.setAgreementMode(agreementDetailAbilityRspBO.getAgrAgreementBO().getAgreementMode());
                }
            }
            shopQryMsg.add(bo);
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getQryStr())) {
            notFindSkuIds.removeAll(findSkuIds);
            if (!CollectionUtils.isEmpty(notFindSkuIds)) {
                notFindSkuIds.forEach(v -> {
                    UccMallBatchShopQryMsgBo bo = new UccMallBatchShopQryMsgBo();
                    bo.setSkuId(v);
                    bo.setAvailableSale(Integer.valueOf(0));
                    bo.setNoAvailableSaleDesc("\u5546\u54c1\u5df2\u5220\u9664");
                    shopQryMsg.add(bo);
                });
            }
        }
        rspBo.setShopQryMsg(shopQryMsg);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

