/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccMallExpectDeliveryTimeQueryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallExpectDeliveryTimeQueryAbilityReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallExpectDeliveryTimeQueryAbilityRspBo;
import com.tydic.commodity.mall.atom.api.UccMallExpectDeliveryTimeQueryAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallExpectDeliveryTimeQueryAtomReqBo;
import com.tydic.commodity.mall.atom.bo.UccMallExpectDeliveryTimeQueryAtomRspBo;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallExpectDeliveryTimeQueryAbilityService"})
public class UccMallExpectDeliveryTimeQueryAbilityServiceImpl
implements UccMallExpectDeliveryTimeQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallExpectDeliveryTimeQueryAbilityServiceImpl.class);
    @Autowired
    private UccMallExpectDeliveryTimeQueryAtomService uccExpectDeliveryTimeQueryAtomService;
    @Autowired
    private UccMallSkuMapper uccSkuMapper;
    @Autowired
    private UccMallSupplierShopMapper supplierShopMapper;
    @Autowired
    private UccMallSupplierMapper supplierMapper;
    @Value(value="${ESB_QRY_SKU_EXPECT_DELIVERY_TIME}")
    private String url;

    @PostMapping(value={"getExpectDeliveryTime"})
    public UccMallExpectDeliveryTimeQueryAbilityRspBo getExpectDeliveryTime(@RequestBody UccMallExpectDeliveryTimeQueryAbilityReqBo reqBo) {
        SupplierBusiPo supplierBusiPo;
        SupplierShopPo supplierShopPo;
        UccMallExpectDeliveryTimeQueryAbilityRspBo rspBo = new UccMallExpectDeliveryTimeQueryAbilityRspBo();
        String s = this.checkReq(reqBo);
        if (!StringUtils.isEmpty((Object)s)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(s);
            return rspBo;
        }
        String extSkuId = "";
        if (reqBo.getSkuId() != null) {
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(reqBo.getSkuId());
            uccSkuPo.setSupplierShopId(reqBo.getSupplierShopId());
            List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
            if (!CollectionUtils.isEmpty(uccSkuPos)) {
                extSkuId = uccSkuPos.get(0).getExtSkuId();
            } else {
                throw new BusinessException(UccMallConstantsEnums.NON_SPECIFICATIONS.code(), "\u8f93\u5165\u5355\u54c1\u4fe1\u606f\u6709\u8bef");
            }
        }
        Long supplierId = null;
        String supplierCode = "";
        if (reqBo.getSupplierShopId() != null && (supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId())) != null && (supplierBusiPo = this.supplierMapper.selectSupplierById(supplierShopPo.getSupplierId())) != null) {
            supplierId = supplierBusiPo.getSupplierId();
            supplierCode = supplierBusiPo.getSupplierCode();
        }
        try {
            UccMallExpectDeliveryTimeQueryAtomReqBo uccExpectDeliveryTimeQueryAtomReqBo = new UccMallExpectDeliveryTimeQueryAtomReqBo();
            BeanUtils.copyProperties((Object)reqBo, (Object)uccExpectDeliveryTimeQueryAtomReqBo);
            uccExpectDeliveryTimeQueryAtomReqBo.setUrl(this.url);
            uccExpectDeliveryTimeQueryAtomReqBo.setSkuId(extSkuId);
            uccExpectDeliveryTimeQueryAtomReqBo.setSupplierId(supplierId);
            uccExpectDeliveryTimeQueryAtomReqBo.setSupplierCode(supplierCode);
            UccMallExpectDeliveryTimeQueryAtomRspBo uccExpectDeliveryTimeQueryAtomRspBo = this.uccExpectDeliveryTimeQueryAtomService.getExpectDeliveryTime(uccExpectDeliveryTimeQueryAtomReqBo);
            BeanUtils.copyProperties((Object)((Object)uccExpectDeliveryTimeQueryAtomRspBo), (Object)rspBo);
        }
        catch (BusinessException e) {
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4]-\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38|", (Throwable)e);
            throw e;
        }
        return rspBo;
    }

    private String checkReq(UccMallExpectDeliveryTimeQueryAbilityReqBo reqBo) {
        String s = "";
        if (reqBo.getSupplierShopId() == null) {
            s = "\u8bf7\u8f93\u5165\u5e97\u94faID";
        }
        if (reqBo.getSkuId() == null) {
            s = "\u8bf7\u8f93\u5165\u5355\u54c1ID";
        }
        if (StringUtils.isEmpty((Object)reqBo.getNum())) {
            s = "\u8bf7\u8f93\u5165\u6570\u91cf";
        }
        return s;
    }
}

