/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccMallQryDeliveryAndArriveTimeAbilityService;
import com.tydic.commodity.mall.ability.bo.DeliveryAndArriveTimeDetailBO;
import com.tydic.commodity.mall.ability.bo.QryDeliveryAndArriveTimeBO;
import com.tydic.commodity.mall.ability.bo.UccMallQryDeliveryAndArriveTimeAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQryDeliveryAndArriveTimeAbilityRspBO;
import com.tydic.commodity.mall.atom.api.UccMallCommdDetailsQryAtomService;
import com.tydic.commodity.mall.atom.api.UccMallExpectDeliveryTimeQueryAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallCommdDetailsQryReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallCommdDetailsQryRspBO;
import com.tydic.commodity.mall.atom.bo.UccMallExpectDeliveryTimeQueryAtomReqBo;
import com.tydic.commodity.mall.atom.bo.UccMallExpectDeliveryTimeQueryAtomRspBo;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallQryDeliveryAndArriveTimeAbilityService"})
public class UccMallQryDeliveryAndArriveTimeAbilityServiceImpl
implements UccMallQryDeliveryAndArriveTimeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallQryDeliveryAndArriveTimeAbilityServiceImpl.class);
    @Autowired
    private UccMallExpectDeliveryTimeQueryAtomService uccExpectDeliveryTimeQueryAtomService;
    @Autowired
    private UccMallSkuMapper uccSkuMapper;
    @Autowired
    private UccMallSupplierShopMapper supplierShopMapper;
    @Autowired
    private UccMallSupplierMapper supplierMapper;
    @Value(value="${ESB_QRY_SKU_EXPECT_DELIVERY_TIME}")
    private String url;
    @Autowired
    private UccMallCommdDetailsQryAtomService uccMallCommdDetailsQryAtomService;

    @PostMapping(value={"qryDeliveryAndArriveTime"})
    public UccMallQryDeliveryAndArriveTimeAbilityRspBO qryDeliveryAndArriveTime(@RequestBody UccMallQryDeliveryAndArriveTimeAbilityReqBO reqBO) {
        UccMallQryDeliveryAndArriveTimeAbilityRspBO rspBO = new UccMallQryDeliveryAndArriveTimeAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!CollectionUtils.isEmpty((Collection)reqBO.getQryDeliveryAndArriveTimeBOList())) {
            HashMap<Long, DeliveryAndArriveTimeDetailBO> skuDeilveryArriveMaps = new HashMap<Long, DeliveryAndArriveTimeDetailBO>();
            for (QryDeliveryAndArriveTimeBO timeBO : reqBO.getQryDeliveryAndArriveTimeBOList()) {
                SupplierBusiPo supplierBusiPo;
                SupplierShopPo supplierShopPo;
                DeliveryAndArriveTimeDetailBO detailBO = new DeliveryAndArriveTimeDetailBO();
                String s = this.checkReq(timeBO);
                if (!StringUtils.isEmpty((Object)s)) {
                    detailBO.setDeliveryTime(null);
                    detailBO.setErrMessage(s);
                    skuDeilveryArriveMaps.put(timeBO.getSkuId(), detailBO);
                    continue;
                }
                String extSkuId = "";
                String extSpuId = "";
                if (timeBO.getSkuId() != null) {
                    UccSkuPo uccSkuPo = new UccSkuPo();
                    uccSkuPo.setSkuId(timeBO.getSkuId());
                    uccSkuPo.setSupplierShopId(timeBO.getSupplierShopId());
                    List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
                    if (!CollectionUtils.isEmpty(uccSkuPos)) {
                        extSkuId = uccSkuPos.get(0).getExtSkuId();
                        extSpuId = uccSkuPos.get(0).getExtSpuId();
                    } else {
                        log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u83b7\u53d6\u9884\u8ba1\u53d1\u8d27\u65e5\u671f\u548c\u9884\u8ba1\u9001\u8fbe\u65e5\u671f\u5b9e\u73b0\u7c7b]-\u672a\u67e5\u8be2\u5230\u5355\u4f4d\u4fe1\u606f\uff0c\u8f93\u5165\u5355\u54c1\u4fe1\u606f\u6709\u8bef");
                        detailBO.setDeliveryTime(null);
                        detailBO.setErrMessage("\u672a\u67e5\u8be2\u5230\u5355\u4f4d\u4fe1\u606f\uff0c\u8f93\u5165\u5355\u54c1\u4fe1\u606f\u6709\u8bef");
                        skuDeilveryArriveMaps.put(timeBO.getSkuId(), detailBO);
                        continue;
                    }
                }
                Long supplierId = null;
                String supplierCode = "";
                if (timeBO.getSupplierShopId() != null && (supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(timeBO.getSupplierShopId())) != null && (supplierBusiPo = this.supplierMapper.selectSupplierById(supplierShopPo.getSupplierId())) != null) {
                    supplierId = supplierBusiPo.getSupplierId();
                    supplierCode = supplierBusiPo.getSupplierCode();
                }
                try {
                    UccMallExpectDeliveryTimeQueryAtomReqBo uccExpectDeliveryTimeQueryAtomReqBo = new UccMallExpectDeliveryTimeQueryAtomReqBo();
                    BeanUtils.copyProperties((Object)timeBO, (Object)uccExpectDeliveryTimeQueryAtomReqBo);
                    uccExpectDeliveryTimeQueryAtomReqBo.setUrl(this.url);
                    uccExpectDeliveryTimeQueryAtomReqBo.setSkuId(extSkuId);
                    uccExpectDeliveryTimeQueryAtomReqBo.setSupplierId(supplierId);
                    uccExpectDeliveryTimeQueryAtomReqBo.setSupplierCode(supplierCode);
                    UccMallExpectDeliveryTimeQueryAtomRspBo uccExpectDeliveryTimeQueryAtomRspBo = this.uccExpectDeliveryTimeQueryAtomService.getExpectDeliveryTime(uccExpectDeliveryTimeQueryAtomReqBo);
                    if (StringUtils.isEmpty((Object)uccExpectDeliveryTimeQueryAtomRspBo.getResult())) {
                        detailBO.setArriveDate("-");
                    } else {
                        detailBO.setArriveDate(uccExpectDeliveryTimeQueryAtomRspBo.getResult());
                    }
                }
                catch (BusinessException e) {
                    log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u83b7\u53d6\u9884\u8ba1\u53d1\u8d27\u65e5\u671f\u548c\u9884\u8ba1\u9001\u8fbe\u65e5\u671f\u5b9e\u73b0\u7c7b]-\u8c03\u7528\u9891\u9053\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38|", (Throwable)e);
                    detailBO.setDeliveryTime(null);
                    detailBO.setErrMessage(e.getMessage());
                    skuDeilveryArriveMaps.put(timeBO.getSkuId(), detailBO);
                    continue;
                }
                UccMallCommdDetailsQryReqBO uccMallsCommdDetailsQryReqBO = new UccMallCommdDetailsQryReqBO();
                uccMallsCommdDetailsQryReqBO.setSkuId(extSkuId);
                uccMallsCommdDetailsQryReqBO.setSupplierCode(supplierCode);
                uccMallsCommdDetailsQryReqBO.setSpuId(extSpuId);
                UccMallCommdDetailsQryRspBO uccMallsCommdDetailsQryRspBO = this.uccMallCommdDetailsQryAtomService.qryCommdDetails(uccMallsCommdDetailsQryReqBO);
                if (!"0000".equals(uccMallsCommdDetailsQryRspBO.getRespCode())) {
                    log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u83b7\u53d6\u9884\u8ba1\u53d1\u8d27\u65e5\u671f\u548c\u9884\u8ba1\u9001\u8fbe\u65e5\u671f\u5b9e\u73b0\u7c7b]-\u83b7\u53d6\u9884\u8ba1\u53d1\u8d27\u65e5\u3001\u53d1\u8d27\u65e5\u671f\u5931\u8d25|{}", (Object)uccMallsCommdDetailsQryRspBO.getRespDesc());
                    detailBO.setDeliveryTime(null);
                    detailBO.setErrMessage(uccMallsCommdDetailsQryRspBO.getRespDesc());
                    skuDeilveryArriveMaps.put(timeBO.getSkuId(), detailBO);
                    continue;
                }
                if (uccMallsCommdDetailsQryRspBO.getCommdInfo() != null) {
                    if (uccMallsCommdDetailsQryRspBO.getCommdInfo().getNotJdCommdDetails() != null) {
                        detailBO.setDeliveryTime(Integer.valueOf(uccMallsCommdDetailsQryRspBO.getCommdInfo().getNotJdCommdDetails().getDeliveryTime()));
                        if (StringUtils.isEmpty((Object)uccMallsCommdDetailsQryRspBO.getCommdInfo().getNotJdCommdDetails().getDeliveryDate())) {
                            detailBO.setDeliveryDate("-");
                        } else {
                            detailBO.setDeliveryDate(uccMallsCommdDetailsQryRspBO.getCommdInfo().getNotJdCommdDetails().getDeliveryDate());
                        }
                    } else {
                        detailBO.setDeliveryTime(null);
                        detailBO.setDeliveryDate("-");
                    }
                } else {
                    detailBO.setDeliveryTime(null);
                    detailBO.setDeliveryDate("-");
                }
                skuDeilveryArriveMaps.put(timeBO.getSkuId(), detailBO);
            }
            if (!skuDeilveryArriveMaps.isEmpty()) {
                rspBO.setSkuDeilveryArriveMaps(skuDeilveryArriveMaps);
            }
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u81f3\u5c11\u4f20\u5165\u4e00\u6761\u5165\u53c2\u6570\u636e");
            return rspBO;
        }
        return rspBO;
    }

    private String checkReq(QryDeliveryAndArriveTimeBO timeBO) {
        String s = "";
        if (timeBO.getSupplierShopId() == null) {
            s = "\u8bf7\u8f93\u5165\u5e97\u94faID";
        }
        if (timeBO.getSkuId() == null) {
            s = "\u8bf7\u8f93\u5165\u5355\u54c1ID";
        }
        if (StringUtils.isEmpty((Object)timeBO.getNum())) {
            s = "\u8bf7\u8f93\u5165\u6570\u91cf";
        }
        return s;
    }
}

