/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccMallQrySkuRecommendAbilityService;
import com.tydic.commodity.mall.ability.bo.SkuRecommendInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuRecommendAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuRecommendAbilityRspBO;
import com.tydic.commodity.mall.busi.api.UccMallRecommendEsQryService;
import com.tydic.commodity.mall.busi.bo.UccMallRecommendEsReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallRecommendEsRspBO;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallQrySkuRecommendAbilityService"})
public class UccMallQrySkuRecommendAbilityServiceImpl
implements UccMallQrySkuRecommendAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallQrySkuRecommendAbilityServiceImpl.class);
    @Autowired
    private UccMallRecommendEsQryService uccMallRecommendEsQryService;
    @Value(value="${RECOMMEND_DEFAULT_USER_ID}")
    private String defaultUserId;

    @PostMapping(value={"qrySkuRecommend"})
    public UccMallQrySkuRecommendAbilityRspBO qrySkuRecommend(@RequestBody UccMallQrySkuRecommendAbilityReqBO reqBO) {
        UccMallRecommendEsRspBO esRspBO;
        log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u83b7\u53d6\u9996\u9875\u5546\u54c1\u4e2a\u6027\u5316\u63a8\u8350\u4fe1\u606f\u5b9e\u73b0]-qrySkuRecommend|\u5165\u53c2reqBO:{}", (Object)JSONObject.toJSONString((Object)reqBO));
        UccMallQrySkuRecommendAbilityRspBO rspBO = new UccMallQrySkuRecommendAbilityRspBO();
        UccMallRecommendEsReqBO esReqBO = new UccMallRecommendEsReqBO();
        List<Object> recommendInfoEsBOS = new ArrayList();
        if (reqBO.getUserId() != null) {
            esReqBO.setMemUserId(String.valueOf(reqBO.getUserId()));
            esRspBO = this.uccMallRecommendEsQryService.qryEsRecommendInfo(esReqBO);
            if (esRspBO != null && !CollectionUtils.isEmpty(esRspBO.getSkuRecommendInfoEsBOList())) {
                recommendInfoEsBOS = esRspBO.getSkuRecommendInfoEsBOList();
                rspBO.setTotal(esRspBO.getTotal());
            }
        }
        if (CollectionUtils.isEmpty(recommendInfoEsBOS)) {
            esReqBO.setMemUserId(this.defaultUserId);
            esRspBO = this.uccMallRecommendEsQryService.qryEsRecommendInfo(esReqBO);
            if (esRspBO != null && !CollectionUtils.isEmpty(esRspBO.getSkuRecommendInfoEsBOList())) {
                recommendInfoEsBOS = esRspBO.getSkuRecommendInfoEsBOList();
                rspBO.setTotal(esRspBO.getTotal());
            }
        }
        if (!CollectionUtils.isEmpty(recommendInfoEsBOS)) {
            List infoBOS = recommendInfoEsBOS.stream().map(e -> {
                SkuRecommendInfoBO nodeBO = new SkuRecommendInfoBO();
                BeanUtils.copyProperties((Object)e, (Object)nodeBO);
                if (e.getSalePrice() != null) {
                    nodeBO.setSalePrice(MoneyUtils.haoToYuan(e.getSalePrice()).setScale(2, 4));
                } else {
                    nodeBO.setSalePrice(BigDecimal.ZERO);
                }
                if (e.getMarketPrice() != null) {
                    nodeBO.setMarketPrice(MoneyUtils.haoToYuan(e.getMarketPrice()).setScale(2, 4));
                } else {
                    nodeBO.setMarketPrice(BigDecimal.ZERO);
                }
                return nodeBO;
            }).collect(Collectors.toList());
            rspBO.setSkuRecommendInfoBOList(infoBOS);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u83b7\u53d6\u9996\u9875\u5546\u54c1\u4e2a\u6027\u5316\u63a8\u8350\u4fe1\u606f\u5b9e\u73b0]-qrySkuRecommend|\u51fa\u53c2rspBO:{}", (Object)JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }
}

