/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.InterfaceCurrentStockQryService;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdStockBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentStockQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentStockQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuNumBO;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.utils.ESBParamUtil;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="uccCurrentStockQryService")
public class InterfaceCurrentStockQryServiceImpl
implements InterfaceCurrentStockQryService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceCurrentStockQryServiceImpl.class);

    @Override
    public InterfaceCurrentStockQryRspBO qryCommdCurrentStock(InterfaceCurrentStockQryReqBO reqBO) {
        try {
            List<String> skus = reqBO.getSkuNum().stream().map(InterfaceSkuNumBO::getSkuId).collect(Collectors.toList());
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_STOCK_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u5e93\u5b58\u6570\u91cf\u5b9e\u65f6\u67e5\u8be2\u670d\u52a1]-\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status={}], [http_url={}]", (Object)httpRetBean.getStatus(), (Object)PropertiesUtil.getProperty("ESB_QRY_SKU_STOCK_URL"));
                return this.setDefualtMsg(skus);
            }
            log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u5e93\u5b58\u6570\u91cf\u5b9e\u65f6\u67e5\u8be2\u670d\u52a1]-\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587|str:{}", (Object)httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                return this.setDefualtMsg(skus);
            }
            InterfaceCurrentStockQryRspBO resolveRsp = this.resolveRsp(returnString, skus);
            if (resolveRsp != null) {
                log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u5e93\u5b58\u6570\u91cf\u5b9e\u65f6\u67e5\u8be2\u670d\u52a1]-\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e|resolveRsp:{}", (Object)resolveRsp.toString());
            }
            return resolveRsp;
        }
        catch (Exception e) {
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u5e93\u5b58\u6570\u91cf\u5b9e\u65f6\u67e5\u8be2\u670d\u52a1]-\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5f02\u5e38|", (Throwable)e);
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private String initReqStr(InterfaceCurrentStockQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("skuNums", reqBO.getSkuNum());
        String area = "" + reqBO.getProvince() + "_" + reqBO.getCity() + "_" + reqBO.getCounty() + "";
        jsonObject.put("area", (Object)area);
        jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
        return jsonObject.toString();
    }

    private InterfaceCurrentStockQryRspBO resolveRsp(String returnString, List<String> skus) {
        InterfaceCurrentStockQryRspBO rspBO = new InterfaceCurrentStockQryRspBO();
        ArrayList<InterfaceCommdStockBO> list = new ArrayList<InterfaceCommdStockBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            rspBO.setResultCode(rspJsonObject.get((Object)"resultCode").toString());
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if (!"2007".equals(respCode)) {
                    log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u5e93\u5b58\u6570\u91cf\u5b9e\u65f6\u67e5\u8be2\u670d\u52a1]-\u8c03\u7528\u5916\u90e8\u5e73\u53f0 \u5e93\u5b58\u6570\u91cf\u5b9e\u65f6\u67e5\u8be2\u63a5\u53e3 \u9519\u8bef:{}", (Object)rspBO.getResultMessage());
                    return this.setDefualtMsg(skus);
                }
                rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                rspBO.setResultCode("8888");
                return rspBO;
            }
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                for (int i = 0; i < object.size(); ++i) {
                    JSONObject obj = (JSONObject)object.get(i);
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    InterfaceCommdStockBO jsonStringToJavaBean = (InterfaceCommdStockBO)JSON.parseObject((String)jsonStr, InterfaceCommdStockBO.class);
                    list.add(jsonStringToJavaBean);
                }
                rspBO.setCommdStockInfo(list);
            }
            List TrueRuslt = rspBO.getCommdStockInfo().stream().map(InterfaceCommdStockBO::getSkuId).collect(Collectors.toList());
            skus.removeAll(TrueRuslt);
            if (!CollectionUtils.isEmpty(skus)) {
                InterfaceCurrentStockQryRspBO bo = this.setDefualtMsg(skus);
                rspBO.getCommdStockInfo().addAll(bo.getCommdStockInfo());
            }
            return rspBO;
        }
        catch (Exception var10) {
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u5e93\u5b58\u6570\u91cf\u5b9e\u65f6\u67e5\u8be2\u670d\u52a1]-\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5f02\u5e38|", (Throwable)var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }

    public InterfaceCurrentStockQryRspBO setDefualtMsg(List<String> skus) {
        InterfaceCurrentStockQryRspBO rspBO = new InterfaceCurrentStockQryRspBO();
        if (!CollectionUtils.isEmpty(skus)) {
            ArrayList<InterfaceCommdStockBO> commdStockInfo = new ArrayList<InterfaceCommdStockBO>();
            for (String each : skus) {
                InterfaceCommdStockBO bo = new InterfaceCommdStockBO();
                bo.setStockStateId(34);
                bo.setRemainNum(0);
                bo.setStockStateDesc("\u65e0\u8d27");
                bo.setSkuId(each);
                commdStockInfo.add(bo);
            }
            rspBO.setCommdStockInfo(commdStockInfo);
        }
        rspBO.setRespCode("0000");
        rspBO.setResultCode("0000");
        rspBO.setSuccess(true);
        rspBO.setRespDesc("\u5e93\u5b58\u9ed8\u8ba4\u503c");
        return rspBO;
    }
}

