/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.InterfaceDeliveryTimeQryService;
import com.tydic.commodity.mall.atom.bo.InterfaceDeliveryTimeQueryReqBo;
import com.tydic.commodity.mall.atom.bo.InterfaceDeliveryTimeQueryRspBo;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.utils.ESBParamUtil;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InterfaceDeliveryTimeQueryServiceImpl
implements InterfaceDeliveryTimeQryService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceDeliveryTimeQueryServiceImpl.class);

    @Override
    public InterfaceDeliveryTimeQueryRspBo getPromiseTips(InterfaceDeliveryTimeQueryReqBo reqBo) {
        HttpRetBean httpRetBean;
        String reqEsbStr;
        String reqJson = this.initReqStr(reqBo);
        try {
            reqEsbStr = ESBParamUtil.getEsbReqStr(reqJson, reqBo.getSupplierCode(), "BUSINESS_COMMODITY");
            log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4]-\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5165\u53c2|reqEsbStr:{}", (Object)reqEsbStr);
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(reqBo.getUrl()), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
        }
        catch (Exception e) {
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4]-\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4http\u8bf7\u6c42\u5f02\u5e38|", (Throwable)e);
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4]-\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5931\u8d25|reqEsbStr:{}", (Object)reqEsbStr);
            throw new RuntimeException("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5931\u8d25");
        }
        log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4]-\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587|str:{}", (Object)httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((CharSequence)returnString)) {
            throw new RuntimeException("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        InterfaceDeliveryTimeQueryRspBo rspBo = this.resolveRsp(returnString);
        if (rspBo != null && !rspBo.isSuccess()) {
            throw new BusinessException(rspBo.getResultCode(), rspBo.getResultMessage());
        }
        return rspBo;
    }

    private String initReqStr(InterfaceDeliveryTimeQueryReqBo reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("skuId", (Object)reqBO.getSkuId());
        jsonObject.put("num", (Object)reqBO.getNum());
        jsonObject.put("province", (Object)reqBO.getProvince());
        jsonObject.put("city", (Object)reqBO.getCity());
        jsonObject.put("county", (Object)reqBO.getCounty());
        jsonObject.put("town", (Object)reqBO.getTown());
        return jsonObject.toString();
    }

    private InterfaceDeliveryTimeQueryRspBo resolveRsp(String returnString) {
        InterfaceDeliveryTimeQueryRspBo rspBo = new InterfaceDeliveryTimeQueryRspBo();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBo.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            rspBo.setResultCode(String.valueOf(rspJsonObject.get((Object)"resultCode")));
            rspBo.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            rspBo.setResult((String)rspJsonObject.get((Object)"result"));
            return rspBo;
        }
        catch (Exception var10) {
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4]-\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519|", (Throwable)var10);
            throw new RuntimeException("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

