/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.mall.atom.api.UccMallCommodityAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallBatchUpdateCommodityStatusReqBo;
import com.tydic.commodity.mall.atom.bo.UccMallBatchUpdateCommodityStatusRspBO;
import com.tydic.commodity.mall.atom.bo.UccMallBatchUpdateSkuBO;
import com.tydic.commodity.mall.atom.bo.UccMallBatchUpdateSkuStatusReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallBatchUpdateSkuStatusRspBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallCommdQueryDealMapper;
import com.tydic.commodity.mall.dao.UccMallSkuLogMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuQueryDealMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccSkuLogPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuQueryPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallCommodityAtomServiceImpl
implements UccMallCommodityAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallCommodityAtomServiceImpl.class);
    @Autowired
    private UccMallCommdQueryDealMapper uccMallCommdQueryDealMapper;
    @Autowired
    private UccMallSkuQueryDealMapper skuMapper;
    @Autowired
    private UccMallSkuLogMapper uccMallSkuLogMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();

    @Override
    public UccMallBatchUpdateCommodityStatusRspBO batchUpdateCommodityByCommodityId(UccMallBatchUpdateCommodityStatusReqBo reqBo) {
        UccMallBatchUpdateCommodityStatusRspBO uccMallsBatchUpdateCommodityStatusRspBO = new UccMallBatchUpdateCommodityStatusRspBO();
        try {
            this.uccMallCommdQueryDealMapper.batchUpdateCommodityByCommodityId(reqBo.getBoList(), reqBo.getSupplierShopId());
        }
        catch (Exception e) {
            LOGGER.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u5546\u54c1\u66f4\u65b0\u539f\u5b50\u670d\u52a1]-\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25|", (Throwable)e);
            throw new BusinessException(UccMallConstantsEnums.UPDATE_COMMODITY_STATUS_FAIL.code(), "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5f02\u5e38");
        }
        uccMallsBatchUpdateCommodityStatusRspBO.setRespCode("0000");
        uccMallsBatchUpdateCommodityStatusRspBO.setRespDesc("\u6210\u529f");
        return uccMallsBatchUpdateCommodityStatusRspBO;
    }

    @Override
    public UccMallBatchUpdateSkuStatusRspBO batchUpdateSkuInStatusByCommodityId(UccMallBatchUpdateSkuStatusReqBO reqBO) {
        UccMallBatchUpdateSkuStatusRspBO uccMallsBatchUpdateSkuStatusRspBO = new UccMallBatchUpdateSkuStatusRspBO();
        try {
            List<UccMallBatchUpdateSkuBO> uccMallsBatchUpdateSkuBOList = reqBO.getBoList();
            for (UccMallBatchUpdateSkuBO uccMallsBatchUpdateSkuBO : uccMallsBatchUpdateSkuBOList) {
                List<UccSkuQueryPO> skuQueryPO = this.skuMapper.selectSkuInfoByCommodityId(uccMallsBatchUpdateSkuBO.getCommodityId());
                UccSkuPo queryUccSkuPo = new UccSkuPo();
                for (UccSkuQueryPO SkuPo : skuQueryPO) {
                    Long batchId = this.uccBatchSequence.nextId();
                    queryUccSkuPo.setSkuId(SkuPo.getSkuId());
                    List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qerySku(queryUccSkuPo);
                    UccSkuPo uccSkuPo = uccSkuPos.get(0);
                    UccSkuLogPo po = new UccSkuLogPo();
                    BeanUtils.copyProperties((Object)uccSkuPo, (Object)po);
                    po.setBatchId(batchId);
                    po.setSkuSource(uccSkuPo.getSkuSource());
                    try {
                        this.uccMallSkuLogMapper.insert(po);
                    }
                    catch (Exception e) {
                        LOGGER.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u5546\u54c1\u66f4\u65b0\u539f\u5b50\u670d\u52a1]-\u63d2\u5165\u5355\u54c1\u65e5\u5fd7\u5f02\u5e38|", (Throwable)e);
                    }
                }
                this.skuMapper.batchUpdateSkuStatusBySkuId(skuQueryPO, reqBO.getStatus(), uccMallsBatchUpdateSkuBO.getSupplierShopId());
            }
        }
        catch (Exception e) {
            LOGGER.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u5546\u54c1\u66f4\u65b0\u539f\u5b50\u670d\u52a1]-\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25|", (Throwable)e);
            throw new BusinessException("BATCH_UPDATE_SKU_ERROR", "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u5931\u8d25");
        }
        uccMallsBatchUpdateSkuStatusRspBO.setRespCode("0000");
        uccMallsBatchUpdateSkuStatusRspBO.setRespDesc("\u6210\u529f");
        return uccMallsBatchUpdateSkuStatusRspBO;
    }

    @Override
    public UccMallBatchUpdateSkuStatusRspBO batchSkuInStatus(UccMallBatchUpdateSkuStatusReqBO reqBO) {
        UccMallBatchUpdateSkuStatusRspBO uccMallsBatchUpdateSkuStatusRspBO = new UccMallBatchUpdateSkuStatusRspBO();
        try {
            List<UccMallBatchUpdateSkuBO> uccMallsBatchUpdateSkuBOList = reqBO.getBoList();
            for (UccMallBatchUpdateSkuBO uccMallsBatchUpdateSkuBO : uccMallsBatchUpdateSkuBOList) {
                List<UccSkuQueryPO> skuQueryPO = this.skuMapper.selectSkuInfoByCommodityId(uccMallsBatchUpdateSkuBO.getCommodityId());
                this.skuMapper.batchUpdateSkuStatusBySkuId(skuQueryPO, reqBO.getStatus(), uccMallsBatchUpdateSkuBO.getSupplierShopId());
            }
        }
        catch (Exception e) {
            LOGGER.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u5546\u54c1\u66f4\u65b0\u539f\u5b50\u670d\u52a1]-\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25|", (Throwable)e);
            throw new BusinessException("BATCH_UPDATE_SKU_ERROR", "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u5931\u8d25");
        }
        uccMallsBatchUpdateSkuStatusRspBO.setRespCode("0000");
        uccMallsBatchUpdateSkuStatusRspBO.setRespDesc("\u6210\u529f");
        return uccMallsBatchUpdateSkuStatusRspBO;
    }
}

