/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.mall.atom.api.UccMallSkuPutCirAtomService;
import com.tydic.commodity.mall.atom.api.UccMallSkuPutCirLogAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallSkuPutCirLogReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallSkuPutCirReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallSkuPutCirRspBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuPutCirMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccSkuPutCirPo;
import com.tydic.commodity.mall.utils.DateUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallSkuPutCirAtomServiceImpl
implements UccMallSkuPutCirAtomService {
    @Autowired
    private UccMallSkuPutCirLogAtomService uccMallSkuPutCirLogAtomService;
    @Autowired
    private UccMallSkuPutCirMapper uccMallSkuPutCirMapper;
    private Sequence uccBrandSequence = Sequence.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallSkuPutCirAtomServiceImpl.class);

    @Override
    public UccMallSkuPutCirRspBO dealSkuPutCir(UccMallSkuPutCirReqBO reqBO) {
        UccMallSkuPutCirRspBO rspBO = new UccMallSkuPutCirRspBO();
        if (reqBO.getSupplierShopId() == null) {
            rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc("\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getSkuId() == null) {
            rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc("\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        UccMallSkuPutCirLogReqBO uccMallSkuPutCirLogReqBO = new UccMallSkuPutCirLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccMallSkuPutCirLogReqBO);
        try {
            this.uccMallSkuPutCirLogAtomService.addSkuPutCirLog(uccMallSkuPutCirLogReqBO);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        UccSkuPutCirPo skuPutCirPo = new UccSkuPutCirPo();
        skuPutCirPo.setState(2);
        skuPutCirPo.setSkuId(reqBO.getSkuId());
        skuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
        try {
            this.uccMallSkuPutCirMapper.modifyBySkuId(skuPutCirPo);
        }
        catch (Exception e) {
            throw new BusinessException(UccMallConstantsEnums.UPDATE_PUTCIR_STATUS_EXCEPTION.code(), "\u4fee\u6539\u5468\u671f\u8868\u72b6\u6001\u51fa\u9519");
        }
        UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuPutCirPo);
        if (reqBO.getPreDownTime() != null && !"".equals(reqBO.getPreDownTime())) {
            String preDownTime1 = reqBO.getPreDownTime();
            try {
                Date preDownTime = DateUtils.strToDate(preDownTime1);
                uccSkuPutCirPo.setPreDownTime(preDownTime);
            }
            catch (IllegalArgumentException e) {
                throw new ZTBusinessException(e.getMessage());
            }
        }
        if (reqBO.getPreUpTime() != null && !"".equals(reqBO.getPreUpTime())) {
            String preUpTime1 = reqBO.getPreUpTime();
            try {
                Date preUpTime = DateUtils.strToDate(preUpTime1);
                uccSkuPutCirPo.setPreUpTime(preUpTime);
            }
            catch (IllegalArgumentException e) {
                throw new ZTBusinessException(e.getMessage());
            }
        }
        if (reqBO.getRealUpTime() != null) {
            uccSkuPutCirPo.setRealUpTime(DateUtils.strToDate(reqBO.getRealUpTime()));
        }
        if (reqBO.getRealDownTime() != null) {
            uccSkuPutCirPo.setRealDownTime(DateUtils.strToDate(reqBO.getRealDownTime()));
        }
        if (reqBO.getState() == null) {
            uccSkuPutCirPo.setState(1);
        }
        try {
            uccSkuPutCirPo.setId(this.uccBrandSequence.nextId());
            this.uccMallSkuPutCirMapper.addSkuPutCir(uccSkuPutCirPo);
        }
        catch (Exception e) {
            LOGGER.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u5355\u54c1\u4e0a\u4e0b\u67b6\u5468\u671f\u7ba1\u7406\u539f\u5b50\u670d\u52a1]-\u65b0\u589e\u4e0a\u4e0b\u67b6\u5468\u671f\u4fe1\u606f\u5f02\u5e38|", (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
        rspBO.setRespDesc("\u6dfb\u52a0\u4e0a\u4e0b\u67b6\u5468\u671f\u4fe1\u606f\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

