/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.mall.ability.bo.RspUccMallBo;
import com.tydic.commodity.mall.atom.api.UccMallCommodityAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallBatchUpdateCommodityBO;
import com.tydic.commodity.mall.atom.bo.UccMallBatchUpdateCommodityStatusReqBo;
import com.tydic.commodity.mall.atom.bo.UccMallBatchUpdateSkuBO;
import com.tydic.commodity.mall.atom.bo.UccMallBatchUpdateSkuStatusReqBO;
import com.tydic.commodity.mall.busi.api.UccMallBatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.mall.busi.bo.UccMallBatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityBo;
import com.tydic.commodity.mall.busi.bo.UccMallSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.mall.constants.AuditResultStatusEnum;
import com.tydic.commodity.mall.constants.CommodityStatusEnum;
import com.tydic.commodity.mall.constants.ModelRuleConstant;
import com.tydic.commodity.mall.constants.SkuStatusEnum;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallCommodityLogMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallSkuLogMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccCommodityLogPO;
import com.tydic.commodity.mall.po.UccCommodityPo;
import com.tydic.commodity.mall.po.UccJoinQuerySkusPo;
import com.tydic.commodity.mall.po.UccSkuLogPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import com.tydic.commodity.mall.utils.UccMallValidatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallBatchUpdateCommoStatusForMarketServiceImpl
implements UccMallBatchUpdateCommoStatusForMarketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallBatchUpdateCommoStatusForMarketServiceImpl.class);
    @Autowired
    private UccMallCommodityAtomService uccMallCommodityAtomService;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallCommodityLogMapper uccMallCommodityLogMapper;
    @Autowired
    private UccMallSkuMapper skuMapper;
    @Autowired
    private UccMallSkuLogMapper uccMallSkuLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Resource(name="uccMalllmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer uccMalllmSyncCommodityMqServiceProvider;

    @Override
    public RspUccMallBo batchUpdateCommoStatusForMarket(UccMallBatchUpdateCommoStatusForMarketBO statusForMarketBO, CommodityStatusEnum commodityStatusEnum, SkuStatusEnum skuStatusEnum) {
        UccMallValidatorUtil.validator(statusForMarketBO);
        if (statusForMarketBO.getBusinessId() == null || statusForMarketBO.getBusinessId().length == 0) {
            throw new BusinessException(UccMallConstantsEnums.PARAMETER_ERROR.code(), "\u4e1a\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList uccCommodityLogPOS = Lists.newArrayList();
        ArrayList uccMallsBatchUpdateSkuBOS = Lists.newArrayList();
        ArrayList uccMallsBatchUpdateCommodityBOS = Lists.newArrayList();
        UccMallBatchUpdateSkuStatusReqBO uccMallBatchUpdateSkuStatusReqBO = new UccMallBatchUpdateSkuStatusReqBO();
        UccMallBatchUpdateCommodityStatusReqBo commodityStatusReqBo = new UccMallBatchUpdateCommodityStatusReqBo();
        long[] sequence = this.uccBatchSequence.nextIds(statusForMarketBO.getBusinessId().length);
        for (int i = 0; i < statusForMarketBO.getBusinessId().length; ++i) {
            UccCommodityPo uccCommodityPo = this.uccMallCommodityMapper.getCommodityById(statusForMarketBO.getBusinessId()[i]);
            if (uccCommodityPo == null) continue;
            if (commodityStatusEnum != null) {
                UccCommodityLogPO uccCommodityLogPO = new UccCommodityLogPO();
                BeanUtils.copyProperties((Object)uccCommodityPo, (Object)uccCommodityLogPO);
                uccCommodityLogPO.setBatchId(sequence[i]);
                uccCommodityLogPO.setAduitResult(statusForMarketBO.getReason());
                uccCommodityLogPOS.add(uccCommodityLogPO);
                UccMallBatchUpdateCommodityBO uccMallsBatchUpdateCommodityBO = new UccMallBatchUpdateCommodityBO();
                uccMallsBatchUpdateCommodityBO.setCommodityId(uccCommodityPo.getCommodityId());
                uccMallsBatchUpdateCommodityBO.setStatus(commodityStatusEnum.getStatus());
                commodityStatusReqBo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
                uccMallsBatchUpdateCommodityBOS.add(uccMallsBatchUpdateCommodityBO);
            }
            if (skuStatusEnum == null) continue;
            UccMallBatchUpdateSkuBO uccMallsBatchUpdateSkuBO = new UccMallBatchUpdateSkuBO();
            uccMallsBatchUpdateSkuBO.setCommodityId(statusForMarketBO.getBusinessId()[i]);
            uccMallsBatchUpdateSkuBO.setSupplierShopId(uccCommodityPo.getSupplierShopId());
            uccMallsBatchUpdateSkuBO.setStatus(skuStatusEnum.getStatus());
            uccMallsBatchUpdateSkuBOS.add(uccMallsBatchUpdateSkuBO);
        }
        if (skuStatusEnum != null) {
            UccJoinQuerySkusPo uccJoinQuerySkusPo = new UccJoinQuerySkusPo();
            uccJoinQuerySkusPo.setCommodityIdArrays(statusForMarketBO.getBusinessId());
            List<UccSkuPo> skuPos = this.skuMapper.queryJoinSkuByCommodityId(uccJoinQuerySkusPo);
            List<UccSkuLogPo> UccSkuLogPo2 = this.cloneUccSkuPo(skuPos);
            uccMallBatchUpdateSkuStatusReqBO.setStatus(skuStatusEnum.getStatus());
            uccMallBatchUpdateSkuStatusReqBO.setBoList(uccMallsBatchUpdateSkuBOS);
            this.processUpdateSkuAndLog(uccMallBatchUpdateSkuStatusReqBO, UccSkuLogPo2);
        }
        if (commodityStatusEnum != null) {
            commodityStatusReqBo.setBoList(uccMallsBatchUpdateCommodityBOS);
            this.processUpdateCommodityAndLog(commodityStatusReqBo, uccCommodityLogPOS);
        }
        if (!CollectionUtils.isEmpty((Collection)uccMallsBatchUpdateSkuBOS)) {
            UccMallSyncSceneCommodityToEsReqBO uccMallSyncSceneCommodityToEsReqBO = new UccMallSyncSceneCommodityToEsReqBO();
            uccMallSyncSceneCommodityToEsReqBO.setCommodityIds(uccMallsBatchUpdateSkuBOS.stream().map(UccMallBatchUpdateSkuBO::getCommodityId).collect(Collectors.toList()));
            uccMallSyncSceneCommodityToEsReqBO.setSupplierId(((UccMallBatchUpdateSkuBO)uccMallsBatchUpdateSkuBOS.get(0)).getSupplierShopId());
            uccMallSyncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            uccMallSyncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            uccMallSyncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
            this.uccMalllmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)((Object)uccMallSyncSceneCommodityToEsReqBO))));
        }
        LOGGER.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u6279\u91cf\u4fee\u6539\u5546\u54c1\u7684\u72b6\u6001\u5e76\u5904\u7406\u65e5\u5fd7\u7684\u670d\u52a1]-\u5904\u7406\u5546\u54c1\u5355\u54c1\u72b6\u6001\u5b8c\u6210");
        RspUccMallBo rspUccBo = new RspUccMallBo();
        rspUccBo.setRespCode("0000");
        rspUccBo.setRespDesc("\u6210\u529f");
        return rspUccBo;
    }

    @Override
    public void updateCommoApprovalStatus(UccMallCommodityBo uccMallCommodityBo, AuditResultStatusEnum auditResultStatusEnum) {
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        uccCommodityPo.setCommodityId(uccMallCommodityBo.getCommodityId());
        uccCommodityPo.setApprovalStatus(uccMallCommodityBo.getApprovalStatus());
        uccCommodityPo.setSupplierShopId(uccMallCommodityBo.getSupplierShopId());
        this.uccMallCommodityMapper.updateCommodity(uccCommodityPo);
    }

    private void processUpdateCommodityAndLog(UccMallBatchUpdateCommodityStatusReqBo reqBO, List<UccCommodityLogPO> commodityLogPOS) {
        try {
            if (CollectionUtils.isNotEmpty(commodityLogPOS)) {
                this.uccMallCommodityLogMapper.batchInsert(commodityLogPOS);
            }
            this.uccMallCommodityAtomService.batchUpdateCommodityByCommodityId(reqBO);
        }
        catch (Exception e) {
            LOGGER.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u6279\u91cf\u4fee\u6539\u5546\u54c1\u7684\u72b6\u6001\u5e76\u5904\u7406\u65e5\u5fd7\u7684\u670d\u52a1]-\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25|", (Throwable)e);
            throw new BusinessException(UccMallConstantsEnums.UPDATE_COMMODITY_STATUS_FAIL.code(), "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    private void processUpdateSkuAndLog(UccMallBatchUpdateSkuStatusReqBO reqBO, List<UccSkuLogPo> uccSkuLogPos) {
        try {
            if (CollectionUtils.isNotEmpty(uccSkuLogPos)) {
                this.uccMallSkuLogMapper.addSkuLog(uccSkuLogPos);
            }
            this.uccMallCommodityAtomService.batchSkuInStatus(reqBO);
        }
        catch (Exception e) {
            LOGGER.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u6279\u91cf\u4fee\u6539\u5546\u54c1\u7684\u72b6\u6001\u5e76\u5904\u7406\u65e5\u5fd7\u7684\u670d\u52a1]-\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25|", (Throwable)e);
            throw new BusinessException(UccMallConstantsEnums.UPDATE_COMMODITY_STATUS_FAIL.code(), "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    private List<UccSkuLogPo> cloneUccSkuPo(List<UccSkuPo> skuPos) {
        ArrayList uccSkuLogPos = Lists.newArrayList();
        for (UccSkuPo skuPo : skuPos) {
            Long batchId = this.uccBatchSequence.nextId();
            UccSkuLogPo uccSkuLogPo = new UccSkuLogPo();
            uccSkuLogPo.setBatchId(batchId);
            BeanUtils.copyProperties((Object)skuPo, (Object)uccSkuLogPo);
            uccSkuLogPos.add(uccSkuLogPo);
        }
        return uccSkuLogPos;
    }
}

