/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.busi.api.UccMallRecommendEsQryService;
import com.tydic.commodity.mall.busi.bo.SkuRecommendInfoEsBO;
import com.tydic.commodity.mall.busi.bo.UccMallRecommendEsReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallRecommendEsRspBO;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccMallRecommendEsQryServiceImpl
implements UccMallRecommendEsQryService {
    private static final Logger log = LoggerFactory.getLogger(UccMallRecommendEsQryServiceImpl.class);
    @Autowired
    private MallEsConfig mallEsConfig;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Value(value="${RECOMMEND_DEFAULT_USER_ID}")
    private String defaultUserId;
    @Value(value="${RECOMMEND_DEFAULT_DATA_CNT}")
    private String defaultDataCnt;

    @Override
    public UccMallRecommendEsRspBO qryEsRecommendInfo(UccMallRecommendEsReqBO reqBO) {
        String endPoint = "/" + this.mallEsConfig.getRecommendIndexName() + "/" + this.mallEsConfig.getRecommendIndexType() + "/_search";
        String queryString = this.getQueryString(reqBO);
        if (log.isDebugEnabled()) {
            log.debug("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u9996\u9875\u4e2a\u6027\u5316\u63a8\u8350\u67e5\u8be2es]-source---->:{}", (Object)queryString);
        }
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Response response = this.mallElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            UccMallRecommendEsRspBO uccMallRecommendEsRspBO = null;
            if (!StringUtils.isEmpty((Object)result)) {
                if (log.isDebugEnabled()) {
                    log.debug("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u9996\u9875\u4e2a\u6027\u5316\u63a8\u8350\u67e5\u8be2es]-result---->:{}", (Object)result);
                }
                uccMallRecommendEsRspBO = this.dealSearchData(result);
            } else {
                uccMallRecommendEsRspBO = new UccMallRecommendEsRspBO();
                uccMallRecommendEsRspBO.setTotal(0);
            }
            uccMallRecommendEsRspBO.setRespCode("0000");
            uccMallRecommendEsRspBO.setRespDesc("\u6210\u529f");
            return uccMallRecommendEsRspBO;
        }
        catch (IOException e) {
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u9996\u9875\u4e2a\u6027\u5316\u63a8\u8350\u67e5\u8be2es]-ioException|", (Throwable)e);
            return null;
        }
    }

    private String getQueryString(UccMallRecommendEsReqBO reqBO) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)this.defaultDataCnt);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)reqBO.getMemUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"userId", (String)reqBO.getMemUserId()));
        } else {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"userId", (String)this.defaultUserId));
        }
        if (!StringUtils.isEmpty((Object)reqBO.getSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (String)reqBO.getSkuId()));
        }
        String queryString = boolQueryBuilder.toString();
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)"selfOrder").order(SortOrder.ASC);
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        fieldSortBuilders.add(sortQuery);
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        queryJson.put("sort", (Object)JSONObject.parseArray((String)((Object)fieldSortBuilders).toString()));
        log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u9996\u9875\u4e2a\u6027\u5316\u63a8\u8350\u67e5\u8be2es]-getQueryString|queryJson.toString():{}", (Object)queryJson.toString());
        return queryJson.toString();
    }

    private UccMallRecommendEsRspBO dealSearchData(String result) {
        UccMallRecommendEsRspBO rspBO = new UccMallRecommendEsRspBO();
        log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u9996\u9875\u4e2a\u6027\u5316\u63a8\u8350\u67e5\u8be2es]-dealSearchData|result:{}", (Object)result);
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u9996\u9875\u4e2a\u6027\u5316\u63a8\u8350\u67e5\u8be2es]-\u603b\u8bb0\u5f55\u6570:{} \u8fd4\u56de\u8bb0\u5f55\u6570\u636e:{}", (Object)total, (Object)listObject.size());
        }
        if (listObject != null && listObject.size() > 0) {
            ArrayList<SkuRecommendInfoEsBO> skuRecommendInfoEsBOList = new ArrayList<SkuRecommendInfoEsBO>();
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                try {
                    SkuRecommendInfoEsBO skuRecommendInfoEsBO = (SkuRecommendInfoEsBO)JSON.toJavaObject((JSON)data, SkuRecommendInfoEsBO.class);
                    skuRecommendInfoEsBOList.add(skuRecommendInfoEsBO);
                    continue;
                }
                catch (Exception e) {
                    log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u9996\u9875\u4e2a\u6027\u5316\u63a8\u8350\u67e5\u8be2es]-\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5\u5f02\u5e38|", (Throwable)e);
                }
            }
            rspBO.setTotal(total);
            rspBO.setSkuRecommendInfoEsBOList(skuRecommendInfoEsBOList);
        }
        return rspBO;
    }
}

