/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.bo.UccMallGroupSkuProp;
import com.tydic.commodity.mall.ability.bo.UccMallLadderPriceBo;
import com.tydic.commodity.mall.ability.bo.UccMallSkuBo;
import com.tydic.commodity.mall.atom.api.UccMallDictionaryAtomService;
import com.tydic.commodity.mall.atom.api.UccQryCommdDetailAtomService;
import com.tydic.commodity.mall.atom.api.UccQrySkuInfoAtomService;
import com.tydic.commodity.mall.atom.bo.UccQrySkuDetailReqBO;
import com.tydic.commodity.mall.atom.bo.UccQrySkuDetailRspBO;
import com.tydic.commodity.mall.busi.api.UccQryCommodityDetailBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityBo;
import com.tydic.commodity.mall.busi.bo.UccQryCommdDetailReqBO;
import com.tydic.commodity.mall.busi.bo.UccQryCommdDetailRspBO;
import com.tydic.commodity.mall.constants.SkuEnum;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccCommodityDetailMapper;
import com.tydic.commodity.mall.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.mall.dao.UccMallBrandDealMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallOrgSkuMapper;
import com.tydic.commodity.mall.dao.UccMallRelGroupSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.dao.UccSkuDetailMapper;
import com.tydic.commodity.mall.dao.UccSkuSpecMapper;
import com.tydic.commodity.mall.po.DicDictionaryPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccCommodityDetailPO;
import com.tydic.commodity.mall.po.UccCommodityPo;
import com.tydic.commodity.mall.po.UccCommodityTypePo;
import com.tydic.commodity.mall.po.UccLadderPricePO;
import com.tydic.commodity.mall.po.UccMallOrgSkuPO;
import com.tydic.commodity.mall.po.UccMallSpuGroupRelSkuInfoPO;
import com.tydic.commodity.mall.po.UccSkuDetailPO;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.utils.DateUtils;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccQryCommodityDetailBusiServiceImpl
implements UccQryCommodityDetailBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQryCommodityDetailBusiServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccSkuMapper;
    @Autowired
    private UccMallCommodityMapper uccCommodityMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccQrySkuInfoAtomService uccQrySkuInfoAtomService;
    @Autowired
    private UccQryCommdDetailAtomService uccQryCommdDetailAtomService;
    @Autowired
    private UccMallDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccMallSupplierShopMapper supplierShopMapper;
    @Autowired
    private UccMallBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccCommodityDetailMapper uccCommodityDetailMapper;
    @Autowired
    private UccMallOrgSkuMapper uccMallOrgSkuMapper;
    @Autowired
    private UccMallRelGroupSkuMapper uccMallRelGroupSkuMapper;
    @Autowired
    private UccSkuDetailMapper uccSkuDetailMapper;

    @Override
    public UccQryCommdDetailRspBO qryCommodityDetail(UccQryCommdDetailReqBO reqBO) {
        UccQryCommdDetailRspBO rspBO = new UccQryCommdDetailRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        UccMallOrgSkuPO uccMallOrgSkuPO = new UccMallOrgSkuPO();
        uccMallOrgSkuPO.setVirtualSkuId(reqBO.getVirtualSkuId());
        UccMallOrgSkuPO modelBy = this.uccMallOrgSkuMapper.getModelBy(uccMallOrgSkuPO);
        if (modelBy == null) {
            rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        UccSkuPo qryCommd = new UccSkuPo();
        qryCommd.setSkuId(modelBy.getSkuId());
        List<UccSkuPo> listSku = this.uccSkuMapper.qerySku(qryCommd);
        if (listSku == null || listSku.size() == 0) {
            rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        reqBO.setCommodityId(listSku.get(0).getCommodityId());
        UccCommodityPo commdPo = this.uccCommodityMapper.qryCommdByCommdId(reqBO.getCommodityId(), reqBO.getSupplierShopId());
        if (commdPo == null) {
            rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        UccMallCommodityBo commodityBo = new UccMallCommodityBo();
        BeanUtils.copyProperties((Object)commdPo, (Object)commodityBo);
        commodityBo.setOrgId(modelBy.getOrgId());
        commodityBo.setOrgName(modelBy.getOrgName());
        UccCommodityDetailPO uccCommodityDetailPO = new UccCommodityDetailPO();
        uccCommodityDetailPO.setCommodityId(commodityBo.getCommodityId());
        uccCommodityDetailPO.setSupplierShopId(commodityBo.getSupplierShopId());
        SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(reqBO.getSupplierShopId());
        if (supplierShopPo != null) {
            commodityBo.setShopName(supplierShopPo.getShopName());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getSaleParams()) && reqBO.getSkuId() == null) {
            JSONObject keyParas = null;
            try {
                keyParas = JSONObject.parseObject((String)reqBO.getSaleParams());
            }
            catch (JSONException e) {
                LOGGER.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u5546\u54c1\u8be6\u7ec6\u4fe1\u606f]-can not cast to JSONObject|", (Throwable)e);
                throw new ZTBusinessException("can not cast to JSONObject");
            }
            if (!keyParas.isEmpty()) {
                Set keys = keyParas.entrySet();
                List<Long> skuIds = null;
                for (Map.Entry each : keys) {
                    skuIds = this.filterSkuId(reqBO.getCommodityId(), Long.parseLong((String)each.getKey()), Long.parseLong(each.getValue().toString()), reqBO.getSupplierShopId(), skuIds);
                    if (!CollectionUtils.isEmpty(skuIds)) continue;
                    rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5355\u54c1\u4fe1\u606f");
                    return rspBO;
                }
                if (skuIds.size() > 1) {
                    rspBO.setRespCode(UccMallConstantsEnums.NON_SPECIFICATIONS.code());
                    rspBO.setRespDesc("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5c5e\u6027\u4fe1\u606f\u6216\u5219\u5546\u54c1\u521b\u5efa\u4fe1\u606f\u9519\u8bef\u8bf7\u68c0\u67e5\u5546\u54c1\u4fe1\u606f\u662f\u5426\u6b63\u786e\uff01\uff01");
                    return rspBO;
                }
                reqBO.setSkuId((Long)skuIds.get(0));
            }
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuPo);
        List<UccSkuPo> listSkuInfo = this.uccSkuMapper.qerySku(uccSkuPo);
        ArrayList<UccMallSkuBo> listBo = new ArrayList<UccMallSkuBo>();
        UccQrySkuDetailReqBO uccQrySkuDetailReqBO = new UccQrySkuDetailReqBO();
        if (!CollectionUtils.isEmpty(listSkuInfo)) {
            for (UccSkuPo each : listSkuInfo) {
                List<UccMallSpuGroupRelSkuInfoPO> uccMallSpuGroupRelSkuInfoPOS;
                UccQrySkuDetailRspBO skuDetail;
                DicDictionaryPo po;
                UccMallSkuBo bo = new UccMallSkuBo();
                uccQrySkuDetailReqBO.setSkuId(each.getSkuId());
                uccQrySkuDetailReqBO.setSupplierShopId(each.getSupplierShopId());
                BeanUtils.copyProperties((Object)each, (Object)bo);
                bo.setShopName(commodityBo.getShopName());
                UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(each.getCommodityTypeId());
                if (uccCommodityTypePo != null) {
                    bo.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
                }
                if (each.getSkuStatus() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getSkuStatus().toString(), SkuEnum.SKU_STATUS.toString())) != null) {
                    bo.setSkuStatusDesc(po.getTitle());
                }
                if (each.getSkuSource() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getSkuSource().toString(), SkuEnum.SKU_SOURCE.toString())) != null) {
                    bo.setSkuSourceDesc(po.getTitle());
                }
                if (each.getCreateTime() != null) {
                    bo.setCreateTime(DateUtils.dateToStr(each.getCreateTime()));
                }
                if (each.getUpdateTime() != null) {
                    bo.setUpdateTime(DateUtils.dateToStr(each.getUpdateTime()));
                }
                UccSkuDetailPO uccSkuDetailPO = new UccSkuDetailPO();
                uccSkuDetailPO.setSkuId(bo.getSkuId());
                UccSkuDetailPO modelBy1 = this.uccSkuDetailMapper.getModelBy(uccSkuDetailPO);
                if (modelBy1 != null) {
                    bo.setSkuPcDetailUrl(modelBy1.getSkuPcDetailUrl());
                }
                if ("0000".equals((skuDetail = this.uccQrySkuInfoAtomService.queryInfomation(uccQrySkuDetailReqBO, modelBy)).getRespCode())) {
                    bo.setSkuStockInfo(skuDetail.getSkuStock());
                    bo.setSkuPutCirInfo(skuDetail.getSkuPutCir());
                    bo.setSkuPicInfoList(skuDetail.getSkuPic());
                    bo.setSkuSaleNumInfo(skuDetail.getSkuSaleNum());
                    bo.setSkuSpecInfoList(skuDetail.getSkuSpec());
                    bo.setSkuPriceInfo(skuDetail.getSkuprice());
                    bo.setChannels(skuDetail.getChannels());
                    if (!CollectionUtils.isEmpty(skuDetail.getLadderPrice())) {
                        ArrayList<UccMallLadderPriceBo> uccMallLadderPriceBos = new ArrayList<UccMallLadderPriceBo>();
                        for (UccLadderPricePO ladderPrice : skuDetail.getLadderPrice()) {
                            UccMallLadderPriceBo uccMallLadderPriceBo = new UccMallLadderPriceBo();
                            uccMallLadderPriceBo.setPrice(MoneyUtils.haoToYuan(ladderPrice.getPrice()));
                            uccMallLadderPriceBo.setStartPrice(new BigDecimal(ladderPrice.getStart()));
                            uccMallLadderPriceBo.setDiscount(ladderPrice.getDiscount());
                            if (ladderPrice.getStop() != null) {
                                uccMallLadderPriceBo.setStopPrice(new BigDecimal(ladderPrice.getStop()));
                            }
                            uccMallLadderPriceBos.add(uccMallLadderPriceBo);
                        }
                        bo.setUccMallLadderPriceBos(uccMallLadderPriceBos);
                    }
                }
                Long groupId = this.uccMallRelGroupSkuMapper.selectSpuGroupId(bo.getSkuId());
                bo.setSpuGroupId(groupId);
                if (groupId != null && !CollectionUtils.isEmpty(uccMallSpuGroupRelSkuInfoPOS = this.uccMallRelGroupSkuMapper.selectSpuGroupBySkuId(groupId))) {
                    String json = JSONArray.toJSONString(uccMallSpuGroupRelSkuInfoPOS);
                    List props = JSONArray.parseArray((String)json, UccMallGroupSkuProp.class);
                    bo.setGroupSkuProps(props);
                }
                bo.setAgreementId(modelBy.getAgreementId());
                bo.setAgreementName(modelBy.getAgreementName());
                bo.setPlatformAgreementCode(modelBy.getPlatformAgreementCode());
                bo.setEnterpriscAgreementCode(modelBy.getEnterpriscAgreementCode());
                if (modelBy.getPreDeliverDay() != null) {
                    bo.setPreDeliverDay(modelBy.getPreDeliverDay().toString());
                }
                bo.setMoq(modelBy.getMoq());
                if (modelBy.getAgreementItemStatus().equals("2")) {
                    bo.setSkuStatus(Integer.valueOf(5));
                }
                listBo.add(bo);
            }
            commodityBo.setSkuInfoList(listBo);
        }
        rspBO.setCommodity(commodityBo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    public List<Long> filterSkuId(Long commodityId, Long commodityPropDefId, Long propvaluelistid, Long supplierShopId, List<Long> skuIds) {
        return this.uccSkuSpecMapper.filterSkuIdByProp(commodityId, commodityPropDefId, propvaluelistid, supplierShopId, skuIds);
    }

    private String verify(UccQryCommdDetailReqBO reqBO) {
        if (reqBO.getVirtualSkuId() == null || reqBO.getVirtualSkuId() == 0L) {
            return "\u8bf7\u4f20\u5165\u865a\u62df\u5355\u54c1ID";
        }
        return this.enumVerify(reqBO);
    }

    private String enumVerify(UccQryCommdDetailReqBO reqBO) {
        Map<String, String> enumMap;
        if (!(reqBO.getSkuStatus() == null || (enumMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_STATUS.toString())) != null && enumMap.containsKey(reqBO.getSkuStatus().toString()))) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5355\u54c1\u72b6\u6001";
        }
        return "";
    }

    @Override
    public UccQryCommdDetailRspBO qryCommodityDetailBySkuId(UccQryCommdDetailReqBO reqBO) {
        UccQryCommdDetailRspBO rspBO = new UccQryCommdDetailRspBO();
        UccSkuPo qryCommd = new UccSkuPo();
        qryCommd.setSkuId(reqBO.getSkuId());
        List<UccSkuPo> listSku = this.uccSkuMapper.qerySku(qryCommd);
        reqBO.setCommodityId(listSku.get(0).getCommodityId());
        reqBO.setSupplierShopId(listSku.get(0).getSupplierShopId());
        UccCommodityPo commdPo = this.uccCommodityMapper.qryCommdByCommdId(reqBO.getCommodityId(), reqBO.getSupplierShopId());
        if (commdPo == null) {
            rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        UccMallCommodityBo commodityBo = new UccMallCommodityBo();
        BeanUtils.copyProperties((Object)commdPo, (Object)commodityBo);
        commodityBo.setOrgId(String.valueOf(listSku.get(0).getVendorId()));
        commodityBo.setOrgName(listSku.get(0).getVendorName());
        UccCommodityDetailPO uccCommodityDetailPO = new UccCommodityDetailPO();
        uccCommodityDetailPO.setCommodityId(commodityBo.getCommodityId());
        uccCommodityDetailPO.setSupplierShopId(commodityBo.getSupplierShopId());
        SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(reqBO.getSupplierShopId());
        if (supplierShopPo != null) {
            commodityBo.setShopName(supplierShopPo.getShopName());
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuPo);
        List<UccSkuPo> listSkuInfo = this.uccSkuMapper.qerySku(uccSkuPo);
        ArrayList<UccMallSkuBo> listBo = new ArrayList<UccMallSkuBo>();
        UccQrySkuDetailReqBO uccQrySkuDetailReqBO = new UccQrySkuDetailReqBO();
        if (!CollectionUtils.isEmpty(listSkuInfo)) {
            for (UccSkuPo each : listSkuInfo) {
                List<UccMallSpuGroupRelSkuInfoPO> uccMallSpuGroupRelSkuInfoPOS;
                UccQrySkuDetailRspBO skuDetail;
                DicDictionaryPo po;
                UccMallSkuBo bo = new UccMallSkuBo();
                uccQrySkuDetailReqBO.setSkuId(each.getSkuId());
                uccQrySkuDetailReqBO.setSupplierShopId(each.getSupplierShopId());
                BeanUtils.copyProperties((Object)each, (Object)bo);
                bo.setShopName(commodityBo.getShopName());
                UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(each.getCommodityTypeId());
                if (uccCommodityTypePo != null) {
                    bo.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
                }
                if (each.getSkuStatus() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getSkuStatus().toString(), SkuEnum.SKU_STATUS.toString())) != null) {
                    bo.setSkuStatusDesc(po.getTitle());
                }
                if (each.getSkuSource() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getSkuSource().toString(), SkuEnum.SKU_SOURCE.toString())) != null) {
                    bo.setSkuSourceDesc(po.getTitle());
                }
                if (each.getCreateTime() != null) {
                    bo.setCreateTime(DateUtils.dateToStr(each.getCreateTime()));
                }
                if (each.getUpdateTime() != null) {
                    bo.setUpdateTime(DateUtils.dateToStr(each.getUpdateTime()));
                }
                UccSkuDetailPO uccSkuDetailPO = new UccSkuDetailPO();
                uccSkuDetailPO.setSkuId(bo.getSkuId());
                UccSkuDetailPO modelBy1 = this.uccSkuDetailMapper.getModelBy(uccSkuDetailPO);
                if (modelBy1 != null) {
                    bo.setSkuPcDetailUrl(modelBy1.getSkuPcDetailUrl());
                }
                if ("0000".equals((skuDetail = this.uccQrySkuInfoAtomService.queryInfomationBySkuId(uccQrySkuDetailReqBO)).getRespCode())) {
                    bo.setSkuStockInfo(skuDetail.getSkuStock());
                    bo.setSkuPutCirInfo(skuDetail.getSkuPutCir());
                    bo.setSkuPicInfoList(skuDetail.getSkuPic());
                    bo.setSkuSaleNumInfo(skuDetail.getSkuSaleNum());
                    bo.setSkuSpecInfoList(skuDetail.getSkuSpec());
                    bo.setSkuPriceInfo(skuDetail.getSkuprice());
                    bo.setChannels(skuDetail.getChannels());
                    if (!CollectionUtils.isEmpty(skuDetail.getLadderPrice())) {
                        ArrayList<UccMallLadderPriceBo> uccMallLadderPriceBos = new ArrayList<UccMallLadderPriceBo>();
                        for (UccLadderPricePO ladderPrice : skuDetail.getLadderPrice()) {
                            UccMallLadderPriceBo uccMallLadderPriceBo = new UccMallLadderPriceBo();
                            uccMallLadderPriceBo.setPrice(MoneyUtils.haoToYuan(ladderPrice.getPrice()));
                            uccMallLadderPriceBo.setStartPrice(new BigDecimal(ladderPrice.getStart()));
                            uccMallLadderPriceBo.setDiscount(ladderPrice.getDiscount());
                            if (ladderPrice.getStop() != null) {
                                uccMallLadderPriceBo.setStopPrice(new BigDecimal(ladderPrice.getStop()));
                            }
                            uccMallLadderPriceBos.add(uccMallLadderPriceBo);
                        }
                        bo.setUccMallLadderPriceBos(uccMallLadderPriceBos);
                    }
                }
                Long groupId = this.uccMallRelGroupSkuMapper.selectSpuGroupId(bo.getSkuId());
                bo.setSpuGroupId(groupId);
                if (groupId != null && !CollectionUtils.isEmpty(uccMallSpuGroupRelSkuInfoPOS = this.uccMallRelGroupSkuMapper.selectSpuGroupBySkuId(groupId))) {
                    String json = JSONArray.toJSONString(uccMallSpuGroupRelSkuInfoPOS);
                    List props = JSONArray.parseArray((String)json, UccMallGroupSkuProp.class);
                    bo.setGroupSkuProps(props);
                }
                listBo.add(bo);
            }
            commodityBo.setSkuInfoList(listBo);
        }
        rspBO.setCommodity(commodityBo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

