/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.tydic.commodity.mall.ability.bo.QryCommodityDetailListReqBO;
import com.tydic.commodity.mall.ability.bo.UccCommodityInDetailBO;
import com.tydic.commodity.mall.busi.api.UccQryCommodityDetailListBusiService;
import com.tydic.commodity.mall.dao.UccMallOrgSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccQryCommodityListsInfoMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccCommodityInDetailPO;
import com.tydic.commodity.mall.po.UccQryCommoDetailPO;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.utils.ListCloneUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccQryCommodityDetailListBusiServiceImpl
implements UccQryCommodityDetailListBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQryCommodityDetailListBusiServiceImpl.class);
    @Autowired
    private UccQryCommodityListsInfoMapper qryCommodityListsInfoMapper;
    @Autowired
    private UccMallOrgSkuMapper uccMallOrgSkuMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;

    @Override
    public List<UccCommodityInDetailBO> qryCommodityDetailList(QryCommodityDetailListReqBO reqBO) {
        List<Long> skuIds = this.uccMallOrgSkuMapper.qrySkuLists(reqBO.getCommodityId());
        List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qeryBatchSkus(skuIds);
        List<Long> collect = uccSkuPos.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
        Long[] commodityIds = collect.toArray(new Long[collect.size()]);
        UccQryCommoDetailPO uccQryCommoDetailPO = new UccQryCommoDetailPO();
        uccQryCommoDetailPO.setSupplierShopId(uccSkuPos.get(0).getSupplierShopId());
        uccQryCommoDetailPO.setCommodityId(commodityIds);
        List<UccCommodityInDetailPO> uccCommodityInDetailBO = null;
        try {
            uccCommodityInDetailBO = this.qryCommodityListsInfoMapper.queryCommodityInfoList(uccQryCommoDetailPO);
        }
        catch (Exception e) {
            LOGGER.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u5546\u54c1\u7684\u76f8\u5173\u4fe1\u606f\u5b9e\u73b0\u7c7b]-\u67e5\u8be2\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u5931\u8d25,\u539f\u56e0|", (Throwable)e);
        }
        try {
            List<UccCommodityInDetailBO> commodityInDetailBOS = ListCloneUtils.clonePOListToBOListNotDate(uccCommodityInDetailBO, UccCommodityInDetailBO.class);
            return commodityInDetailBOS;
        }
        catch (Exception e) {
            LOGGER.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u67e5\u8be2\u5546\u54c1\u7684\u76f8\u5173\u4fe1\u606f\u5b9e\u73b0\u7c7b]-\u67e5\u8be2\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u5931\u8d25,\u539f\u56e0|", (Throwable)e);
            throw new BusinessException("8888", "\u67e5\u8be2\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u5931\u8d25");
        }
    }
}

