/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.centerdata.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.commodity.mall.busi.api.UccMallRecommendEsQryService;
import com.tydic.commodity.mall.busi.bo.EsUccSkuRecommendBO;
import com.tydic.commodity.mall.busi.bo.UccMallRecommendEsReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallRecommendEsRspBO;
import com.tydic.commodity.mall.centerdata.api.SyncDataSkuRecommendBusiService;
import com.tydic.commodity.mall.centerdata.bo.SyncDataSkuRecommendBusiReqBO;
import com.tydic.commodity.mall.centerdata.bo.SyncDataSkuRecommendBusiRspBO;
import com.tydic.commodity.mall.centerdata.dao.DcProdRecommendDdMapper;
import com.tydic.commodity.mall.centerdata.dao.DcProdRecommendMapper;
import com.tydic.commodity.mall.centerdata.po.DcProdRecommendDdPO;
import com.tydic.commodity.mall.centerdata.po.DcProdRecommendPO;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SyncDataSkuRecommendBusiServiceImpl
implements SyncDataSkuRecommendBusiService {
    private static final Logger log = LoggerFactory.getLogger(SyncDataSkuRecommendBusiServiceImpl.class);
    @Autowired
    private DcProdRecommendMapper dcProdRecommendMapper;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;
    @Autowired
    private DcProdRecommendDdMapper dcProdRecommendDdMapper;
    @Autowired
    private UccMallRecommendEsQryService uccMallRecommendEsQryService;

    @Override
    public SyncDataSkuRecommendBusiRspBO syncSkuRecommend(SyncDataSkuRecommendBusiReqBO reqBO) {
        log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u540c\u6b65\u6570\u636e\u4e2d\u5fc3\u5546\u54c1\u63a8\u8350\u76f8\u5173\u5b9e\u73b0]-syncSkuRecommend\u5165\u53c2|reqBO:{}", (Object)JSONObject.toJSONString((Object)reqBO));
        SyncDataSkuRecommendBusiRspBO rspBO = new SyncDataSkuRecommendBusiRspBO();
        DcProdRecommendPO qryPO = new DcProdRecommendPO();
        if (reqBO.getMemId() != null) {
            qryPO.setCgUserid(String.valueOf(reqBO.getMemId()));
        }
        qryPO.setOrderBy(" rand asc");
        List<DcProdRecommendPO> defaultPOS = this.dcProdRecommendMapper.getList(qryPO);
        if (CollectionUtils.isEmpty(defaultPOS)) {
            DcProdRecommendDdPO qryDdPO = new DcProdRecommendDdPO();
            if (reqBO.getMemId() != null) {
                qryDdPO.setCgUserid(String.valueOf(reqBO.getMemId()));
            }
            qryDdPO.setOrderBy(" rand asc");
            List<DcProdRecommendDdPO> defaultDdPOS = this.dcProdRecommendDdMapper.getList(qryDdPO);
            if (!CollectionUtils.isEmpty(defaultDdPOS)) {
                defaultPOS = defaultDdPOS.stream().map(e -> {
                    DcProdRecommendPO nodePO = new DcProdRecommendPO();
                    BeanUtils.copyProperties((Object)e, (Object)nodePO);
                    return nodePO;
                }).collect(Collectors.toList());
            }
        }
        if (!CollectionUtils.isEmpty(defaultPOS)) {
            try {
                List<EsUccSkuRecommendBO> esUccSkuRecommendBOS;
                Date operDate = new Date();
                List<String> userIds = defaultPOS.stream().map(DcProdRecommendPO::getCgUserid).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userIds)) {
                    this.deleteRecommendInfoFromEs(userIds);
                }
                if (!CollectionUtils.isEmpty(esUccSkuRecommendBOS = defaultPOS.stream().map(e -> {
                    EsUccSkuRecommendBO nodeBO = new EsUccSkuRecommendBO();
                    BeanUtils.copyProperties((Object)e, (Object)nodeBO);
                    nodeBO.setArticleTitle(e.getSkuName());
                    if (!StringUtils.isEmpty((Object)e.getSupplierId())) {
                        nodeBO.setSupplierId(Long.valueOf(e.getSupplierId()));
                    }
                    if (!StringUtils.isEmpty((Object)e.getSkuId())) {
                        nodeBO.setSkuId(Long.valueOf(e.getSkuId()));
                    }
                    if (!StringUtils.isEmpty((Object)e.getRand())) {
                        nodeBO.setSelfOrder(Integer.valueOf(e.getRand()));
                    }
                    if (!StringUtils.isEmpty((Object)e.getCgUserid())) {
                        nodeBO.setUserId(e.getCgUserid());
                    }
                    if (!StringUtils.isEmpty((Object)e.getSalePrice())) {
                        nodeBO.setSalePrice(Long.valueOf(e.getSalePrice()));
                    }
                    if (!StringUtils.isEmpty((Object)e.getMarketPrice())) {
                        nodeBO.setMarketPrice(Long.valueOf(e.getMarketPrice()));
                    }
                    nodeBO.setSkuSource("1");
                    nodeBO.setShopId(1L);
                    nodeBO.setCreateTime(operDate);
                    nodeBO.setIsDelete(0);
                    nodeBO.setCreateLoginId(9999L);
                    return nodeBO;
                }).collect(Collectors.toList()))) {
                    this.syncRecommendInfoToEs(esUccSkuRecommendBOS);
                }
            }
            catch (Exception e2) {
                log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u540c\u6b65\u6570\u636e\u4e2d\u5fc3\u5546\u54c1\u63a8\u8350\u76f8\u5173\u5b9e\u73b0]-\u540c\u6b65\u6570\u636e\u5f02\u5e38|", (Throwable)e2);
            }
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u540c\u6b65\u6570\u636e\u4e2d\u5fc3\u5546\u54c1\u63a8\u8350\u76f8\u5173\u5b9e\u73b0]-syncSkuRecommend\u51fa\u53c2|rspBO:{}", (Object)JSONObject.toJSONString((Object)((Object)rspBO)));
        return rspBO;
    }

    private void syncRecommendInfoToEs(List<EsUccSkuRecommendBO> esUccSkuRecommendBOS) {
        for (EsUccSkuRecommendBO esUccSkuRecommendBO : esUccSkuRecommendBOS) {
            String jsonStr = JSONObject.toJSONString((Object)esUccSkuRecommendBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String esId = esUccSkuRecommendBO.getUserId() + "_" + esUccSkuRecommendBO.getSkuId();
            String id = this.mallElasticsearchUtil.addData(this.mallEsConfig.getRecommendIndexName(), this.mallEsConfig.getRecommendIndexType(), esId, jsonObject);
            if (!StringUtils.isEmpty((Object)id) || StringUtils.isEmpty((Object)esUccSkuRecommendBO.getUserId())) continue;
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u540c\u6b65\u6570\u636e\u4e2d\u5fc3\u5546\u54c1\u63a8\u8350\u76f8\u5173\u5b9e\u73b0]-\u9996\u9875\u5546\u54c1\u63a8\u8350\u4fe1\u606f[{}|{}]\u540c\u6b65\u5931\u8d25!", (Object)esUccSkuRecommendBO.getUserId(), (Object)esUccSkuRecommendBO.getSkuId());
        }
    }

    private void deleteRecommendInfoFromEs(List<String> userIds) {
        for (String userId : userIds) {
            UccMallRecommendEsReqBO esReqBO = new UccMallRecommendEsReqBO();
            esReqBO.setMemUserId(userId);
            UccMallRecommendEsRspBO esRspBO = this.uccMallRecommendEsQryService.qryEsRecommendInfo(esReqBO);
            if (esRspBO == null || esRspBO.getTotal() == null || esRspBO.getTotal() <= 0) continue;
            log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u540c\u6b65\u6570\u636e\u4e2d\u5fc3\u5546\u54c1\u63a8\u8350\u76f8\u5173\u5b9e\u73b0]-deleteRecommendInfoFromEs|esRspBO.getTotal():{}", (Object)esRspBO.getTotal());
            JSONObject delConditionAfsJson = new JSONObject();
            delConditionAfsJson.put("userId", (Object)userId);
            JSONObject termAfsJson = new JSONObject();
            termAfsJson.put("term", (Object)delConditionAfsJson);
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)termAfsJson);
            JSONObject mustJson = new JSONObject();
            mustJson.put("must", (Object)jsonArray);
            JSONObject boolJson = new JSONObject();
            boolJson.put("bool", (Object)mustJson);
            JSONObject qryJson = new JSONObject();
            qryJson.put("query", (Object)boolJson);
            String endPoint = "/" + this.mallEsConfig.getRecommendIndexName() + "/" + this.mallEsConfig.getRecommendIndexType() + "/_delete_by_query";
            boolean deleteResult = this.mallElasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
            if (deleteResult) continue;
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u540c\u6b65\u6570\u636e\u4e2d\u5fc3\u5546\u54c1\u63a8\u8350\u76f8\u5173\u5b9e\u73b0]-\u573a\u666f\u4e0b\u7684\u5546\u54c1\u63a8\u8350\u4fe1\u606f[{}]\u5220\u9664\u5931\u8d25!", (Object)userId);
        }
    }
}

