/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.comb.impl;

import com.tydic.commodity.mall.ability.bo.UccMallOrderColumBo;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBarEsRspInfo;
import com.tydic.commodity.mall.busi.api.UccMallSearchEsQueryService;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsSQLRspBO;
import com.tydic.commodity.mall.comb.api.UccQueryPhraseEsAbilityService;
import com.tydic.commodity.mall.comb.bo.UccQueryPhraseEsAbilityReqBo;
import com.tydic.commodity.mall.comb.bo.UccQueryPhraseEsAbilityRspBo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccQueryPhraseEsAbilityServiceImpl
implements UccQueryPhraseEsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccQueryPhraseEsAbilityServiceImpl.class);
    @Autowired
    private UccMallSearchEsQueryService uccMallSearchEsQueryService;

    @Override
    public UccQueryPhraseEsAbilityRspBo searchInfo(UccQueryPhraseEsAbilityReqBo reqBo) {
        UccQueryPhraseEsAbilityRspBo uccQueryPhraseEsAbilityRspBo = new UccQueryPhraseEsAbilityRspBo();
        BoolQueryBuilder extBoolQueryBuilder = QueryBuilders.boolQuery();
        BoolQueryBuilder innerBoolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBo.getTermsQuery() != null && !reqBo.getTermsQuery().isEmpty()) {
            for (Map.Entry<String, Object> entry : reqBo.getTermsQuery().entrySet()) {
                if (entry.getValue() instanceof ArrayList) {
                    extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), (Object[])new Object[]{entry.getValue()}));
                    continue;
                }
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)entry.getKey(), (Object)entry.getValue()));
            }
        }
        if (reqBo.getMatchPhraseQuery() != null && !reqBo.getMatchPhraseQuery().isEmpty()) {
            for (Map.Entry<String, Object> entry : reqBo.getMatchPhraseQuery().entrySet()) {
                innerBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)entry.getKey(), (Object)entry.getValue()));
            }
            extBoolQueryBuilder.must((QueryBuilder)innerBoolQueryBuilder);
        }
        if (reqBo.getPhraseQuery() != null && !reqBo.getPhraseQuery().isEmpty()) {
            for (Map.Entry<String, Object> entry : reqBo.getPhraseQuery().entrySet()) {
                innerBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)entry.getValue(), (String[])new String[0]).field(entry.getKey()).type((Object)"phrase"));
            }
            extBoolQueryBuilder.must((QueryBuilder)innerBoolQueryBuilder);
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(reqBo.getOrderColum())) {
            for (UccMallOrderColumBo each : reqBo.getOrderColum()) {
                SortOrder orderType = SortOrder.DESC;
                if (each.getOrderType() != null && each.getOrderType() == 1) {
                    orderType = SortOrder.ASC;
                }
                fieldSortBuilders.add((FieldSortBuilder)SortBuilders.fieldSort((String)each.getOrderByColumn()).order(orderType));
            }
        }
        UccMallSearchEsSQLRspBO exxcuteDsl = new UccMallSearchEsSQLRspBO();
        exxcuteDsl.setBoolQueryBuilder(extBoolQueryBuilder);
        exxcuteDsl.setSortQuery(fieldSortBuilders);
        exxcuteDsl.setPageNo(reqBo.getPageNo());
        exxcuteDsl.setPageSize(reqBo.getPageSize());
        exxcuteDsl.setNeedKeyWorld(false);
        exxcuteDsl.setField(true);
        UccMallSearchEsRspBo searchEsRspBo = this.uccMallSearchEsQueryService.executeSQL(exxcuteDsl);
        if (searchEsRspBo == null || org.apache.commons.collections.CollectionUtils.isEmpty(searchEsRspBo.getUccMallCommodityRspBos())) {
            uccQueryPhraseEsAbilityRspBo.setRespCode("0000");
            uccQueryPhraseEsAbilityRspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e!");
            uccQueryPhraseEsAbilityRspBo.setPageNo(1);
            uccQueryPhraseEsAbilityRspBo.setTotal(0);
            uccQueryPhraseEsAbilityRspBo.setRecordsTotal(0);
            return uccQueryPhraseEsAbilityRspBo;
        }
        List<UccMallCommodityRspBo> commodityRspBos = searchEsRspBo.getUccMallCommodityRspBos();
        List<UccMallSearchBarEsRspInfo> result = this.convertRspBo(commodityRspBos);
        int size = reqBo.getPageSize();
        int no = reqBo.getPageNo();
        int totalPage = 0;
        Integer total = 0;
        totalPage = searchEsRspBo.getTotal() / size;
        total = searchEsRspBo.getTotal();
        uccQueryPhraseEsAbilityRspBo.setRespCode("0000");
        uccQueryPhraseEsAbilityRspBo.setRespDesc("\u6210\u529f");
        uccQueryPhraseEsAbilityRspBo.setPageNo(no);
        uccQueryPhraseEsAbilityRspBo.setRecordsTotal(total);
        uccQueryPhraseEsAbilityRspBo.setTotal(totalPage);
        uccQueryPhraseEsAbilityRspBo.setRows(result);
        return uccQueryPhraseEsAbilityRspBo;
    }

    private List<UccMallSearchBarEsRspInfo> convertRspBo(List<UccMallCommodityRspBo> commodityRspBos) {
        ArrayList<UccMallSearchBarEsRspInfo> searchBarEsRspInfos = new ArrayList<UccMallSearchBarEsRspInfo>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(commodityRspBos)) {
            for (UccMallCommodityRspBo commodityRspBo : commodityRspBos) {
                UccMallSearchBarEsRspInfo searchBarEsRspInfo = new UccMallSearchBarEsRspInfo();
                searchBarEsRspInfo.setCommodityId(Long.valueOf(commodityRspBo.getCommodity_id()));
                searchBarEsRspInfo.setSkuId(Long.valueOf(commodityRspBo.getSku_id()));
                searchBarEsRspInfo.setExtSkuId(commodityRspBo.getExt_sku_id());
                searchBarEsRspInfo.setPriPicUrl(commodityRspBo.getPicture_url());
                searchBarEsRspInfo.setAgreementPrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getAgreement_price())));
                searchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMarket_price())));
                searchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getSale_price())));
                searchBarEsRspInfo.setMemberPrice1(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price1())));
                searchBarEsRspInfo.setMemberPrice2(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price2())));
                searchBarEsRspInfo.setMemberPrice3(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price3())));
                searchBarEsRspInfo.setMemberPrice4(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price4())));
                searchBarEsRspInfo.setMemberPrice5(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price5())));
                searchBarEsRspInfo.setCommentNumber(commodityRspBo.getComment_number());
                searchBarEsRspInfo.setSkuName(commodityRspBo.getSku_name());
                searchBarEsRspInfo.setSupplierShopId(commodityRspBo.getSupplier_shop_id());
                searchBarEsRspInfo.setSupplierShopName(commodityRspBo.getShop_name());
                searchBarEsRspInfo.setSupplierId(String.valueOf(commodityRspBo.getSupplier_id()));
                searchBarEsRspInfo.setSupplierName(commodityRspBo.getSupplier_name());
                searchBarEsRspInfo.setSkuSource(Integer.valueOf(commodityRspBo.getSku_source()));
                searchBarEsRspInfo.setCommodityName(commodityRspBo.getCommodity_name());
                searchBarEsRspInfo.setCommdPicUrl(commodityRspBo.getCommd_pic_url());
                if (commodityRspBo.getEcommerce_sale() != null) {
                    searchBarEsRspInfo.setEcommerceSale(Long.valueOf(commodityRspBo.getEcommerce_sale().longValue()));
                }
                searchBarEsRspInfo.setExtendProperties(commodityRspBo.getExtendProperties());
                searchBarEsRspInfo.setVendorName(commodityRspBo.getVendor_name());
                searchBarEsRspInfo.setAgreementId(Long.valueOf(commodityRspBo.getAgreement_id()));
                searchBarEsRspInfo.setHighLightSkuName(commodityRspBo.getHighLightSkuName());
                searchBarEsRspInfo.setHighLightCommodityName(commodityRspBo.getHighLightCommodityName());
                searchBarEsRspInfo.setChannelIds(commodityRspBo.getChannel_id());
                searchBarEsRspInfo.setChannelNames(commodityRspBo.getChannel_Name());
                searchBarEsRspInfo.setTypeId(commodityRspBo.getType_id());
                searchBarEsRspInfo.setVendorId(commodityRspBo.getVendor_id());
                searchBarEsRspInfo.setL1CategoryName(commodityRspBo.getL1_category_name());
                searchBarEsRspInfo.setL2CategoryName(commodityRspBo.getL2_category_name());
                searchBarEsRspInfo.setL3CategoryName(commodityRspBo.getL3_category_name());
                searchBarEsRspInfo.setL1CategoryId(commodityRspBo.getL1_category_id());
                searchBarEsRspInfo.setL2CategoryId(commodityRspBo.getL2_category_id());
                searchBarEsRspInfo.setL3CategoryId(commodityRspBo.getL3_category_id());
                searchBarEsRspInfo.setBrandName(commodityRspBo.getBrand_name());
                if (!(CollectionUtils.isEmpty(commodityRspBo.getL1_category_name()) || CollectionUtils.isEmpty(commodityRspBo.getL2_category_name()) || CollectionUtils.isEmpty(commodityRspBo.getL3_category_name()))) {
                    StringBuffer catalogAllName = new StringBuffer(commodityRspBo.getL1_category_name().get(0));
                    catalogAllName.append("/").append(commodityRspBo.getL2_category_name().get(0)).append("/").append(commodityRspBo.getL3_category_name().get(0));
                    searchBarEsRspInfo.setCatalogAllName(catalogAllName.toString());
                }
                searchBarEsRspInfo.setMeasureName(commodityRspBo.getMeasure_name());
                searchBarEsRspInfo.setSpec(commodityRspBo.getSpec());
                searchBarEsRspInfos.add(searchBarEsRspInfo);
            }
        }
        return searchBarEsRspInfos;
    }
}

