/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.alibaba.fastjson.JSON;
import com.taobao.hsf.app.api.util.HSFApiConsumerBean;
import com.tydic.commodity.mall.comb.bo.RpcControllerReqBo;
import com.tydic.commodity.mall.comb.bo.RpcControllerRspBo;
import java.lang.reflect.Method;
import java.util.Map;
import lombok.extern.ohaotian.TempServiceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ucc/common/service"})
public class UccRpcController {
    private static final Logger log = LoggerFactory.getLogger(UccRpcController.class);
    @Autowired
    private ApplicationContext context;

    @PostMapping(value={"/rpc"})
    public RpcControllerRspBo qry(@RequestBody RpcControllerReqBo reqBo) throws Exception {
        String retStr = this.validateArg(reqBo);
        if (!ObjectUtil.isEmpty((Object)retStr)) {
            return this.failed(retStr);
        }
        String interClass = reqBo.getInterClass();
        String methodName = reqBo.getMethod();
        Class<?> aClass = null;
        try {
            aClass = Class.forName(interClass);
        }
        catch (ClassNotFoundException e) {
            return this.failed("\u8be5class(" + interClass + ")\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8be5maven\u4f9d\u8d56");
        }
        TempServiceInfo tempAnnotation = aClass.getAnnotation(TempServiceInfo.class);
        String version = tempAnnotation.version();
        String group = tempAnnotation.group();
        String rpcType = tempAnnotation.invokeTypes()[0].toString();
        log.debug("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-rpc\u8c03\u7528controller]-\u53c2\u6570|version:{}", (Object)version);
        log.debug("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-rpc\u8c03\u7528controller]-\u53c2\u6570|group:{}", (Object)group);
        log.debug("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-rpc\u8c03\u7528controller]-\u53c2\u6570|rpcType:{}", (Object)rpcType);
        Method method = ReflectUtil.getMethodByName(aClass, (String)methodName);
        if (method == null) {
            return this.failed("\u8be5\u670d\u52a1(" + interClass + ")\u7684\u65b9\u6cd5(" + methodName + ")\u4e0d\u5b58\u5728");
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> parameterType = parameterTypes[0];
        Object reqDataObj = reqBo.getData();
        String reqDataJson = JSON.toJSONString((Object)reqDataObj);
        log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-rpc\u8c03\u7528controller]-rpc\u8c03\u7528\u670d\u52a1\u5165\u53c2|reqDataJson:{}", (Object)reqDataJson);
        if ("HSF".equalsIgnoreCase(rpcType)) {
            try {
                HSFApiConsumerBean hsfApiConsumerBean = new HSFApiConsumerBean();
                hsfApiConsumerBean.setInterfaceName(interClass);
                hsfApiConsumerBean.setVersion(version);
                hsfApiConsumerBean.setGroup(group);
                hsfApiConsumerBean.init(true);
                Map map = (Map)JSON.parseObject((String)reqDataJson, Map.class);
                GenericService genericOrderService = (GenericService)hsfApiConsumerBean.getObject();
                Map resultMap = (Map)genericOrderService.$invoke(methodName, new String[]{parameterType.getName()}, new Object[]{map});
                resultMap.remove("class");
                String retJsonStr = JSON.toJSONString((Object)resultMap);
                log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-rpc\u8c03\u7528controller]-rpc\u8c03\u7528\u670d\u52a1\u51fa\u53c2|retJsonStr:{}", (Object)retJsonStr);
                return this.success(resultMap);
            }
            catch (Exception e) {
                return this.failed("[" + rpcType + "]\u670d\u52a1\u8c03\u7528\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        if ("SpringCloud".equalsIgnoreCase(rpcType)) {
            Object bean = null;
            try {
                bean = this.context.getBean(aClass);
            }
            catch (Exception e) {
                if (e.getMessage().contains("No qualifying bean of type")) {
                    return this.failed("\u8be5\u670d\u52a1(" + interClass + ")\u4e0d\u5b58\u5728");
                }
                return this.failed("getBean\u5f02\u5e38:" + e.getMessage());
            }
            Object parameterTarget = JSON.parseObject((String)reqDataJson, parameterType);
            Object invoke = ReflectUtil.invoke((Object)bean, (String)methodName, (Object[])new Object[]{parameterTarget});
            String jsonStr = JSON.toJSONString((Object)invoke);
            log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-rpc\u8c03\u7528controller]-rpc\u8c03\u7528\u670d\u52a1\u51fa\u53c2|jsonStr:{}", (Object)jsonStr);
            return this.success(invoke);
        }
        return this.failed("\u8be5\u670d\u52a1\u8c03\u7528\u7c7b\u578bRPC(" + rpcType + ")\u4e0d\u652f\u6301");
    }

    private RpcControllerRspBo failed(String errorMessage) {
        RpcControllerRspBo retBo = new RpcControllerRspBo();
        retBo.setCode("1");
        retBo.setMessage(errorMessage);
        return retBo;
    }

    private RpcControllerRspBo success(Object data) {
        RpcControllerRspBo retBo = new RpcControllerRspBo();
        retBo.setCode("0");
        retBo.setMessage("\u6210\u529f");
        retBo.setData(data);
        return retBo;
    }

    private String validateArg(RpcControllerReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getInterClass())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[interClass]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getMethod())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[method]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

