/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.config;

import com.alibaba.druid.pool.DruidDataSource;
import javax.sql.DataSource;
import org.apache.ibatis.logging.stdout.StdOutImpl;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(basePackages={"com.tydic.commodity.mall.centerdata.dao"}, sqlSessionTemplateRef="dataSqlSessionTemplate")
public class CenterDataSourceConfig {
    public static final String PACKAGE = "com.tydic.commodity.mall.centerdata.dao";
    public static final String MAPPER_LOCATION = "classpath:mybatis/mappers/data/*.xml";
    public static final String ENTITY_ALIASES = "com.tydic.commodity.mall.centerdata.po";
    @Value(value="${spring.datasource.datadb.driver-class-name}")
    private String driverClassName;
    @Value(value="${spring.datasource.datadb.url}")
    private String url;
    @Value(value="${spring.datasource.datadb.username}")
    private String user;
    @Value(value="${spring.datasource.datadb.password}")
    private String password;

    @Bean(name={"dataDataSource"})
    public DataSource dataDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setDriverClassName(this.driverClassName);
        dataSource.setUrl(this.url);
        dataSource.setUsername(this.user);
        dataSource.setPassword(this.password);
        return dataSource;
    }

    @Bean(name={"dataSqlSessionFactory"})
    public SqlSessionFactory dataSqlSessionFactory(@Qualifier(value="dataDataSource") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(dataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(MAPPER_LOCATION));
        sessionFactory.setTypeAliasesPackage(ENTITY_ALIASES);
        org.apache.ibatis.session.Configuration configuration = new org.apache.ibatis.session.Configuration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setCallSettersOnNulls(true);
        configuration.setLogImpl(StdOutImpl.class);
        sessionFactory.setConfiguration(configuration);
        return sessionFactory.getObject();
    }

    @Bean(name={"dataTransactionManager"})
    public DataSourceTransactionManager dataDataSourceTransactionManager(@Qualifier(value="dataDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"dataSqlSessionTemplate"})
    public SqlSessionTemplate dataSqlSessionTemplate(@Qualifier(value="dataSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

