/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.config;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MallElasticsearchUtil {
    private static final Logger log = LoggerFactory.getLogger(MallElasticsearchUtil.class);
    @Autowired
    private RestHighLevelClient client;
    private static ObjectMapper mapper = new ObjectMapper();
    private int batchSize = 1000;

    public String addData(String index, String type, String id, JSONObject object) {
        IndexRequest indexRequest = new IndexRequest(index, type, id);
        try {
            indexRequest.source(mapper.writeValueAsString((Object)object), XContentType.JSON);
            IndexResponse indexResponse = this.client.index(indexRequest, new Header[0]);
            return indexResponse.getId();
        }
        catch (Exception e) {
            log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-\u63d2\u5165\u6570\u636e\u5f02\u5e38|", (Throwable)e);
            return null;
        }
    }

    public void addBatch(String index, String type, List<Map<String, JSONObject>> list) {
        if (list.isEmpty()) {
            return;
        }
        int pages = (int)Math.ceil((double)list.size() / (double)this.batchSize);
        for (int i = 0; i < pages; ++i) {
            List<Map<String, JSONObject>> subList = this.subList(list, this.batchSize, i);
            this.dealBatch(index, type, subList);
            log.debug("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-\u6279\u91cf\u5904\u7406\u7b2c--{}\u6b21,\u5171\u8ba1:{}--\u6761...", (Object)i, (Object)subList.size());
        }
        log.debug("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-\u63d2\u5165\u5b8c\u6bd5\uff0c\u5171\u8ba1:{}--\u6761...", (Object)list.size());
    }

    public List<Map<String, JSONObject>> subList(List<Map<String, JSONObject>> dataList, int pageSize, int currentPage) {
        ArrayList<Map<String, JSONObject>> currentPageList = new ArrayList<Map<String, JSONObject>>();
        if (dataList != null && dataList.size() > 0) {
            int currIdx = currentPage > 0 ? currentPage * pageSize : 0;
            for (int i = 0; i < pageSize && i < dataList.size() - currIdx; ++i) {
                Map<String, JSONObject> map = dataList.get(currIdx + i);
                currentPageList.add(map);
            }
        }
        return currentPageList;
    }

    private void dealBatch(String index, String type, List<Map<String, JSONObject>> list) {
        BulkRequest request = new BulkRequest();
        list.forEach(map -> {
            for (Map.Entry entry : map.entrySet()) {
                IndexRequest indexRequest = new IndexRequest(index, type, (String)entry.getKey());
                try {
                    indexRequest.source(mapper.writeValueAsString(entry.getValue()), XContentType.JSON);
                }
                catch (JsonProcessingException e) {
                    log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-\u5904\u7406\u6279\u91cf\u63d2\u5165\u5f02\u5e38|", (Throwable)e);
                }
                request.add(indexRequest);
            }
        });
        try {
            BulkResponse responses = this.client.bulk(request, new Header[0]);
            if (responses.hasFailures()) {
                log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-\u6279\u91cf\u63d2\u5165\u6709\u5931\u8d25\u6570\u636e!");
            }
        }
        catch (IOException e) {
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-\u6279\u91cf\u63d2\u5165\u6709\u5931\u8d25\u5f02\u5e38|", (Throwable)e);
        }
    }

    public Boolean deleteDataByCondition(String endPoint, JSONObject qryJson) {
        boolean deleteResult = false;
        NStringEntity entity = new NStringEntity(qryJson.toJSONString(), ContentType.APPLICATION_JSON);
        try {
            JSONObject deleteResultJson;
            int deleteCount;
            Response response = this.client.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isNotBlank((CharSequence)result) && (deleteCount = (deleteResultJson = JSONObject.parseObject((String)result)).getInteger("deleted").intValue()) > 0) {
                deleteResult = true;
            }
        }
        catch (IOException e) {
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-\u6839\u636e\u6761\u4ef6\u5220\u9664ES\u6570\u636e\u5f02\u5e38|", (Throwable)e);
        }
        return deleteResult;
    }

    public Boolean updateData(String index, String type, String id, JSONObject qryJson) {
        boolean deleteResult = false;
        IndexRequest indexRequest = new IndexRequest(index, type, id);
        try {
            indexRequest.source(mapper.writeValueAsString((Object)qryJson), XContentType.JSON);
            UpdateRequest updateRequest = new UpdateRequest(index, type, id);
            updateRequest.doc(indexRequest);
            UpdateResponse rspose = this.client.update(updateRequest, new Header[0]);
            log.info("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-es\u66f4\u65b0\u7ed3\u679c\u4fe1\u606f|rspose:{}", (Object)JSONObject.toJSONString((Object)rspose));
        }
        catch (Exception e) {
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-es\u66f4\u65b0\u5f02\u5e38|" + e.getMessage());
            return false;
        }
        return deleteResult;
    }

    public String updateByQuery(String index, String type, String qryJson) {
        String endPoint = "/" + index + "/" + type + "/_update_by_query";
        if (log.isDebugEnabled()) {
            log.debug("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-\u4f9d\u636e\u67e5\u8be2\u6761\u4ef6\u66f4\u65b0|qryJson:{}", (Object)qryJson);
        }
        NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);
        try {
            Response response = this.client.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (Exception e) {
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-\u4f9d\u636e\u67e5\u8be2\u6761\u4ef6\u66f4\u65b0\u5f02\u5e38|", (Throwable)e);
            return "";
        }
    }

    public String doPostSendQuery(String index, String type, String qryJson) {
        String endPoint = "/" + index + "/" + type + "/_search";
        if (log.isDebugEnabled()) {
            log.debug("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-post\u67e5\u8be2\u8bf7\u6c42\u53d1\u9001|qryJson:{}", (Object)qryJson);
        }
        NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);
        try {
            Response response = this.client.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (Exception e) {
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-post\u67e5\u8be2\u8bf7\u6c42\u53d1\u9001\u5f02\u5e38|", (Throwable)e);
            return "";
        }
    }

    public void bulkPutIndex(String index, String type, List<Map<String, Object>> list, String id) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        int size = list.size();
        BulkRequest request = new BulkRequest();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = list.get(i);
            if (!StringUtils.isEmpty((CharSequence)id)) {
                request.add(new IndexRequest(index, type, String.valueOf(map.get(id))).source(map, XContentType.JSON));
                continue;
            }
            if (map.containsKey("id")) {
                request.add(new IndexRequest(index, type, String.valueOf(map.remove("id"))).source(map, XContentType.JSON));
                continue;
            }
            request.add(new IndexRequest(index, type, null).source(map, XContentType.JSON));
        }
        try {
            this.client.bulk(request, new Header[0]);
        }
        catch (IOException e) {
            log.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-es\u83b7\u53d6\u5ba2\u6237\u7aef\u5de5\u5177\u7c7b]-\u6279\u91cf\u63d2\u5165es\u5f02\u5e38|", (Throwable)e);
        }
    }

    public RestClient getLowLevelClient() {
        return this.client.getLowLevelClient();
    }
}

