/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.config;

import com.alibaba.druid.pool.DruidDataSource;
import javax.sql.DataSource;
import org.apache.ibatis.logging.stdout.StdOutImpl;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(basePackages={"com.tydic.smcsdk.dao"}, sqlSessionTemplateRef="smcsdkSqlSessionTemplate")
public class SmcsdkDataSourceConfig {
    public static final String PACKAGE = "com.tydic.smcsdk.dao";
    public static final String MAPPER_LOCATION = "classpath*:mappers/smcsdk/*.xml";
    public static final String ENTITY_ALIASES = "com.tydic.smcsdk.dao.po";
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverClassName;
    @Value(value="${spring.datasource.url}")
    private String url;
    @Value(value="${spring.datasource.username}")
    private String user;
    @Value(value="${spring.datasource.password}")
    private String password;

    @Bean(name={"smcsdkDataSource"})
    @Qualifier
    public DataSource smcsdkDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setDriverClassName(this.driverClassName);
        dataSource.setUrl(this.url);
        dataSource.setUsername(this.user);
        dataSource.setPassword(this.password);
        return dataSource;
    }

    @Bean(name={"smcsdkSqlSessionFactory"})
    @Qualifier
    public SqlSessionFactory smcsdkSqlSessionFactory(@Qualifier(value="smcsdkDataSource") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(dataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(MAPPER_LOCATION));
        sessionFactory.setTypeAliasesPackage(ENTITY_ALIASES);
        org.apache.ibatis.session.Configuration configuration = new org.apache.ibatis.session.Configuration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setCallSettersOnNulls(true);
        configuration.setLogImpl(StdOutImpl.class);
        sessionFactory.setConfiguration(configuration);
        return sessionFactory.getObject();
    }

    @Bean(name={"smcsdkTransactionManager"})
    @Qualifier
    public DataSourceTransactionManager smcsdkDataSourceTransactionManager(@Qualifier(value="smcsdkDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"smcsdkSqlSessionTemplate"})
    @Qualifier
    public SqlSessionTemplate smcsdkSqlSessionTemplate(@Qualifier(value="smcsdkSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

