/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.beanutils.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateConvert
implements Converter {
    private static final Logger logger = LoggerFactory.getLogger(DateConvert.class);

    public Object convert(Class aClass, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return simpleDateFormat.format(value);
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return new Date(longValue);
        }
        if (value instanceof String) {
            String dateStr = (String)value;
            Date endTime = null;
            try {
                String regexp1 = "([0-9]{4})-([0-1][0-9])-([0-3][0-9])T([0-2][0-9]):([0-6][0-9]):([0-6][0-9])";
                String regexp2 = "([0-9]{4})-([0-1][0-9])-([0-3][0-9]) ([0-2][0-9]):([0-6][0-9]):([0-6][0-9])";
                String regexp3 = "([0-9]{4})-([0-1][0-9])-([0-3][0-9])";
                if (dateStr.matches(regexp1)) {
                    dateStr = dateStr.split("T")[0] + " " + dateStr.split("T")[1];
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    endTime = sdf.parse(dateStr);
                    return endTime;
                }
                if (dateStr.matches(regexp2)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    endTime = sdf.parse(dateStr);
                    return endTime;
                }
                if (dateStr.matches(regexp3)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    endTime = sdf.parse(dateStr);
                    return endTime;
                }
                return dateStr;
            }
            catch (ParseException e) {
                logger.error("[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-\u65e5\u671f\u548cString\u7684\u8f6c\u6362\u65b9\u6cd5]-\u5f02\u5e38", (Throwable)e);
            }
        }
        return value;
    }
}

