/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.utils;

import com.tydic.commodity.mall.utils.MD5Util;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESBSignUtil {
    private static final Logger logger = LoggerFactory.getLogger(ESBSignUtil.class);
    private static final String ESB_KEY = "KEY";
    private static final String ESB_APP_KEY = "APP_KEY";
    private static final String ESB_SERIALNUMBER = "SERIALNUMBER";
    private static final String ESB_TIMESTAMP = "TIMESTAMP";
    private static final String ESB_TOKEN = "TOKEN";

    public static String getESBToken(String characterEncoding, String key, String appkey, String serialnumber, String timesTamp) {
        TreeMap<Object, Object> parameters = new TreeMap<Object, Object>();
        parameters.put(ESB_KEY, key);
        parameters.put(ESB_APP_KEY, appkey);
        parameters.put(ESB_SERIALNUMBER, serialnumber);
        parameters.put(ESB_TIMESTAMP, timesTamp);
        return ESBSignUtil.createToken(characterEncoding, parameters);
    }

    private static String createToken(String characterEncoding, SortedMap<Object, Object> parameters) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<Object, Object>> es = parameters.entrySet();
        for (Map.Entry<Object, Object> entry : es) {
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof String[]) {
                v = ((String[])v)[0];
            }
            if (null == v || "".equals(v) || ESB_TOKEN.equals(k) || ESB_KEY.equals(k)) continue;
            sb.append(k).append(v);
        }
        sb.append(parameters.get(ESB_KEY));
        return ESBSignUtil.getMD5Encode(characterEncoding, sb.toString());
    }

    private static String getMD5Encode(String characterEncoding, String md5Code) {
        return MD5Util.MD5Encode(md5Code, characterEncoding);
    }
}

