/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.utils;

import com.tydic.commodity.mall.utils.HSNHttpPoolHelper;
import com.tydic.commodity.mall.utils.HttpRetBean;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;

public class HSHttpHelper {
    private static final Log log = LogFactory.getLog(HSHttpHelper.class);

    public static HttpRetBean doUrlPostRequest(URI uri, Header[] headers, byte[] reqBody, String HpartyEnconding, boolean isHttps) throws ConnectException, IOException, URISyntaxException {
        return HSHttpHelper.doUrlExecuteRequest((HttpUriRequest)new HttpPost(uri), headers, reqBody, HpartyEnconding, isHttps);
    }

    public static HttpRetBean doUrlGetRequest(URI uri, Header[] headers, String HpartyEnconding, boolean isHttps) throws ConnectException, IOException, URISyntaxException {
        return HSHttpHelper.doUrlExecuteRequest((HttpUriRequest)new HttpGet(uri), headers, null, HpartyEnconding, isHttps);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HttpRetBean doUrlExecuteRequest(HttpUriRequest request, Header[] headers, byte[] reqBody, String HpartyEnconding, boolean isHttps) throws ConnectException, IOException, URISyntaxException {
        HttpRetBean httpRetBean;
        if (headers != null && headers.length > 0) {
            request.setHeaders(headers);
        }
        if (reqBody != null && request instanceof HttpEntityEnclosingRequestBase) {
            ByteArrayEntity entity = new ByteArrayEntity(reqBody);
            entity.setChunked(false);
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)entity);
        }
        HttpClient httpClient = null;
        ObjectPool httpClientPool = null;
        try {
            httpClientPool = isHttps ? HSNHttpPoolHelper.hsnHttpsObjectPoolBean.getHttpClientPool() : HSNHttpPoolHelper.hsnHttpObjectPoolBean.getHttpClientPool();
            httpClient = (HttpClient)httpClientPool.borrowObject();
            HttpResponse httpResponse = httpClient.execute(request);
            String returnData = null;
            InputStream inputStream = httpResponse.getEntity().getContent();
            if (inputStream == null) {
                returnData = null;
            } else {
                returnData = IOUtils.toString((InputStream)inputStream, (String)HpartyEnconding);
                inputStream.close();
            }
            httpRetBean = new HttpRetBean(httpResponse.getStatusLine().getStatusCode(), httpResponse.getAllHeaders(), returnData);
            if (httpClient == null) return httpRetBean;
        }
        catch (ConnectException e) {
            try {
                request.abort();
                throw e;
                catch (IOException e2) {
                    request.abort();
                    throw e2;
                }
                catch (URISyntaxException e3) {
                    request.abort();
                    throw e3;
                }
                catch (Exception e4) {
                    throw new RuntimeException(request.getURI().toString() + ":" + e4.getMessage(), e4);
                }
            }
            catch (Throwable throwable) {
                if (httpClient == null) throw throwable;
                try {
                    httpClientPool.returnObject(httpClient);
                    throw throwable;
                }
                catch (Exception e5) {
                    log.warn((Object)"[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-http\u8fde\u63a5\u6c60\u5de5\u5177\u7c7b]-HttpClient\u5bf9\u8c61\u5f52\u8fd8\u5f02\u5e38|", (Throwable)e5);
                }
                throw throwable;
            }
        }
        try {
            httpClientPool.returnObject((Object)httpClient);
            return httpRetBean;
        }
        catch (Exception e) {
            log.warn((Object)"[\u5546\u54c1\u8d2d\u7269\u4e2d\u5fc3-http\u8fde\u63a5\u6c60\u5de5\u5177\u7c7b]-HttpClient\u5bf9\u8c61\u5f52\u8fd8\u5f02\u5e38|", (Throwable)e);
        }
        return httpRetBean;
    }
}

