/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccOrgSkuMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccOrgSkuPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccAgrAutoSkuAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrAutoSkuAbilityBO;
import com.tydic.commodity.zone.ability.bo.UccAgrAutoSkuAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrAutoSkuAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccAgrAutoSkuBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrAutoSkuBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccAgrAutoSkuBusiRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrAutoSkuAbilityService"})
public class UccAgrAutoSkuAbilityServiceImpl
implements UccAgrAutoSkuAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrAutoSkuAbilityServiceImpl.class);
    @Autowired
    private UccAgrAutoSkuBusiService uccAgrAutoSkuBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccOrgSkuMapper uccOrgSkuMapper;

    @PostMapping(value={"dealUccAgrAutoSku"})
    public UccAgrAutoSkuAbilityRspBO dealUccAgrAutoSku(@RequestBody UccAgrAutoSkuAbilityReqBO reqBO) {
        UccAgrAutoSkuAbilityRspBO rspBO = new UccAgrAutoSkuAbilityRspBO();
        this.checkParameter(reqBO);
        String json = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        UccAgrAutoSkuBusiReqBO uccAgrAutoSkuBusiReqBO = (UccAgrAutoSkuBusiReqBO)((Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.parseObject((String)json, UccAgrAutoSkuBusiReqBO.class));
        log.info("UccAgrAutoSkuAbilityService:<<< \u534f\u8bae\u540c\u6b65ES \u5165\u53c2 >>>:uccAgrAutoSkuBusiReqBO=" + JSONObject.toJSONString((Object)((Object)uccAgrAutoSkuBusiReqBO)));
        UccAgrAutoSkuBusiRspBO uccAgrAutoSkuBusiRspBO = this.uccAgrAutoSkuBusiService.dealUccAgrAutoSku(uccAgrAutoSkuBusiReqBO);
        BeanUtils.copyProperties((Object)((Object)uccAgrAutoSkuBusiRspBO), (Object)rspBO);
        UccOrgSkuPO uccOrgSkuPO = new UccOrgSkuPO();
        uccOrgSkuPO.setAgreementId(reqBO.getAgreementId());
        List list = this.uccOrgSkuMapper.getList(uccOrgSkuPO);
        log.info("UccAgrAutoSkuAbilityService:<<< changeType08SyncES >>> before:" + JSONArray.toJSONString((Object)list));
        if (reqBO.getChangeType08() == 2 && reqBO.getAgreementInfo() != null && reqBO.getAgreementInfo().size() > 0) {
            for (UccAgrAutoSkuAbilityBO agrAutoSkuAbilityBO : reqBO.getAgreementInfo()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    UccOrgSkuPO orgSkuPO = (UccOrgSkuPO)iterator.next();
                    if (!agrAutoSkuAbilityBO.getAgreementDetailId().toString().equals(orgSkuPO.getAgreementDetailId().toString())) continue;
                    iterator.remove();
                }
            }
        }
        log.info("UccAgrAutoSkuAbilityService:\u8fc7\u6ee4\u524d\u7684List\u7684\u51fa\u53c2a" + list.toString());
        if (!CollectionUtils.isEmpty((Collection)list) && !UccConstants.AgrAutoSkuOperType.DELETE.equals(reqBO.getType())) {
            if (!CollectionUtils.isEmpty(uccAgrAutoSkuBusiReqBO.getAgreementInfo()) && UccConstants.AgrAutoSkuOperType.UPDATE.equals(reqBO.getType())) {
                List agreementDetailList = reqBO.getAgreementInfo().stream().map(UccAgrAutoSkuAbilityBO::getAgreementDetailId).collect(Collectors.toList());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    UccOrgSkuPO orgSkuPO = (UccOrgSkuPO)iterator.next();
                    if (agreementDetailList.contains(orgSkuPO.getAgreementDetailId())) continue;
                    iterator.remove();
                }
            }
            log.info("UccAgrAutoSkuAbilityService:\u8fc7\u6ee4\u540e\u7684List\u7684\u51fa\u53c2d\uff1a" + list.toString());
            List skuIds = list.stream().map(UccOrgSkuPO::getSkuId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(uccAgrAutoSkuBusiReqBO.getAgreementInfo()) && UccConstants.AgrAutoSkuOperType.INSERT.equals(reqBO.getType())) {
                skuIds = new ArrayList();
                skuIds = uccAgrAutoSkuBusiReqBO.getAgreementInfo().stream().map(UccAgrAutoSkuAbilityBO::getSkuId).collect(Collectors.toList());
                log.info("getAgreementInfo::skuIds=" + JSONObject.toJSONString(skuIds));
            }
            List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(skuIds);
            Map<Long, List<UccSkuPo>> collect = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            for (Long supplierShopId : collect.keySet()) {
                List commodityIds = collect.get(supplierShopId).stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(commodityIds);
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                syncSceneCommodityToEsReqBO.setCommodityType(2);
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
        return rspBO;
    }

    private void checkParameter(UccAgrAutoSkuAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO.getType())) {
            throw new BusinessException("8888", "type\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getAgreementId())) {
            throw new BusinessException("8888", "agreementId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (UccConstants.AgrAutoSkuOperType.INSERT.equals(reqBO.getType())) {
            if (!CollectionUtils.isEmpty((Collection)reqBO.getAgreementInfo())) {
                for (UccAgrAutoSkuAbilityBO uccAgrAutoSkuAbilityBO : reqBO.getAgreementInfo()) {
                    if (Objects.isNull(uccAgrAutoSkuAbilityBO.getSkuId())) {
                        throw new BusinessException("8888", "skuId\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (Objects.isNull(uccAgrAutoSkuAbilityBO.getAgreementDetailId())) {
                        throw new BusinessException("8888", "agreementDetailId\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (CollectionUtils.isEmpty((Collection)uccAgrAutoSkuAbilityBO.getLadderPrice())) {
                        if (Objects.isNull(uccAgrAutoSkuAbilityBO.getAgreementPrice())) {
                            throw new BusinessException("8888", "agreementPrice\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (Objects.isNull(uccAgrAutoSkuAbilityBO.getSalePrice())) {
                            throw new BusinessException("8888", "salePrice\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                    }
                    if (Objects.isNull(uccAgrAutoSkuAbilityBO.getPreDeliverDay())) {
                        uccAgrAutoSkuAbilityBO.setPreDeliverDay(Long.valueOf(0L));
                    }
                    if (Objects.isNull(uccAgrAutoSkuAbilityBO.getDiscount())) {
                        throw new BusinessException("8888", "discount\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((CharSequence)uccAgrAutoSkuAbilityBO.getMoq())) {
                        throw new BusinessException("8888", "moq\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((CharSequence)uccAgrAutoSkuAbilityBO.getOrgName())) {
                        throw new BusinessException("8888", "orgName\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!StringUtils.isEmpty((CharSequence)uccAgrAutoSkuAbilityBO.getAgreementItemStatus())) continue;
                    throw new BusinessException("8888", "agreementItemStatus\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        } else if (UccConstants.AgrAutoSkuOperType.DELETE.equals(reqBO.getType())) {
            if (Objects.isNull(reqBO.getAgreementId())) {
                throw new BusinessException("8888", "agreementID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (UccConstants.AgrAutoSkuOperType.UPDATE.equals(reqBO.getType())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getAgreementInfo())) {
                throw new BusinessException("8888", "agreementInfo\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (UccAgrAutoSkuAbilityBO uccAgrAutoSkuAbilityBO : reqBO.getAgreementInfo()) {
                if (!Objects.isNull(uccAgrAutoSkuAbilityBO.getAgreementDetailId())) continue;
                throw new BusinessException("8888", "agreementDetailId\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            throw new BusinessException("8888", "type\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }
}

