/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccOrgSkuMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccEvaluateSkuAbilityService;
import com.tydic.commodity.zone.ability.bo.SkuEvaluationInfoBO;
import com.tydic.commodity.zone.ability.bo.UccEvaluateSkuAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccEvaluateSkuAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccEvaluateSkuBusiService;
import com.tydic.commodity.zone.busi.bo.UccEvaluateSkuBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccEvaluateSkuBusiRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccEvaluateSkuAbilityService"})
public class UccEvaluateSkuAbilityServiceImpl
implements UccEvaluateSkuAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccEvaluateSkuAbilityServiceImpl.class);
    @Autowired
    private UccEvaluateSkuBusiService uccEvaluateSkuBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccOrgSkuMapper uccOrgSkuMapper;

    @PostMapping(value={"evaluateSku"})
    public UccEvaluateSkuAbilityRspBO evaluateSku(@RequestBody UccEvaluateSkuAbilityReqBO reqBO) {
        UccEvaluateSkuAbilityRspBO rspBO = new UccEvaluateSkuAbilityRspBO();
        UccEvaluateSkuBusiReqBO uccEvaluateSkuBusiReqBO = new UccEvaluateSkuBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)uccEvaluateSkuBusiReqBO));
        UccEvaluateSkuBusiRspBO uccEvaluateSkuBusiRspBO = this.uccEvaluateSkuBusiService.evaluateSku(uccEvaluateSkuBusiReqBO);
        BeanUtils.copyProperties((Object)((Object)uccEvaluateSkuBusiRspBO), (Object)rspBO);
        List skuIds = reqBO.getEvaluationInfos().stream().map(SkuEvaluationInfoBO::getSkuId).collect(Collectors.toList());
        List longs = this.uccOrgSkuMapper.qryVirtualSkuIds(skuIds);
        List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(longs);
        Map<Long, List<UccSkuPo>> collect = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        for (Long supplierShopId : collect.keySet()) {
            List commodityIds = collect.get(supplierShopId).stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds(commodityIds);
            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            syncSceneCommodityToEsReqBO.setCommodityType(2);
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5355\u54c1\u8bc4\u4ef7\u670d\u52a1]-\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25|", (Throwable)e);
            }
        }
        return rspBO;
    }
}

