/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.FindgoodsStatusEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.dao.UccFindgoodsOrderMapper;
import com.tydic.commodity.po.UccFindgoodsOrderPO;
import com.tydic.commodity.zone.ability.api.UccFindGoodsAuditListQryAbilityService;
import com.tydic.commodity.zone.ability.bo.UccFindGoodsAuditListQryAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccFindGoodsAuditListQryAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccFindgoodsAuditBO;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccFindGoodsAuditListQryAbilityService"})
public class UccFindGoodsAuditListQryAbilityServiceImpl
implements UccFindGoodsAuditListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccFindGoodsAuditListQryAbilityServiceImpl.class);
    @Autowired
    private UccFindgoodsOrderMapper uccFindgoodsOrderMapper;
    @Value(value="${FINDGOODS_AUDIT_STATION_ID}")
    private String auditOperId;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"getUccFindGoodsAuditList"})
    public UccFindGoodsAuditListQryAbilityRspBO getUccFindGoodsAuditList(@RequestBody UccFindGoodsAuditListQryAbilityReqBO reqBO) {
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5bfb\u8d27\u5355\u5ba1\u6279\u5217\u8868\u67e5\u8be2]-getUccFindGoodsAuditList\u5165\u53c2|reqBO:{}", (Object)JSONObject.toJSONString((Object)reqBO));
        UccFindGoodsAuditListQryAbilityRspBO rspBO = new UccFindGoodsAuditListQryAbilityRspBO();
        String checkResult = this.checkReqValidate(reqBO);
        if (!StringUtils.isEmpty((Object)checkResult)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(checkResult);
            return rspBO;
        }
        UccFindgoodsOrderPO uccFindgoodsOrderPo = new UccFindgoodsOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccFindgoodsOrderPo);
        if ("1".equals(reqBO.getLabelStatus())) {
            uccFindgoodsOrderPo.setFindgoodsStatus(Integer.valueOf(reqBO.getLabelStatus()));
        } else if ("2".equals(reqBO.getLabelStatus())) {
            if (reqBO.getFindgoodsStatus() != null) {
                uccFindgoodsOrderPo.setFindgoodsStatus(reqBO.getFindgoodsStatus());
            } else {
                List<Integer> statusList = Arrays.asList(FindgoodsStatusEnum.REJECT_STATUS.getStatus(), FindgoodsStatusEnum.PENDING_MATCH_STATUS.getStatus(), FindgoodsStatusEnum.END_STATUS.getStatus());
                uccFindgoodsOrderPo.setFindgoodsStatusList(statusList);
            }
        }
        uccFindgoodsOrderPo.setOrderBy("ufo.CREATE_TIME DESC");
        uccFindgoodsOrderPo.setDelFlag(UccConstants.Status.INVALID);
        uccFindgoodsOrderPo.setAuditOperId(this.auditOperId);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List orderPOList = this.uccFindgoodsOrderMapper.getAuditListPage(uccFindgoodsOrderPo, page);
        if (!CollectionUtils.isEmpty((Collection)orderPOList)) {
            Map findgoodsOrderTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap("FINDGOODS_ORDER_TYPE");
            Map findgoodsStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("FINDGOODS_STATUS");
            List orderBOList = orderPOList.stream().map(e -> {
                UccFindgoodsAuditBO nodeBO = new UccFindgoodsAuditBO();
                BeanUtils.copyProperties((Object)e, (Object)nodeBO);
                if (StringUtils.hasText((String)e.getFindgoodsType()) && findgoodsOrderTypeMap.containsKey(e.getFindgoodsType())) {
                    nodeBO.setFindgoodsTypeDesc((String)findgoodsOrderTypeMap.get(e.getFindgoodsType()));
                }
                nodeBO.setAuditStatus(e.getFindgoodsStatus());
                if (e.getFindgoodsStatus() != null && findgoodsStatusMap.containsKey(String.valueOf(e.getFindgoodsStatus()))) {
                    nodeBO.setAuditStatusDesc((String)findgoodsStatusMap.get(String.valueOf(e.getFindgoodsStatus())));
                }
                return nodeBO;
            }).collect(Collectors.toList());
            rspBO.setRows(orderBOList);
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
        } else {
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5bfb\u8d27\u5355\u5ba1\u6279\u5217\u8868\u67e5\u8be2]-getUccFindGoodsAuditList\u51fa\u53c2|rspBO:{}", (Object)JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }

    private String checkReqValidate(UccFindGoodsAuditListQryAbilityReqBO reqBO) {
        if (reqBO.getCreateTimeStart() != null && reqBO.getCreateTimeEnd() == null) {
            return "\u5df2\u9009\u521b\u5efa\u65f6\u95f4\u8d77\uff0c\u521b\u5efa\u65f6\u95f4\u6b62\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getCreateTimeStart() == null && reqBO.getCreateTimeEnd() != null) {
            return "\u5df2\u9009\u521b\u5efa\u65f6\u95f4\u6b62\uff0c\u521b\u5efa\u65f6\u95f4\u8d77\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getCreateTimeStart() != null && reqBO.getCreateTimeEnd() != null && reqBO.getCreateTimeStart().after(reqBO.getCreateTimeEnd())) {
            return "\u521b\u5efa\u65f6\u95f4\u8d77\u5fc5\u987b\u65e9\u4e8e\u521b\u5efa\u65f6\u95f4\u6b62";
        }
        if (reqBO.getFindgoodsEndTimeStart() != null && reqBO.getFindgoodsEndTimeEnd() == null) {
            return "\u5df2\u9009\u5bfb\u8d27\u7ed3\u675f\u65f6\u95f4\u8d77\uff0c\u5bfb\u8d27\u7ed3\u675f\u65f6\u95f4\u6b62\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getFindgoodsEndTimeStart() == null && reqBO.getFindgoodsEndTimeEnd() != null) {
            return "\u5df2\u9009\u5bfb\u8d27\u7ed3\u675f\u65f6\u95f4\u6b62\uff0c\u5bfb\u8d27\u7ed3\u675f\u65f6\u95f4\u8d77\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getFindgoodsEndTimeStart() != null && reqBO.getFindgoodsEndTimeEnd() != null && reqBO.getFindgoodsEndTimeStart().after(reqBO.getFindgoodsEndTimeEnd())) {
            return "\u5bfb\u8d27\u7ed3\u675f\u65f6\u95f4\u8d77\u5fc5\u987b\u65e9\u4e8e\u5bfb\u8d27\u7ed3\u675f\u65f6\u95f4\u6b62";
        }
        return null;
    }
}

