/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.FindgoodsDetailStatusEnum;
import com.tydic.commodity.base.enumType.FindgoodsMatchTypeEnum;
import com.tydic.commodity.dao.UccFindgoodsMatchSkuMapper;
import com.tydic.commodity.dao.UccFindgoodsOrderDetailMapper;
import com.tydic.commodity.po.UccFindgoodsMatchSkuPO;
import com.tydic.commodity.po.UccFindgoodsOrderDetailPO;
import com.tydic.commodity.zone.ability.api.UccFindGoodsOrderDetailListQryAbilityService;
import com.tydic.commodity.zone.ability.bo.UccFindGoodsOrderDetailBO;
import com.tydic.commodity.zone.ability.bo.UccFindGoodsOrderDetailListQryAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccFindGoodsOrderDetailListQryAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccSupplierFindgoodsTypeBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccFindGoodsOrderDetailListQryAbilityService"})
public class UccFindGoodsOrderDetailListQryAbilityServiceImpl
implements UccFindGoodsOrderDetailListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccFindGoodsOrderDetailListQryAbilityServiceImpl.class);
    @Autowired
    private UccFindgoodsOrderDetailMapper uccFindgoodsOrderDetailMapper;
    @Autowired
    private UccFindgoodsMatchSkuMapper uccFindgoodsMatchSkuMapper;

    @PostMapping(value={"getUccFindGoodsOrderDetailList"})
    public UccFindGoodsOrderDetailListQryAbilityRspBO getUccFindGoodsOrderDetailList(@RequestBody UccFindGoodsOrderDetailListQryAbilityReqBO reqBO) {
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5bfb\u8d27\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2]-getUccFindGoodsOrderDetailList\u5165\u53c2|reqBO:{}", (Object)JSONObject.toJSONString((Object)reqBO));
        UccFindGoodsOrderDetailListQryAbilityRspBO rspBO = new UccFindGoodsOrderDetailListQryAbilityRspBO();
        if (reqBO.getFindgoodsId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfb\u8d27\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccFindgoodsOrderDetailPO detailPO = new UccFindgoodsOrderDetailPO();
        detailPO.setFindgoodsId(reqBO.getFindgoodsId());
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSupplierFindgoodsTypeList())) {
            List findgoodsTypeList = reqBO.getSupplierFindgoodsTypeList().stream().map(UccSupplierFindgoodsTypeBO::getFindgoodsTypeCode).collect(Collectors.toList());
            detailPO.setTypeList(findgoodsTypeList);
        }
        detailPO.setDelFlag(UccConstants.Status.INVALID);
        detailPO.setOrderBy("DETAIL_FINDGOODS_ID ASC");
        List detailPOList = this.uccFindgoodsOrderDetailMapper.getListPage(detailPO, page);
        if (!CollectionUtils.isEmpty((Collection)detailPOList)) {
            UccFindgoodsMatchSkuPO matchSkuPO = new UccFindgoodsMatchSkuPO();
            matchSkuPO.setFindgoodsId(reqBO.getFindgoodsId());
            matchSkuPO.setDelFlag(UccConstants.Status.INVALID);
            List matchSkuPOS = this.uccFindgoodsMatchSkuMapper.getList(matchSkuPO);
            HashMap matchSupListMap = new HashMap();
            HashMap nomatchSupListMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)matchSkuPOS)) {
                matchSkuPOS.stream().forEach(e -> {
                    if (FindgoodsMatchTypeEnum.NO_MATCH_TYPE.getType().equals(e.getMatchTypeCode())) {
                        List<String> nomatchSupList = null;
                        nomatchSupList = nomatchSupListMap.containsKey(e.getDetailFindgoodsId()) ? (List)nomatchSupListMap.get(e.getDetailFindgoodsId()) : new ArrayList<String>();
                        nomatchSupList.add(e.getVendorName());
                        nomatchSupListMap.put(e.getDetailFindgoodsId(), nomatchSupList);
                    } else {
                        List<String> matchSupList = null;
                        matchSupList = matchSupListMap.containsKey(e.getDetailFindgoodsId()) ? (List)matchSupListMap.get(e.getDetailFindgoodsId()) : new ArrayList<String>();
                        matchSupList.add(e.getVendorName());
                        matchSupListMap.put(e.getDetailFindgoodsId(), matchSupList);
                    }
                });
            }
            BigDecimal divideAmount = new BigDecimal(UccConstants.UNIT_TRANS_MILLIFER);
            int i = 1;
            ArrayList<UccFindGoodsOrderDetailBO> detailBOList = new ArrayList<UccFindGoodsOrderDetailBO>();
            for (UccFindgoodsOrderDetailPO e2 : detailPOList) {
                UccFindGoodsOrderDetailBO nodeBO = new UccFindGoodsOrderDetailBO();
                BeanUtils.copyProperties((Object)e2, (Object)nodeBO);
                if (e2.getFindgoodsTaxationPrice() != null) {
                    BigDecimal taxation = BigDecimal.valueOf(e2.getFindgoodsTaxationPrice()).divide(divideAmount, 3, 4);
                    nodeBO.setFindgoodsTaxationPrice(taxation);
                }
                if (e2.getDetailStatus() != null) {
                    nodeBO.setDetailStatusDesc(FindgoodsDetailStatusEnum.getStatusDesc((Integer)e2.getDetailStatus()).getStatusDesc());
                }
                if (e2.getSeqNo() == null) {
                    nodeBO.setSeqNo(Integer.valueOf(i));
                }
                if (e2.getNomatchSupNum() == null) {
                    nodeBO.setNomatchSupNum(Integer.valueOf(0));
                }
                if (!CollectionUtils.isEmpty(matchSupListMap) && matchSupListMap.containsKey(e2.getDetailFindgoodsId())) {
                    nodeBO.setMatchSupList((List)matchSupListMap.get(e2.getDetailFindgoodsId()));
                }
                if (!CollectionUtils.isEmpty(nomatchSupListMap) && nomatchSupListMap.containsKey(e2.getDetailFindgoodsId())) {
                    nodeBO.setNoMatchSupList((List)nomatchSupListMap.get(e2.getDetailFindgoodsId()));
                }
                detailBOList.add(nodeBO);
                ++i;
            }
            rspBO.setRows(detailBOList);
            if (page.getTotalCount() != 0) {
                rspBO.setRecordsTotal(page.getTotalCount());
            } else {
                rspBO.setRecordsTotal(detailBOList.size());
            }
            if (page.getTotalCount() != 0) {
                rspBO.setTotal(page.getTotalPages());
            } else {
                rspBO.setTotal(1);
            }
        } else {
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5bfb\u8d27\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2]-getUccFindGoodsOrderDetailList\u51fa\u53c2|rspBO:{}", (Object)JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }
}

