/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.cfc.ability.api.CfcQryImportTemplateListAbilityService;
import com.tydic.cfc.ability.bo.CfcImportTemplateBO;
import com.tydic.cfc.ability.bo.CfcQryImportTemplateListAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryImportTemplateListAbilityRspBO;
import com.tydic.commodity.base.constant.FileUpLoad;
import com.tydic.commodity.zone.ability.api.UccFindgoodsDetailExportNoSubmitAbilityService;
import com.tydic.commodity.zone.ability.bo.UccFindGoodsDetailNoSubmitBO;
import com.tydic.commodity.zone.ability.bo.UccFindgoodsDetailExportNoSubmitAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccFindgoodsDetailExportNoSubmitAbilityRspBO;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccFindgoodsDetailExportNoSubmitAbilityService"})
public class UccFindgoodsDetailExportNoSubmitAbilityServiceImpl
implements UccFindgoodsDetailExportNoSubmitAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccFindgoodsDetailExportNoSubmitAbilityServiceImpl.class);
    private static final String XLSX = "xlsx";
    private static final String XLS = "xls";
    @Autowired
    private FileUpLoad fileUpLoad;
    @Autowired
    private CfcQryImportTemplateListAbilityService qryImportTemplateListAbilityService;

    @PostMapping(value={"exportNoSubmitDetail"})
    public UccFindgoodsDetailExportNoSubmitAbilityRspBO exportNoSubmitDetail(@RequestBody UccFindgoodsDetailExportNoSubmitAbilityReqBO reqBO) {
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u672a\u4fdd\u5b58\u7684\u5bfb\u8d27\u5355\u660e\u7ec6\u5217\u8868\u5bfc\u51fa]-exportNoSubmitDetail::\u5165\u53c2|reqBO:{}", (Object)JSONObject.toJSONString((Object)reqBO));
        UccFindgoodsDetailExportNoSubmitAbilityRspBO rspBO = new UccFindgoodsDetailExportNoSubmitAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getNoSubmitDetailList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8981\u5bfc\u51fa\u7684\u5bfb\u8d27\u5355\u660e\u7ec6\u5217\u8868\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        CfcQryImportTemplateListAbilityReqBO abilityReqBO = new CfcQryImportTemplateListAbilityReqBO();
        abilityReqBO.setCenter("UCC");
        abilityReqBO.setImportTemplateNo("XHDDMB");
        abilityReqBO.setPageNo(Integer.valueOf(1));
        abilityReqBO.setPageSize(Integer.valueOf(10));
        CfcQryImportTemplateListAbilityRspBO abilityRspBO = this.qryImportTemplateListAbilityService.qryImportTemplateList(abilityReqBO);
        String templateUrl = "";
        if (abilityRspBO != null && !CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
            templateUrl = ((CfcImportTemplateBO)abilityRspBO.getRows().get(0)).getImportTemplateUrl();
        }
        Workbook workbook = this.getTemplateExcelFile(templateUrl);
        ArrayList<Map<Integer, Object>> data = new ArrayList<Map<Integer, Object>>();
        int cnt = 1;
        for (UccFindGoodsDetailNoSubmitBO e : reqBO.getNoSubmitDetailList()) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            if (e.getSeqNo() != null) {
                map.put(1, e.getSeqNo());
            } else {
                map.put(1, cnt);
            }
            map.put(2, e.getMaterialName());
            map.put(3, e.getSpecModel());
            map.put(4, e.getBrandName());
            map.put(5, e.getManufacturer());
            map.put(6, e.getMeasureName());
            map.put(7, e.getFindgoodsNum());
            map.put(8, e.getFindgoodsTaxationPrice());
            map.put(9, e.getDeliverDay());
            map.put(10, e.getSupplyStatus());
            map.put(11, e.getUseScene());
            map.put(12, e.getSpecialInstruct());
            map.put(13, e.getReqDepartment());
            map.put(14, e.getCustomizeReq());
            map.put(15, e.getFindgoodsTypeName());
            data.add(map);
            ++cnt;
        }
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u672a\u4fdd\u5b58\u7684\u5bfb\u8d27\u5355\u660e\u7ec6\u5217\u8868\u5bfc\u51fa]-exportNoSubmitDetail::data:{}", (Object)JSONObject.toJSONString(data));
        if (workbook != null) {
            CellStyle cellStyle = this.setBodyCellStyle(workbook);
            this.createImportBodyContent(workbook, cellStyle, data);
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                workbook.write((OutputStream)outputStream);
                byte[] bytes = outputStream.toByteArray();
                String fileNamePre = "\u672a\u4fdd\u5b58\u5bfb\u8d27\u5355\u660e\u7ec6\u5217\u8868\u5bfc\u51fa";
                String fileUrl = this.fileUpLoad.upload(fileNamePre + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()).trim().replace("-", "").replace(":", "").replace(" ", ""), bytes, ".xlsx");
                workbook.close();
                outputStream.close();
                rspBO.setDownloadUrl(fileUrl);
            }
            catch (Exception ex) {
                log.error("[\u5546\u54c1\u4e2d\u5fc3-\u672a\u4fdd\u5b58\u7684\u5bfb\u8d27\u5355\u660e\u7ec6\u5217\u8868\u5bfc\u51fa]-\u5bfc\u51faExcel\u51fa\u73b0\u5f02\u5e38|", (Throwable)ex);
            }
        }
        rspBO.setNoSubmitDetailList(reqBO.getNoSubmitDetailList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u672a\u4fdd\u5b58\u7684\u5bfb\u8d27\u5355\u660e\u7ec6\u5217\u8868\u5bfc\u51fa]-exportNoSubmitDetail::\u51fa\u53c2|rspBO:{}", (Object)JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }

    private Workbook getTemplateExcelFile(String filePath) {
        XSSFWorkbook workbook;
        block12: {
            workbook = null;
            InputStream is = null;
            try {
                URL url = new URL(filePath);
                URLConnection conn = url.openConnection();
                is = conn.getInputStream();
                if (filePath.toLowerCase().endsWith(XLSX)) {
                    workbook = new XSSFWorkbook(is);
                    break block12;
                }
                if (filePath.toLowerCase().endsWith(XLS)) {
                    workbook = new HSSFWorkbook(is);
                    break block12;
                }
                throw new ZTBusinessException("\u4e0d\u662f\u88ab\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u8bfb\u53d6excel\u5931\u8d25");
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {
                    log.error("[\u5546\u54c1\u4e2d\u5fc3-\u672a\u4fdd\u5b58\u7684\u5bfb\u8d27\u5355\u660e\u7ec6\u5217\u8868\u5bfc\u51fa]-is.close() \u5f02\u5e38|", (Throwable)e);
                }
            }
        }
        return workbook;
    }

    private CellStyle setBodyCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)12);
        font.setColor((short)Short.MAX_VALUE);
        cellStyle.setLocked(true);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        cellStyle.setFillBackgroundColor(IndexedColors.WHITE.getIndex());
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setFont(font);
        return cellStyle;
    }

    private void createImportBodyContent(Workbook workbook, CellStyle cellStyle, List<Map<Integer, Object>> mapList) {
        if (mapList != null && !mapList.isEmpty()) {
            Sheet sheet = workbook.getSheetAt(0);
            int lastCellNum = sheet.getRow(1).getPhysicalNumberOfCells();
            Map<Integer, Object> map = null;
            int j = 2;
            for (int i = 0; i < mapList.size(); ++i) {
                map = mapList.get(i);
                Row row = sheet.createRow(i + j);
                for (int col = 0; col < lastCellNum; ++col) {
                    Object object = map.get(col + 1);
                    Cell cell = row.createCell(col);
                    cell.setCellValue(object == null ? "" : object.toString());
                    cell.setCellStyle(cellStyle);
                }
                map.clear();
            }
            mapList.clear();
        } else {
            log.error("[\u5546\u54c1\u4e2d\u5fc3-\u672a\u4fdd\u5b58\u7684\u5bfb\u8d27\u5355\u660e\u7ec6\u5217\u8868\u5bfc\u51fa]-\u6570\u636e\u4e3a\u7a7a");
        }
    }
}

