/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccOrgSkuMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccOrgSkuPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccUpdateAgrSkuStatusAbilityService;
import com.tydic.commodity.zone.ability.bo.UccUpdateAgrSkuStatusAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccUpdateAgrSkuStatusAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccUpdateAgrSkuStatusAbilityService"})
public class UccUpdateAgrSkuStatusAbilityServiceImpl
implements UccUpdateAgrSkuStatusAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccUpdateAgrSkuStatusAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccOrgSkuMapper uccOrgSkuMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"updateAgrSkuStatus"})
    public UccUpdateAgrSkuStatusAbilityRspBO updateAgrSkuStatus(@RequestBody UccUpdateAgrSkuStatusAbilityReqBO reqBO) {
        UccUpdateAgrSkuStatusAbilityRspBO rspBO = new UccUpdateAgrSkuStatusAbilityRspBO();
        this.checkParameter(reqBO);
        if (reqBO.getAgrItemIds() != null && reqBO.getAgrItemIds().size() > 0) {
            for (Long agrItemId : reqBO.getAgrItemIds()) {
                UccOrgSkuPO set = new UccOrgSkuPO();
                UccOrgSkuPO where = new UccOrgSkuPO();
                set.setSkuStatus(Integer.valueOf(12));
                set.setAgreementItemStatus("2");
                where.setAgreementDetailId(agrItemId);
                where.setAgreementId(reqBO.getAgreementId());
                this.uccOrgSkuMapper.updateBy(set, where);
                this.syncES(reqBO.getAgreementId(), agrItemId);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncES(Long agrId, Long agrItemId) {
        List<Object> ids = new ArrayList();
        UccOrgSkuPO uccOrgSkuPO = new UccOrgSkuPO();
        uccOrgSkuPO.setAgreementId(agrId);
        uccOrgSkuPO.setAgreementDetailId(agrItemId);
        List list = this.uccOrgSkuMapper.getList(uccOrgSkuPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ids = list.stream().map(UccOrgSkuPO::getSkuId).collect(Collectors.toList());
        }
        List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(ids);
        Map<Long, List<UccSkuPo>> collect = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        for (Long supplierShopId : collect.keySet()) {
            List commodityIds = collect.get(supplierShopId).stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds(commodityIds);
            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            syncSceneCommodityToEsReqBO.setCommodityType(2);
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("[\u5546\u54c1\u4e2d\u5fc3-\u534f\u8bae\u5546\u54c1\u72b6\u6001\u53d8\u66f4]-\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25|", (Throwable)e);
            }
        }
    }

    private void checkParameter(UccUpdateAgrSkuStatusAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO.getAgreementId())) {
            throw new BusinessException("8888", "agreementId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

