/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.LadderPriceBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccOrgSkuLadderPriceMapper;
import com.tydic.commodity.dao.UccOrgSkuMapper;
import com.tydic.commodity.dao.UccOrgSkuWhiteRestrictionMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccOrgSkuLadderPricePO;
import com.tydic.commodity.po.UccOrgSkuPO;
import com.tydic.commodity.po.UccOrgSkuWhiteRestrictionPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.bo.UccAgrAutoSkuAbilityBO;
import com.tydic.commodity.zone.busi.api.UccAgrAutoSkuBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrAutoSkuBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccAgrAutoSkuBusiRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccAgrAutoSkuBusiServiceImpl
implements UccAgrAutoSkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrAutoSkuBusiServiceImpl.class);
    @Autowired
    private UccOrgSkuWhiteRestrictionMapper uccOrgSkuWhiteRestrictionMapper;
    @Autowired
    private UccOrgSkuMapper uccOrgSkuMapper;
    @Autowired
    private UccOrgSkuLadderPriceMapper uccOrgSkuLadderPriceMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @Override
    public UccAgrAutoSkuBusiRspBO dealUccAgrAutoSku(UccAgrAutoSkuBusiReqBO reqBO) {
        if (UccConstants.AgrAutoSkuOperType.INSERT.equals(reqBO.getType())) {
            Set<Long> longs;
            Map<Integer, Set<Long>> integerSetMap = this.doInsert(reqBO);
            if (!CollectionUtils.isEmpty(integerSetMap) && !CollectionUtils.isEmpty(longs = integerSetMap.get(2))) {
                ArrayList<Long> virIds = new ArrayList<Long>(longs);
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setVirtualSkuIds(virIds);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_DELETE_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_VirSKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                syncSceneCommodityToEsReqBO.setCommodityType(2);
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("[\u5546\u54c1\u4e2d\u5fc3-\u4e13\u4e1a\u5e97\u94fa\u534f\u8bae\u540c\u6b65\u5173\u8054]-\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25|", (Throwable)e);
                }
            }
        } else if (UccConstants.AgrAutoSkuOperType.DELETE.equals(reqBO.getType())) {
            HashSet ids = new HashSet();
            UccOrgSkuPO uccOrgSkuPO = new UccOrgSkuPO();
            uccOrgSkuPO.setAgreementId(reqBO.getAgreementId());
            List list = this.uccOrgSkuMapper.getList(uccOrgSkuPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                List collect = list.stream().map(UccOrgSkuPO::getVirtualSkuId).collect(Collectors.toList());
                ids.addAll(collect);
            }
            ArrayList virIds = new ArrayList(ids);
            Date operDate = new Date();
            if ("4".equals(reqBO.getAgreementStatus())) {
                UccOrgSkuPO set = new UccOrgSkuPO();
                set.setSkuStatus(SkuStatusEnum.PROTOCOL_FAILURE_STATUS.getStatus());
                set.setAgreementItemStatus("2");
                set.setUpdateTime(operDate);
                UccOrgSkuPO where = new UccOrgSkuPO();
                where.setAgreementId(reqBO.getAgreementId());
                this.uccOrgSkuMapper.updateBy(set, where);
            }
            log.info("[\u5546\u54c1\u4e2d\u5fc3-\u4e13\u4e1a\u5e97\u94fa\u534f\u8bae\u540c\u6b65\u5173\u8054]-\u540c\u6b65ES DELETE|virIds:{}", (Object)JSONArray.toJSONString((Object)((Object)virIds).toString()));
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setVirtualSkuIds(virIds);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_DELETE_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_VirSKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            syncSceneCommodityToEsReqBO.setCommodityType(2);
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("[\u5546\u54c1\u4e2d\u5fc3-\u4e13\u4e1a\u5e97\u94fa\u534f\u8bae\u540c\u6b65\u5173\u8054]-\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25|", (Throwable)e);
            }
        } else if (UccConstants.AgrAutoSkuOperType.UPDATE.equals(reqBO.getType())) {
            this.doUpdate(reqBO);
        }
        UccAgrAutoSkuBusiRspBO rspBO = new UccAgrAutoSkuBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void doUpdate(UccAgrAutoSkuBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(reqBO.getAgreementInfo())) {
            for (UccAgrAutoSkuAbilityBO uccAgrAutoSkuAbilityBO : reqBO.getAgreementInfo()) {
                UccOrgSkuPO uccOrgSkuPO = new UccOrgSkuPO();
                uccOrgSkuPO.setAgreementDetailId(uccAgrAutoSkuAbilityBO.getAgreementDetailId());
                if (uccAgrAutoSkuAbilityBO.getAgreementItemStatus() != null) {
                    if ("1".equals(uccAgrAutoSkuAbilityBO.getAgreementItemStatus())) {
                        uccOrgSkuPO.setSkuStatus(Integer.valueOf(3));
                    } else {
                        uccOrgSkuPO.setSkuStatus(Integer.valueOf(5));
                    }
                }
                uccOrgSkuPO.setAgreementItemStatus(uccAgrAutoSkuAbilityBO.getAgreementItemStatus());
                uccOrgSkuPO.setAgreementTitle(uccAgrAutoSkuAbilityBO.getAgreementTitle());
                uccOrgSkuPO.setAgreementName(uccAgrAutoSkuAbilityBO.getAgreementName());
                uccOrgSkuPO.setEnterpriscAgreementCode(uccAgrAutoSkuAbilityBO.getEnterpriscAgreementCode());
                this.uccOrgSkuMapper.updateById(uccOrgSkuPO);
            }
        }
    }

    private Map<Integer, Set<Long>> doInsert(UccAgrAutoSkuBusiReqBO reqBO) {
        HashMap<Integer, Set<Long>> maps = new HashMap<Integer, Set<Long>>();
        if (!CollectionUtils.isEmpty(reqBO.getAgreementInfo())) {
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            for (UccAgrAutoSkuAbilityBO uccAgrAutoSkuAbilityBO : reqBO.getAgreementInfo()) {
                UccOrgSkuPO uccOrgSkuPO = new UccOrgSkuPO();
                uccOrgSkuPO.setAgreementDetailId(uccAgrAutoSkuAbilityBO.getAgreementDetailId());
                UccOrgSkuPO modelBy = this.uccOrgSkuMapper.getModelBy(uccOrgSkuPO);
                if (modelBy == null) continue;
                map.put(uccAgrAutoSkuAbilityBO.getAgreementDetailId(), modelBy.getVirtualSkuId());
            }
            List<UccAgrAutoSkuAbilityBO> agreementInfo = reqBO.getAgreementInfo();
            Map<Long, UccAgrAutoSkuAbilityBO> detailInfoMap = agreementInfo.stream().collect(Collectors.toMap(UccAgrAutoSkuAbilityBO::getAgreementDetailId, t -> t));
            List skuIds = agreementInfo.stream().map(UccAgrAutoSkuAbilityBO::getSkuId).collect(Collectors.toList());
            List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(skuIds);
            if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
                throw new BusinessException("8888", "sku info not find!");
            }
            Map<Long, UccSkuPo> skuIdMap = uccSkuPos.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, t -> t));
            List uccSkuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(skuIds, null);
            if (CollectionUtils.isEmpty((Collection)uccSkuPricePos)) {
                throw new BusinessException("8888", "sku price info not find!");
            }
            Map<Long, UccSkuPricePo> skuIdPriceMap = uccSkuPricePos.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, t -> t));
            List uccOrgSkuPOS = JSON.parseArray((String)JSON.toJSONString(agreementInfo), UccOrgSkuPO.class);
            ArrayList<UccOrgSkuPO> updateList = new ArrayList<UccOrgSkuPO>();
            ArrayList<UccOrgSkuPO> insertList = new ArrayList<UccOrgSkuPO>();
            ArrayList<Long> delList = new ArrayList<Long>();
            for (UccOrgSkuPO uccOrgSkuPO : uccOrgSkuPOS) {
                uccOrgSkuPO.setAgreementId(reqBO.getAgreementId());
                uccOrgSkuPO.setSkuStatus(skuIdMap.get(uccOrgSkuPO.getSkuId()).getSkuStatus());
                uccOrgSkuPO.setSupplierShopId(skuIdMap.get(uccOrgSkuPO.getSkuId()).getSupplierShopId());
                uccOrgSkuPO.setSettlePrice(Objects.isNull(detailInfoMap.get(uccOrgSkuPO.getAgreementDetailId()).getSettlePrice()) ? null : MoneyUtils.haoToYuan((Long)detailInfoMap.get(uccOrgSkuPO.getAgreementDetailId()).getSettlePrice()));
                List ladderPrice = detailInfoMap.get(uccOrgSkuPO.getAgreementDetailId()).getLadderPrice();
                if (!CollectionUtils.isEmpty((Collection)ladderPrice)) {
                    Optional<LadderPriceBO> agreementPriceMin = ladderPrice.stream().filter(v -> v.getPriceType() == 2).min(Comparator.comparing(LadderPriceBO::getStart));
                    Optional<LadderPriceBO> salePriceMin = ladderPrice.stream().filter(v -> v.getPriceType() == 3).min(Comparator.comparing(LadderPriceBO::getStart));
                    agreementPriceMin.ifPresent(ladderPriceBO -> uccOrgSkuPO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)ladderPriceBO.getPrice()))));
                    salePriceMin.ifPresent(ladderPriceBO -> uccOrgSkuPO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)ladderPriceBO.getPrice()))));
                }
                uccOrgSkuPO.setMarketPrice(skuIdPriceMap.get(uccOrgSkuPO.getSkuId()).getMarketPrice());
                if (map.containsKey(uccOrgSkuPO.getAgreementDetailId())) {
                    uccOrgSkuPO.setVirtualSkuId((Long)map.get(uccOrgSkuPO.getAgreementDetailId()));
                    updateList.add(uccOrgSkuPO);
                    UccOrgSkuPO where = new UccOrgSkuPO();
                    where.setVirtualSkuId(uccOrgSkuPO.getVirtualSkuId());
                    this.uccOrgSkuMapper.updateBy(uccOrgSkuPO, where);
                    continue;
                }
                uccOrgSkuPO.setVirtualSkuId(Long.valueOf(Sequence.getInstance().nextId()));
                if (uccOrgSkuPO.getSkuId() != null) {
                    UccOrgSkuPO po = new UccOrgSkuPO();
                    po.setSkuId(uccOrgSkuPO.getSkuId());
                    po.setAgreementId(uccOrgSkuPO.getAgreementId());
                    List list = this.uccOrgSkuMapper.getList(po);
                    for (UccOrgSkuPO skuPO : list) {
                        UccOrgSkuPO set = new UccOrgSkuPO();
                        UccOrgSkuPO where = new UccOrgSkuPO();
                        where.setVirtualSkuId(skuPO.getVirtualSkuId());
                        set.setAgreementItemStatus("2");
                        set.setSkuStatus(Integer.valueOf(12));
                        this.uccOrgSkuMapper.updateBy(set, where);
                        delList.add(skuPO.getVirtualSkuId());
                    }
                }
                insertList.add(uccOrgSkuPO);
            }
            HashSet<Long> deleteIds = new HashSet<Long>();
            deleteIds.addAll(delList);
            maps.put(2, deleteIds);
            if (!CollectionUtils.isEmpty(insertList)) {
                this.uccOrgSkuMapper.insertBatch(insertList);
            }
            HashMap<Long, UccOrgSkuPO> uccOrgSkuPOMap = new HashMap<Long, UccOrgSkuPO>();
            for (UccOrgSkuPO uccOrgSkuPO : uccOrgSkuPOS) {
                uccOrgSkuPOMap.put(uccOrgSkuPO.getSkuId(), uccOrgSkuPO);
            }
            ArrayList<UccOrgSkuLadderPricePO> uccOrgSkuLadderPricePOS = new ArrayList<UccOrgSkuLadderPricePO>();
            ArrayList<Long> virtalSkuIds = new ArrayList<Long>();
            for (UccAgrAutoSkuAbilityBO uccAgrAutoSkuAbilityBO : reqBO.getAgreementInfo()) {
                if (!UccConstants.SwitchOn.ON.equals(uccAgrAutoSkuAbilityBO.getSwitchOn())) continue;
                List ladderPrice = uccAgrAutoSkuAbilityBO.getLadderPrice();
                for (LadderPriceBO ladderPriceBO2 : ladderPrice) {
                    UccOrgSkuLadderPricePO uccOrgSkuLadderPricePO = new UccOrgSkuLadderPricePO();
                    uccOrgSkuLadderPricePO.setDiscount(ladderPriceBO2.getDiscount());
                    uccOrgSkuLadderPricePO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    uccOrgSkuLadderPricePO.setPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)ladderPriceBO2.getPrice())));
                    uccOrgSkuLadderPricePO.setStart(ladderPriceBO2.getStart());
                    uccOrgSkuLadderPricePO.setStop(ladderPriceBO2.getStop());
                    uccOrgSkuLadderPricePO.setPriceType(ladderPriceBO2.getPriceType());
                    uccOrgSkuLadderPricePO.setVirtualSkuId(((UccOrgSkuPO)uccOrgSkuPOMap.get(uccAgrAutoSkuAbilityBO.getSkuId())).getVirtualSkuId());
                    virtalSkuIds.add(((UccOrgSkuPO)uccOrgSkuPOMap.get(uccAgrAutoSkuAbilityBO.getSkuId())).getVirtualSkuId());
                    uccOrgSkuLadderPricePO.setSupplierShopId(skuIdMap.get(uccAgrAutoSkuAbilityBO.getSkuId()).getSupplierShopId());
                    uccOrgSkuLadderPricePOS.add(uccOrgSkuLadderPricePO);
                }
            }
            if (!CollectionUtils.isEmpty(uccOrgSkuLadderPricePOS)) {
                if (!CollectionUtils.isEmpty(virtalSkuIds)) {
                    this.uccOrgSkuLadderPriceMapper.deleteByVirtualSkuIds(virtalSkuIds);
                }
                this.uccOrgSkuLadderPriceMapper.insertBatch(uccOrgSkuLadderPricePOS);
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getRegion())) {
            UccOrgSkuWhiteRestrictionPo uccOrgSkuWhiteRestrictionPo1 = new UccOrgSkuWhiteRestrictionPo();
            uccOrgSkuWhiteRestrictionPo1.setAgreementId(reqBO.getAgreementId());
            this.uccOrgSkuWhiteRestrictionMapper.deleteBy(uccOrgSkuWhiteRestrictionPo1);
            List list = new ArrayList();
            if (!CollectionUtils.isEmpty(reqBO.getRegion())) {
                list = JSON.parseArray((String)JSON.toJSONString(reqBO.getRegion()), UccOrgSkuWhiteRestrictionPo.class);
                for (UccOrgSkuWhiteRestrictionPo uccOrgSkuWhiteRestrictionPo : list) {
                    uccOrgSkuWhiteRestrictionPo.setAgreementId(reqBO.getAgreementId());
                    uccOrgSkuWhiteRestrictionPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    uccOrgSkuWhiteRestrictionPo.setStatus(1);
                    uccOrgSkuWhiteRestrictionPo.setCreateOperId(String.valueOf(reqBO.getUserId()));
                    uccOrgSkuWhiteRestrictionPo.setCreateTime(new Date());
                    uccOrgSkuWhiteRestrictionPo.setUpdateOperId(String.valueOf(reqBO.getUserId()));
                    uccOrgSkuWhiteRestrictionPo.setUpdateTime(new Date());
                }
            }
            if (!CollectionUtils.isEmpty(list)) {
                this.uccOrgSkuWhiteRestrictionMapper.insertBatch(list);
            }
        }
        return maps;
    }
}

