/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SkuChangePriceBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.bo.UccDealUmcMessageReqBO;
import com.tydic.commodity.zone.ability.bo.UccDealUmcMessageRspBO;
import com.tydic.commodity.zone.busi.api.UccDealUmcMessageService;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccDealUmcMessageServiceImpl
implements UccDealUmcMessageService {
    private static final Logger log = LoggerFactory.getLogger(UccDealUmcMessageServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UccDealUmcMessageServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired(required=true)
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;

    @Override
    public UccDealUmcMessageRspBO dealUmcMessage(UccDealUmcMessageReqBO reqBO) {
        UccDealUmcMessageRspBO rspBO = new UccDealUmcMessageRspBO();
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f]-\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f\u6570\u636e|reqBO:{}", (Object)JSON.toJSONString((Object)reqBO));
        if (reqBO.getCommiditySkuStatus() != null) {
            this.uccSkuMapper.modifySkuByAgreement(reqBO.getAgreementIds(), reqBO.getAgreementSkuIds(), reqBO.getCommiditySkuStatus());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getSkuChangePriceBOs())) {
            List skuChangePriceBOS = reqBO.getSkuChangePriceBOs();
            ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
            for (SkuChangePriceBO skuChangePriceBO : skuChangePriceBOS) {
                List uccSkuPos;
                if (skuChangePriceBO.getCommiditySkuStatus() != null) {
                    this.uccSkuMapper.modifySkuByAgreement((List)Lists.newArrayList((Object[])new Long[]{skuChangePriceBO.getAgreementId()}), (List)Lists.newArrayList((Object[])new Long[]{skuChangePriceBO.getAgreementSkuId()}), skuChangePriceBO.getCommiditySkuStatus());
                    continue;
                }
                Long agreementId = null;
                String agreementDetailId = null;
                if (skuChangePriceBO.getAgreementId() != null) {
                    agreementId = skuChangePriceBO.getAgreementId();
                }
                if (skuChangePriceBO.getAgreementSkuId() != null) {
                    agreementDetailId = String.valueOf(skuChangePriceBO.getAgreementSkuId());
                }
                if (CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.selectByAgreementDetailId(agreementId, Long.valueOf(agreementDetailId))))) continue;
                if (skuChangePriceBO.getBuyNumber() != null) {
                    SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
                    smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(skuChangePriceBO.getBuyNumber().longValue()));
                    smcsdkStockNumInfoBO.setSkuId(((UccSkuPo)uccSkuPos.get(0)).getSkuId().toString());
                    smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
                }
                for (UccSkuPo uccSkuPo : uccSkuPos) {
                    try {
                        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
                        uccSkuPricePo.setSkuId(uccSkuPo.getSkuId());
                        uccSkuPricePo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                        uccSkuPricePo.setSalePrice(Long.valueOf(skuChangePriceBO.getSalePrice().longValue()));
                        uccSkuPricePo.setAgreementPrice(Long.valueOf(skuChangePriceBO.getBuyPrice().longValue()));
                        this.uccSkuPriceMapper.updateSkuPrice(uccSkuPricePo);
                    }
                    catch (Exception e) {
                        log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f]-\u4fee\u6539\u4fe1\u606f\u5931\u8d25|", (Throwable)e);
                        throw new BusinessException("8888", "\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
                    }
                    try {
                        UccSkuPo uccSkuPo1 = new UccSkuPo();
                        uccSkuPo1.setSkuId(uccSkuPo.getSkuId());
                        uccSkuPo1.setSupplierShopId(uccSkuPo.getSupplierShopId());
                        if (skuChangePriceBO.getSalePrice() != null) {
                            uccSkuPo1.setSkuPrice(Long.valueOf(skuChangePriceBO.getSalePrice().longValue()));
                        }
                        this.uccSkuMapper.updateSku(uccSkuPo1);
                        BigDecimal salePrice = skuChangePriceBO.getSalePrice();
                        this.updateLadderPrice(uccSkuPo.getSkuId(), uccSkuPo.getSupplierShopId(), salePrice);
                    }
                    catch (Exception e) {
                        log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f]-\u4fee\u6539\u4ef7\u683c\u4fe1\u606f\u5931\u8d25|", (Throwable)e);
                        throw new BusinessException("8888", "\u4fee\u6539\u4ef7\u683c\u4fe1\u606f\u5931\u8d25");
                    }
                }
            }
            if (!CollectionUtils.isEmpty(smcsdkStockNumInfoBOS)) {
                SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
                smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
                smcsdkOperateStockNumReqBO.setOperateType("11");
                if (((SkuChangePriceBO)reqBO.getSkuChangePriceBOs().get(0)).getAgreementId() == null) {
                    smcsdkOperateStockNumReqBO.setObjectId("111111");
                } else {
                    smcsdkOperateStockNumReqBO.setObjectId(((SkuChangePriceBO)reqBO.getSkuChangePriceBOs().get(0)).getAgreementId().toString());
                }
                smcsdkOperateStockNumReqBO.setObjectType("20");
                try {
                    log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f]-\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2|smcsdkOperateStockNumReqBO:{}", (Object)JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                    SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
                    if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                        throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkOperateStockNumRspBO.getRespDesc());
                    }
                    log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f]-\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2|smcsdkOperateStockNumRspBO:{}", (Object)JSONObject.toJSONString((Object)smcsdkOperateStockNumRspBO));
                }
                catch (Exception e) {
                    log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f]-\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25|", (Throwable)e);
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25:" + e.getMessage());
                }
            }
        }
        this.dealSkuSyncEs(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d88\u606f\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private void dealSkuSyncEs(UccDealUmcMessageReqBO reqBO) {
        List uccSkuPos;
        Map<Object, Object> groupBySupplier = new HashMap();
        if ((CollectionUtils.isNotEmpty((Collection)reqBO.getAgreementIds()) || CollectionUtils.isNotEmpty((Collection)reqBO.getAgreementSkuIds())) && CollectionUtils.isNotEmpty((Collection)(uccSkuPos = this.uccSkuMapper.selectByAgreementDetailIds(reqBO.getAgreementIds(), reqBO.getAgreementSkuIds())))) {
            groupBySupplier = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getSkuChangePriceBOs())) {
            List agreementDetailIds = reqBO.getSkuChangePriceBOs().stream().map(SkuChangePriceBO::getAgreementSkuId).collect(Collectors.toList());
            List agreementIds = reqBO.getSkuChangePriceBOs().stream().map(SkuChangePriceBO::getAgreementId).collect(Collectors.toList());
            List uccSkuPos2 = this.uccSkuMapper.selectByAgreementDetailIds(agreementIds, agreementDetailIds);
            if (CollectionUtils.isNotEmpty((Collection)uccSkuPos2)) {
                groupBySupplier = uccSkuPos2.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            }
        }
        for (Map.Entry entry : groupBySupplier.entrySet()) {
            List skuIds = ((List)entry.getValue()).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
            syncSceneCommodityToEsReqBO.setSupplierId((Long)entry.getKey());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f]-\u521b\u5efaes\u6d88\u606f\u5931\u8d25|", (Throwable)e);
                throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
            }
        }
    }

    private void updateLadderPrice(Long skuId, Long supplierShopId, BigDecimal salePrice) {
        List uccLadderPriceList = this.uccLadderPriceMapper.selectBySkuId(skuId, supplierShopId);
        if (CollectionUtils.isNotEmpty((Collection)uccLadderPriceList)) {
            for (UccLadderPricePO uccLadderPrice : uccLadderPriceList) {
                UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
                BigDecimal discount = uccLadderPrice.getDiscount();
                if (discount == null) continue;
                BigDecimal price = discount.multiply(salePrice);
                uccLadderPricePO.setPrice(Long.valueOf(price.longValue()));
                uccLadderPricePO.setId(uccLadderPrice.getId());
                this.uccLadderPriceMapper.updateByExampleSelective(uccLadderPricePO);
            }
        }
    }
}

