/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.IcascUccConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccSpuEvaluationMapper;
import com.tydic.commodity.dao.UccSpuEvaluationPicMapper;
import com.tydic.commodity.po.UccSpuEvaluationPO;
import com.tydic.commodity.po.UccSpuEvaluationPicPO;
import com.tydic.commodity.zone.ability.bo.SkuEvaluationInfoBO;
import com.tydic.commodity.zone.ability.bo.SkuEvaluationPicInfoBO;
import com.tydic.commodity.zone.busi.api.UccEvaluateSkuBusiService;
import com.tydic.commodity.zone.busi.bo.UccEvaluateSkuBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccEvaluateSkuBusiRspBO;
import com.tydic.commodity.zone.utils.IcascZoneTransFieldUtil;
import com.tydic.uoc.common.ability.api.UocPebUpdateItemEvaluateAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebUpdateItemEvaluateAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPebUpdateItemEvaluateAbilityRspBO;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccEvaluateSkuBusiServiceImpl
implements UccEvaluateSkuBusiService {
    @Autowired
    private UccSpuEvaluationPicMapper uccSpuEvaluationPicMapper;
    @Autowired
    private UccSpuEvaluationMapper uccSpuEvaluationMapper;
    @Autowired
    private UocPebUpdateItemEvaluateAbilityService uocPebUpdateItemEvaluateAbilityService;

    @Override
    public UccEvaluateSkuBusiRspBO evaluateSku(UccEvaluateSkuBusiReqBO reqBO) {
        UccEvaluateSkuBusiRspBO rspBO = new UccEvaluateSkuBusiRspBO();
        for (SkuEvaluationInfoBO skuEvaluationInfoBO : reqBO.getEvaluationInfos()) {
            int insertResult;
            UccSpuEvaluationPO insertUccSpuEvaluationPO = new UccSpuEvaluationPO();
            BeanUtils.copyProperties((Object)skuEvaluationInfoBO, (Object)insertUccSpuEvaluationPO);
            Long evaluationId = Sequence.getInstance().nextId();
            insertUccSpuEvaluationPO.setEvaluationId(evaluationId);
            insertUccSpuEvaluationPO.setStatus(IcascUccConstant.EvaluateStatus.WAIT_AFTER_EVALUATE);
            insertUccSpuEvaluationPO.setIsReply(IcascUccConstant.IsReply.NO);
            if (skuEvaluationInfoBO.getSkuEvaluateScore() != null) {
                insertUccSpuEvaluationPO.setSkuEvaluateLevel(IcascZoneTransFieldUtil.calculateEvaluateLevel(skuEvaluationInfoBO.getSkuEvaluateScore()));
            }
            if (skuEvaluationInfoBO.getLogisticsEvaluateScore() != null) {
                insertUccSpuEvaluationPO.setLogisticsEvaluateLevel(IcascZoneTransFieldUtil.calculateEvaluateLevel(skuEvaluationInfoBO.getLogisticsEvaluateScore()));
            }
            if (skuEvaluationInfoBO.getServiceEvaluateScore() != null) {
                insertUccSpuEvaluationPO.setServiceEvaluateLevel(IcascZoneTransFieldUtil.calculateEvaluateLevel(skuEvaluationInfoBO.getServiceEvaluateScore()));
            }
            insertUccSpuEvaluationPO.setTotalEvaluateLevel(IcascZoneTransFieldUtil.calculateTotalEvaluateLevel(skuEvaluationInfoBO.getSkuEvaluateScore().add(skuEvaluationInfoBO.getLogisticsEvaluateScore()).add(skuEvaluationInfoBO.getServiceEvaluateScore())));
            insertUccSpuEvaluationPO.setEvaluateTime(new Date());
            if (!CollectionUtils.isEmpty((Collection)skuEvaluationInfoBO.getEvaluationPicInfo())) {
                insertUccSpuEvaluationPO.setHavePic(IcascUccConstant.SkuEvaluateHavePic.YES);
            }
            insertUccSpuEvaluationPO.setOrgId(reqBO.getOrgId());
            insertUccSpuEvaluationPO.setOrgName(reqBO.getOrgName());
            if (StringUtils.hasText((String)skuEvaluationInfoBO.getSaleVoucherNo())) {
                insertUccSpuEvaluationPO.setSaleVoucherNo(skuEvaluationInfoBO.getSaleVoucherNo());
            }
            if (1 == (insertResult = this.uccSpuEvaluationMapper.insert(insertUccSpuEvaluationPO))) {
                if (!CollectionUtils.isEmpty((Collection)skuEvaluationInfoBO.getEvaluationPicInfo())) {
                    for (SkuEvaluationPicInfoBO skuEvaluationPicInfoBO : skuEvaluationInfoBO.getEvaluationPicInfo()) {
                        UccSpuEvaluationPicPO insertUccSpuEvaluationPicPO = new UccSpuEvaluationPicPO();
                        BeanUtils.copyProperties((Object)skuEvaluationPicInfoBO, (Object)insertUccSpuEvaluationPicPO);
                        insertUccSpuEvaluationPicPO.setPicId(Long.valueOf(Sequence.getInstance().nextId()));
                        insertUccSpuEvaluationPicPO.setEvaluationId(evaluationId);
                        insertUccSpuEvaluationPicPO.setPicType(IcascUccConstant.PicType.EVALUATE_PIC);
                        this.uccSpuEvaluationPicMapper.insert(insertUccSpuEvaluationPicPO);
                    }
                }
            } else {
                throw new BusinessException("110004", "\u5355\u54c1\u8bc4\u4ef7\u5931\u8d25");
            }
            UocPebUpdateItemEvaluateAbilityReqBO uocPebUpdateItemEvaluateAbilityReqBO = new UocPebUpdateItemEvaluateAbilityReqBO();
            uocPebUpdateItemEvaluateAbilityReqBO.setOrderId(Long.valueOf(skuEvaluationInfoBO.getOrderId()));
            uocPebUpdateItemEvaluateAbilityReqBO.setOrdItemId(skuEvaluationInfoBO.getOrdItemId());
            uocPebUpdateItemEvaluateAbilityReqBO.setUpdateType(Integer.valueOf(0));
            UocPebUpdateItemEvaluateAbilityRspBO uocPebUpdateItemEvaluateAbilityRspBO = this.uocPebUpdateItemEvaluateAbilityService.dealUpdateItemEvaluate(uocPebUpdateItemEvaluateAbilityReqBO);
            if ("0000".equals(uocPebUpdateItemEvaluateAbilityRspBO.getRespCode())) continue;
            throw new BusinessException("110004", "\u540c\u6b65\u4f1a\u5458\u5931\u8d25\uff1a" + uocPebUpdateItemEvaluateAbilityRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5355\u54c1\u8bc4\u4ef7\u6210\u529f");
        return rspBO;
    }
}

