/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.FindgoodsStatusEnum;
import com.tydic.commodity.base.enumType.FindgoodsTypeCodeEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.dao.UccFindgoodsOrderDetailMapper;
import com.tydic.commodity.dao.UccFindgoodsOrderMapper;
import com.tydic.commodity.po.UccFindgoodsOrderDetailPO;
import com.tydic.commodity.po.UccFindgoodsOrderPO;
import com.tydic.commodity.zone.ability.bo.UccFindGoodsOrderDetailBO;
import com.tydic.commodity.zone.ability.bo.UccFindgoodsOrderAddAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccFindgoodsOrderAddAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccFindgoodsOrderAddBusiService;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccFindgoodsOrderAddBusiServiceImpl
implements UccFindgoodsOrderAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccFindgoodsOrderAddBusiServiceImpl.class);
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccFindgoodsOrderMapper uccFindgoodsOrderMapper;
    @Autowired
    private UccFindgoodsOrderDetailMapper uccFindgoodsOrderDetailMapper;
    @Autowired
    private UccApproveCreationAtomService uccApproveCreationAtomService;
    @Value(value="${FG_ONE_PROCESS}")
    private String process;
    @Resource(name="uccFindgoodsCodeSequence")
    private OrderSequence orderSequence;

    @Override
    public UccFindgoodsOrderAddAbilityRspBO addFindgoodsOrder(UccFindgoodsOrderAddAbilityReqBO reqBO) {
        UccFindgoodsOrderAddAbilityRspBO rspBO = new UccFindgoodsOrderAddAbilityRspBO();
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5bfb\u8d27\u5355\u4fe1\u606f\u4fdd\u5b58\u63d0\u4ea4]-addFindgoodsOrder\u5165\u53c2|reqBO:{}", (Object)JSONObject.toJSONString((Object)reqBO));
        Date operDate = new Date();
        Integer findgoodsStatus = null;
        findgoodsStatus = UccConstants.OperType.save.intValue() == reqBO.getOperType().intValue() ? FindgoodsStatusEnum.DRAFT_STATUS.getStatus() : FindgoodsStatusEnum.PENDING_APPROVAL_STATUS.getStatus();
        if (UccConstants.OperType.submit.intValue() == reqBO.getOperType().intValue() && StringUtils.isEmpty((Object)reqBO.getFindgoodsCode())) {
            try {
                String seqNo = String.valueOf(this.orderSequence.nextId());
                if (seqNo.length() == 1) {
                    seqNo = "000" + seqNo;
                }
                if (seqNo.length() == 2) {
                    seqNo = "00" + seqNo;
                }
                if (seqNo.length() == 3) {
                    seqNo = "0" + seqNo;
                }
                String codePrefix = "XHD" + DateUtils.dateToStrYYYYMMdd((Date)operDate) + seqNo;
                log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5bfb\u8d27\u5355\u4fe1\u606f\u4fdd\u5b58\u63d0\u4ea4]-\u5bfb\u8d27\u5355\u7f16\u53f7|codePrefix:{}", (Object)codePrefix);
                reqBO.setFindgoodsCode(codePrefix);
            }
            catch (SQLException e2) {
                throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), "\u5bfb\u8d27\u5355\u7f16\u53f7\u5e8f\u5217\u751f\u6210\u5931\u8d25\uff01");
            }
        }
        if (reqBO.getFindgoodsId() != null) {
            UccFindgoodsOrderPO qryOrderPO = new UccFindgoodsOrderPO();
            qryOrderPO.setFindgoodsId(reqBO.getFindgoodsId());
            UccFindgoodsOrderPO existsOrderPO = this.uccFindgoodsOrderMapper.getModelBy(qryOrderPO);
            if (existsOrderPO == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5165\u53c2\u5bfb\u8d27\u5355ID\u5bf9\u5e94\u7684\u5bfb\u8d27\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
                return rspBO;
            }
            UccFindgoodsOrderPO setPO = new UccFindgoodsOrderPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)setPO);
            if (StringUtils.hasText((String)reqBO.getFindgoodsCode())) {
                setPO.setFindgoodsCode(reqBO.getFindgoodsCode());
                rspBO.setFindgoodsCode(reqBO.getFindgoodsCode());
            }
            setPO.setUpdateTime(operDate);
            setPO.setUpdateOperId(String.valueOf(reqBO.getUserId()));
            setPO.setDelFlag(UccConstants.Status.INVALID);
            setPO.setFindgoodsStatus(findgoodsStatus);
            UccFindgoodsOrderPO wherePO = new UccFindgoodsOrderPO();
            wherePO.setFindgoodsId(reqBO.getFindgoodsId());
            this.uccFindgoodsOrderMapper.updateBy(setPO, wherePO);
            rspBO.setFindgoodsId(reqBO.getFindgoodsId());
        } else {
            if (!CollectionUtils.isEmpty((Collection)reqBO.getFindGoodsOrderDetailBOList())) {
                reqBO.getFindGoodsOrderDetailBOList().stream().forEach(e -> {
                    e.setDetailFindgoodsId(null);
                    e.setFindgoodsId(null);
                });
            }
            Long findgoodsId = this.sequence.nextId();
            UccFindgoodsOrderPO newOrderPO = new UccFindgoodsOrderPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)newOrderPO);
            newOrderPO.setFindgoodsId(findgoodsId);
            if (StringUtils.hasText((String)reqBO.getFindgoodsCode())) {
                newOrderPO.setFindgoodsCode(reqBO.getFindgoodsCode());
                rspBO.setFindgoodsCode(reqBO.getFindgoodsCode());
            }
            if (reqBO.getCreateTime() == null) {
                newOrderPO.setCreateTime(operDate);
            }
            if (StringUtils.isEmpty((Object)reqBO.getCreateOperId())) {
                newOrderPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
                newOrderPO.setCreateOperName(reqBO.getUsername());
            }
            if (StringUtils.isEmpty((Object)reqBO.getCreateOrgId())) {
                newOrderPO.setCreateOrgId(reqBO.getCompanyId());
                newOrderPO.setCreateOrgName(reqBO.getCompanyName());
            }
            newOrderPO.setDelFlag(UccConstants.Status.INVALID);
            newOrderPO.setFindgoodsStatus(findgoodsStatus);
            this.uccFindgoodsOrderMapper.insert(newOrderPO);
            rspBO.setFindgoodsId(newOrderPO.getFindgoodsId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFindGoodsOrderDetailBOList())) {
            BigDecimal liAmount = new BigDecimal(10000);
            ArrayList<UccFindgoodsOrderDetailPO> addDetailList = new ArrayList<UccFindgoodsOrderDetailPO>();
            ArrayList<UccFindgoodsOrderDetailPO> updateDetailList = new ArrayList<UccFindgoodsOrderDetailPO>();
            ArrayList<Long> detailIdList = new ArrayList<Long>();
            for (UccFindGoodsOrderDetailBO e3 : reqBO.getFindGoodsOrderDetailBOList()) {
                UccFindgoodsOrderDetailPO nodePO = new UccFindgoodsOrderDetailPO();
                BeanUtils.copyProperties((Object)e3, (Object)nodePO);
                nodePO.setFindgoodsId(rspBO.getFindgoodsId());
                if (e3.getFindgoodsTaxationPrice() != null) {
                    nodePO.setFindgoodsTaxationPrice(Long.valueOf(e3.getFindgoodsTaxationPrice().multiply(liAmount).longValue()));
                }
                if (StringUtils.isEmpty((Object)nodePO.getFindgoodsTypeCode())) {
                    if (FindgoodsTypeCodeEnum.PROD_PROTECT_TYPE.getTypeDesc().equals(e3.getFindgoodsTypeName())) {
                        nodePO.setFindgoodsTypeCode(FindgoodsTypeCodeEnum.PROD_PROTECT_TYPE.getType());
                    } else if (FindgoodsTypeCodeEnum.OFFICE_SUP_TYPE.getTypeDesc().equals(e3.getFindgoodsTypeName())) {
                        nodePO.setFindgoodsTypeCode(FindgoodsTypeCodeEnum.OFFICE_SUP_TYPE.getType());
                    }
                }
                if (e3.getDetailFindgoodsId() != null) {
                    nodePO.setUpdateTime(operDate);
                    nodePO.setUpdateOperId(String.valueOf(reqBO.getUserId()));
                    updateDetailList.add(nodePO);
                    detailIdList.add(e3.getDetailFindgoodsId());
                    continue;
                }
                nodePO.setCreateTime(operDate);
                nodePO.setCreateOperId(String.valueOf(reqBO.getUserId()));
                nodePO.setDelFlag(UccConstants.Status.INVALID);
                addDetailList.add(nodePO);
            }
            boolean delAllFlag = true;
            if (!CollectionUtils.isEmpty(updateDetailList)) {
                delAllFlag = false;
                updateDetailList.stream().forEach(e -> this.uccFindgoodsOrderDetailMapper.updateById(e));
            }
            if (!CollectionUtils.isEmpty(detailIdList)) {
                UccFindgoodsOrderDetailPO qryDetailPO = new UccFindgoodsOrderDetailPO();
                qryDetailPO.setFindgoodsId(rspBO.getFindgoodsId());
                qryDetailPO.setDelFlag(UccConstants.Status.INVALID);
                List existDetailPOList = this.uccFindgoodsOrderDetailMapper.getList(qryDetailPO);
                if (!CollectionUtils.isEmpty((Collection)existDetailPOList)) {
                    ArrayList<UccFindgoodsOrderDetailPO> deleteDetailList = new ArrayList<UccFindgoodsOrderDetailPO>();
                    for (UccFindgoodsOrderDetailPO existDetailPO : existDetailPOList) {
                        if (detailIdList.contains(existDetailPO.getDetailFindgoodsId())) continue;
                        UccFindgoodsOrderDetailPO deleteDetailPO = new UccFindgoodsOrderDetailPO();
                        deleteDetailPO.setDetailFindgoodsId(existDetailPO.getDetailFindgoodsId());
                        deleteDetailPO.setUpdateTime(operDate);
                        deleteDetailPO.setUpdateOperId(String.valueOf(reqBO.getUserId()));
                        deleteDetailPO.setDelFlag(UccConstants.Status.VALID);
                        deleteDetailList.add(deleteDetailPO);
                    }
                    if (!CollectionUtils.isEmpty(deleteDetailList)) {
                        deleteDetailList.stream().forEach(e -> this.uccFindgoodsOrderDetailMapper.updateById(e));
                    }
                }
            }
            if (!CollectionUtils.isEmpty(addDetailList)) {
                if (delAllFlag) {
                    UccFindgoodsOrderDetailPO where = new UccFindgoodsOrderDetailPO();
                    where.setFindgoodsId(rspBO.getFindgoodsId());
                    this.uccFindgoodsOrderDetailMapper.deleteBy(where);
                }
                this.uccFindgoodsOrderDetailMapper.insertBatch(addDetailList);
            }
        }
        if (UccConstants.OperType.submit.intValue() == reqBO.getOperType().intValue()) {
            UccApproveCreationAtomReqBO approveCreationAtomReqBO = new UccApproveCreationAtomReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)approveCreationAtomReqBO);
            List<Long> objIds = Arrays.asList(rspBO.getFindgoodsId());
            approveCreationAtomReqBO.setObjId(objIds);
            approveCreationAtomReqBO.setProcDefKey(this.process);
            approveCreationAtomReqBO.setMenuId("default");
            approveCreationAtomReqBO.setObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_FINDGOODS);
            approveCreationAtomReqBO.setOrderId(rspBO.getFindgoodsId());
            if (StringUtils.hasText((String)reqBO.getCompanyName())) {
                approveCreationAtomReqBO.setOrgName(reqBO.getCompanyName());
            }
            UccApproveCreationAtomRspBO uccApproveCreationAtomRspBO = null;
            try {
                uccApproveCreationAtomRspBO = this.uccApproveCreationAtomService.createApprove(approveCreationAtomReqBO);
            }
            catch (Exception e4) {
                log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5bfb\u8d27\u5355\u4fe1\u606f\u4fdd\u5b58\u63d0\u4ea4]-\u521b\u5efa\u5bfb\u8d27\u5355\u5ba1\u6279\u5355\u5931\u8d25|", (Throwable)e4);
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), e4.getMessage());
            }
            if (!"0000".equals(uccApproveCreationAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), uccApproveCreationAtomRspBO.getRespDesc());
            }
            if (uccApproveCreationAtomRspBO.getNotFindFlag().booleanValue() || uccApproveCreationAtomRspBO.getFinish().booleanValue()) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u5931\u8d25:\u6d41\u7a0bkey[" + approveCreationAtomReqBO.getMenuId() + "]\u7684\u6d41\u7a0b\u56fe\u672a\u627e\u5230,\u8bf7\u68c0\u67e5\u914d\u7f6e");
            }
            if (!StringUtils.isEmpty((Object)uccApproveCreationAtomRspBO.getStepId())) {
                this.uccFindgoodsOrderMapper.batchUpdateStepById(objIds, uccApproveCreationAtomRspBO.getStepId());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5bfb\u8d27\u5355\u4fe1\u606f\u4fdd\u5b58\u63d0\u4ea4]-addFindgoodsOrder\u51fa\u53c2|rspBO:{}", (Object)JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }
}

