/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.base.constant.CommonConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.FindgoodsStatusEnum;
import com.tydic.commodity.busibase.atom.api.PebSendMessageAtomService;
import com.tydic.commodity.busibase.atom.bo.PebSendMessageAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.PebSendMessageAtomRspBO;
import com.tydic.commodity.dao.UccFindgoodsOrderMapper;
import com.tydic.commodity.po.UccFindgoodsOrderPO;
import com.tydic.commodity.zone.ability.bo.UccFindgoodsOrderAutoEndTaskAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccFindgoodsOrderAutoEndTaskBusiService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccFindgoodsOrderAutoEndTaskBusiServiceImpl
implements UccFindgoodsOrderAutoEndTaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccFindgoodsOrderAutoEndTaskBusiServiceImpl.class);
    @Autowired
    private UccFindgoodsOrderMapper uccFindgoodsOrderMapper;
    @Autowired
    private PebSendMessageAtomService pebSendMessageAtomService;
    @Value(value="${SYS_URL}")
    private String SYS_URL;

    @Override
    public UccFindgoodsOrderAutoEndTaskAbilityRspBO operEndFindgoodsOrder() {
        UccFindgoodsOrderAutoEndTaskAbilityRspBO rspBO = new UccFindgoodsOrderAutoEndTaskAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Date operDate = new Date();
        UccFindgoodsOrderPO model = new UccFindgoodsOrderPO();
        model.setDelFlag(UccConstants.Status.INVALID);
        model.setFindgoodsEndTimeEnd(operDate);
        List<Integer> statusList = Arrays.asList(FindgoodsStatusEnum.PENDING_APPROVAL_STATUS.getStatus(), FindgoodsStatusEnum.PENDING_MATCH_STATUS.getStatus());
        model.setFindgoodsStatusList(statusList);
        List waitEndList = this.uccFindgoodsOrderMapper.getList(model);
        if (CollectionUtils.isEmpty((Collection)waitEndList)) {
            return rspBO;
        }
        List findgoodsIds = waitEndList.stream().map(UccFindgoodsOrderPO::getFindgoodsId).collect(Collectors.toList());
        UccFindgoodsOrderPO updatePO = new UccFindgoodsOrderPO();
        updatePO.setFindgoodsStatus(FindgoodsStatusEnum.END_STATUS.getStatus());
        updatePO.setUpdateTime(operDate);
        updatePO.setIdList(findgoodsIds);
        this.uccFindgoodsOrderMapper.batchUpdateStatusById(updatePO);
        for (UccFindgoodsOrderPO orderPO : waitEndList) {
            this.sendInnerMessage(orderPO);
        }
        return rspBO;
    }

    private void sendInnerMessage(UccFindgoodsOrderPO orderPO) {
        PebSendMessageAtomReqBO messageAtomReqBO = new PebSendMessageAtomReqBO();
        messageAtomReqBO.setSendType(CommonConstant.ORDER_SEND_MESSAGE);
        messageAtomReqBO.setUserId(Long.valueOf(1L));
        messageAtomReqBO.setObjectId(orderPO.getFindgoodsId());
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u81ea\u52a8\u7ed3\u675f\u5bfb\u8d27\u5b9a\u65f6\u4efb\u52a1\u4e1a\u52a1]-sendInnerMessage|orderPO.getCreateOperId():{}", (Object)orderPO.getCreateOperId());
        messageAtomReqBO.setReceiveId(Long.valueOf(orderPO.getCreateOperId()));
        StringBuffer sb = new StringBuffer();
        String title = "\u7f16\u53f7\uff1a" + orderPO.getFindgoodsCode() + "\u5bfb\u8d27\u5355\u5df2\u7ed3\u675f";
        sb.append("\u60a8");
        sb.append(DateUtils.dateToStr((Date)orderPO.getCreateTime()));
        sb.append("\u63d0\u4ea4\u7684\u5bfb\u8d27\u5355 ");
        sb.append(orderPO.getFindgoodsName());
        sb.append(" \u5bfb\u8d27\u5df2\u7ed3\u675f\uff0c\u8bf7\u67e5\u770b\u3002");
        sb.append("<html>");
        sb.append("<a href=\"");
        sb.append(this.SYS_URL).append("/#/index/mySeekCommodityDetail?id=").append(orderPO.getFindgoodsId()).append("&type=detail");
        sb.append("\">\u70b9\u51fb\u67e5\u770b\u8be6\u60c5</a>");
        sb.append("</html>");
        String text = sb.toString();
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u81ea\u52a8\u7ed3\u675f\u5bfb\u8d27\u5b9a\u65f6\u4efb\u52a1\u4e1a\u52a1]-\u5bfb\u8d27\u5355\u7ed3\u675f\u7ad9\u5185\u4fe1\u5185\u5bb9|text:{}", (Object)text);
        messageAtomReqBO.setTitel(title);
        messageAtomReqBO.setText(text);
        PebSendMessageAtomRspBO remindAtomRspBO = this.pebSendMessageAtomService.dealPebSendMessage(messageAtomReqBO);
        if (!"0000".equals(remindAtomRspBO.getRespCode())) {
            log.error("[\u5546\u54c1\u4e2d\u5fc3-\u81ea\u52a8\u7ed3\u675f\u5bfb\u8d27\u5b9a\u65f6\u4efb\u52a1\u4e1a\u52a1]-sendInnerMessage::\u53d1\u9001\u7ad9\u5185\u4fe1\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)remindAtomRspBO.getRespDesc());
        }
    }
}

