/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccNewSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirRspBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.zone.ability.bo.UccUserdefinedSkuBackonauditAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccUserdefinedSkuBackonauditAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccUserdefinedSkuBackonauditBusiService;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccUserdefinedSkuBackonauditBusiServiceImpl
implements UccUserdefinedSkuBackonauditBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUserdefinedSkuBackonauditBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccNewSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService auditOrderAuditAbilityService;

    @Override
    public UccUserdefinedSkuBackonauditAbilityRspBO dealUccUserdefinedSkuBackonaudit(UccUserdefinedSkuBackonauditAbilityReqBO reqBO) {
        UccUserdefinedSkuBackonauditAbilityRspBO rspBO = new UccUserdefinedSkuBackonauditAbilityRspBO();
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        List<Object> skus = new ArrayList();
        for (Long supplierShopId : mapSku.keySet()) {
            skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List uccSkuPos = null;
            try {
                uccSkuPos = this.uccSkuMapper.batchQrySku(skus, supplierShopId);
                if (uccSkuPos.size() < skus.size()) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u5355\u54c1\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                    return rspBO;
                }
            }
            catch (Exception e) {
                log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5355\u54c1\u6062\u590d\u4e0a\u67b6\u5ba1\u6838]-\u5355\u54c1\u6062\u590d\u4e0a\u67b6\u5ba1\u6838\u72b6\u6001\u6821\u9a8c\u5931\u8d25|", (Throwable)e);
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            UacNoTaskAuditOrderAuditReqBO uocAuditAbilityAuditReqBO = null;
            if (CollectionUtils.isEmpty((Collection)uccSkuPos)) continue;
            Map<String, List<UccSkuPo>> mapForAuditSku = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getStepId));
            HashMap ext = new HashMap(1);
            for (Map.Entry<String, List<UccSkuPo>> stringListEntry : mapForAuditSku.entrySet()) {
                UacNoTaskAuditOrderAuditRspBO uocAuditAbilityAuditRspBO;
                uocAuditAbilityAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
                uocAuditAbilityAuditReqBO.setObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER);
                List<UccSkuPo> skuPoListTmp = stringListEntry.getValue();
                List<Long> skuIds = skuPoListTmp.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                uocAuditAbilityAuditReqBO.setObjId(skuIds);
                uocAuditAbilityAuditReqBO.setStepId(stringListEntry.getKey().toString());
                uocAuditAbilityAuditReqBO.setAuditResult(reqBO.getAuditResult());
                uocAuditAbilityAuditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
                uocAuditAbilityAuditReqBO.setOperId(reqBO.getUserId().toString());
                uocAuditAbilityAuditReqBO.setUsername(reqBO.getUsername());
                uocAuditAbilityAuditReqBO.setOrgId(reqBO.getOrgId());
                uocAuditAbilityAuditReqBO.setOrgName(reqBO.getOrgName());
                uocAuditAbilityAuditReqBO.setOperDept(reqBO.getCompanyName());
                uocAuditAbilityAuditReqBO.setExt(ext);
                uocAuditAbilityAuditReqBO.setMsgFlag(Integer.valueOf(0));
                try {
                    uocAuditAbilityAuditRspBO = this.auditOrderAuditAbilityService.dealAudit(uocAuditAbilityAuditReqBO);
                    if (!"0000".equals(uocAuditAbilityAuditRspBO.getRespCode())) {
                        throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), uocAuditAbilityAuditRspBO.getRespDesc());
                    }
                }
                catch (BusinessException e) {
                    throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), e.getMsgInfo());
                }
                if (uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
                    if (reqBO.getAuditResult() == 0) {
                        this.updateSkuStatus(SkuStatusEnum.ON_SHELVES_STATUS.getStatus(), ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_NONE.toString(), "null", skuIds, supplierShopId, reqBO);
                        try {
                            for (Long skuId : skuIds) {
                                UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                                uccSkuPutCirReqBO.setUptype(Integer.valueOf(1));
                                uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr((Date)new Date()));
                                uccSkuPutCirReqBO.setSkuId(skuId);
                                uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                                uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                                uccSkuPutCirReqBO.setRemark("\u6062\u590d\u4e0a\u67b6");
                                UccSkuPutCirRspBO uccSkuPutCirRspBO = this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                                if ("0000".equals(uccSkuPutCirRspBO.getRespCode())) continue;
                                throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                            }
                            continue;
                        }
                        catch (Exception e) {
                            throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                        }
                    }
                    if (reqBO.getAuditResult() != 1) continue;
                    try {
                        this.updateSkuStatus(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus(), ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_REJECT.toString(), "null", skus, supplierShopId, reqBO);
                        continue;
                    }
                    catch (Exception e) {
                        throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
                    }
                }
                try {
                    if (StringUtils.isEmpty((Object)uocAuditAbilityAuditRspBO.getNoneInstanceBO().getStepId())) continue;
                    this.uccSkuMapper.batchUpdateStepBySkuId(skuIds, uocAuditAbilityAuditRspBO.getNoneInstanceBO().getStepId(), supplierShopId);
                }
                catch (Exception e) {
                    throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId, UccUserdefinedSkuBackonauditAbilityReqBO reqBO) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (ModelRuleConstant.SKU_STATUS_ON_SHELF.equals(newStatus)) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

