/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.api.UccNewSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.zone.ability.bo.UccUserdefinedSkuRestoremerchandisingAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccUserdefinedSkuRestoremerchandisingAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccUserdefinedSkuRestoremerchandisingBusiService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccUserdefinedSkuRestoremerchandisingBusiServiceImpl
implements UccUserdefinedSkuRestoremerchandisingBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUserdefinedSkuRestoremerchandisingBusiServiceImpl.class);
    @Value(value="${ARG_REINSTATE_PROCESS}")
    private String process;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccApproveCreationAtomService uccApproveCreationAtomService;
    @Autowired
    private UccNewSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;

    @Override
    public UccUserdefinedSkuRestoremerchandisingAbilityRspBO dealAgrBackonApply(UccUserdefinedSkuRestoremerchandisingAbilityReqBO reqBO) {
        UccUserdefinedSkuRestoremerchandisingAbilityRspBO rspBO = new UccUserdefinedSkuRestoremerchandisingAbilityRspBO();
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        List<Object> skus = new ArrayList();
        for (Long supplierShopId : mapSku.keySet()) {
            UccApproveCreationAtomRspBO uccApproveCreationAtomRspBO;
            Object approveCreationAtomReqBO;
            skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List uccSkuPos = null;
            uccSkuPos = this.uccSkuMapper.batchQrySku(skus, supplierShopId);
            if (uccSkuPos.size() < skus.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u5355\u54c1\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                return rspBO;
            }
            List collect = uccSkuPos.stream().filter(uccSkuPo -> (SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(uccSkuPo.getSkuStatus()) || SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus().equals(uccSkuPo.getSkuStatus())) && !ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO.equals(uccSkuPo.getApprovalStatus())).collect(Collectors.toList());
            if (collect.size() != uccSkuPos.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5b58\u5728\u5355\u54c1\u72b6\u6001\u6216\u5ba1\u6838\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                return rspBO;
            }
            rspBO.setRespDesc("\u6210\u529f");
            int needAuditCnt = 0;
            int noAuditCnt = 0;
            ArrayList<Long> needAuditSkus = new ArrayList<Long>();
            ArrayList<Long> noAuditSkus = new ArrayList<Long>();
            ArrayList<Long> compAuditSkus = new ArrayList<Long>();
            for (UccBatchSkuBO uccBatchSkuBO : reqBO.getBatchSkuList()) {
                if ("1".equals(uccBatchSkuBO.getHasAuditFlag())) {
                    needAuditSkus.add(uccBatchSkuBO.getSkuId());
                    ++needAuditCnt;
                    continue;
                }
                if ("2".equals(uccBatchSkuBO.getHasAuditFlag())) {
                    compAuditSkus.add(uccBatchSkuBO.getSkuId());
                    continue;
                }
                noAuditSkus.add(uccBatchSkuBO.getSkuId());
                ++noAuditCnt;
            }
            if (!CollectionUtils.isEmpty(compAuditSkus)) {
                approveCreationAtomReqBO = new UccApproveCreationAtomReqBO();
                BeanUtils.copyProperties((Object)reqBO, (Object)approveCreationAtomReqBO);
                approveCreationAtomReqBO.setObjId(compAuditSkus);
                approveCreationAtomReqBO.setMenuId(this.process);
                approveCreationAtomReqBO.setObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER);
                approveCreationAtomReqBO.setOrderId(supplierShopId);
                approveCreationAtomReqBO.setUserId(reqBO.getUserId());
                uccApproveCreationAtomRspBO = null;
                try {
                    uccApproveCreationAtomRspBO = this.uccApproveCreationAtomService.createApprove((UccApproveCreationAtomReqBO)approveCreationAtomReqBO);
                }
                catch (Exception e) {
                    throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), e.getMessage());
                }
                if (!"0000".equals(uccApproveCreationAtomRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), uccApproveCreationAtomRspBO.getRespDesc());
                }
                if (uccApproveCreationAtomRspBO.getNotFindFlag().booleanValue() || uccApproveCreationAtomRspBO.getFinish().booleanValue()) {
                    throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u5931\u8d25:\u6d41\u7a0bkey[" + this.process + "]\u7684\u6d41\u7a0b\u56fe\u672a\u627e\u5230,\u8bf7\u68c0\u67e5\u914d\u7f6e");
                }
                try {
                    this.updateSkuStatus(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus(), ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO.toString(), uccApproveCreationAtomRspBO.getStepId(), compAuditSkus, supplierShopId, reqBO);
                }
                catch (Exception e) {
                    throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
                }
            }
            if (!CollectionUtils.isEmpty(needAuditSkus)) {
                approveCreationAtomReqBO = new UccApproveCreationAtomReqBO();
                BeanUtils.copyProperties((Object)reqBO, (Object)approveCreationAtomReqBO);
                approveCreationAtomReqBO.setObjId(needAuditSkus);
                approveCreationAtomReqBO.setMenuId(this.process);
                approveCreationAtomReqBO.setObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER);
                approveCreationAtomReqBO.setOrderId(supplierShopId);
                approveCreationAtomReqBO.setUserId(reqBO.getUserId());
                uccApproveCreationAtomRspBO = null;
                try {
                    uccApproveCreationAtomRspBO = this.uccApproveCreationAtomService.createApprove((UccApproveCreationAtomReqBO)approveCreationAtomReqBO);
                }
                catch (Exception e) {
                    throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), e.getMessage());
                }
                if (!"0000".equals(uccApproveCreationAtomRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), uccApproveCreationAtomRspBO.getRespDesc());
                }
                if (uccApproveCreationAtomRspBO.getNotFindFlag().booleanValue() || uccApproveCreationAtomRspBO.getFinish().booleanValue()) {
                    throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u5931\u8d25:\u6d41\u7a0bkey[" + this.process + "]\u7684\u6d41\u7a0b\u56fe\u672a\u627e\u5230,\u8bf7\u68c0\u67e5\u914d\u7f6e");
                }
                try {
                    this.updateSkuStatus(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus(), ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO.toString(), uccApproveCreationAtomRspBO.getStepId(), needAuditSkus, supplierShopId, reqBO);
                }
                catch (Exception e) {
                    throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
                }
            }
            if (!CollectionUtils.isEmpty(noAuditSkus)) {
                this.updateSkuStatus(SkuStatusEnum.ON_SHELVES_STATUS.getStatus(), "", "", noAuditSkus, supplierShopId, reqBO);
                try {
                    for (Long skuId : noAuditSkus) {
                        UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                        uccSkuPutCirReqBO.setSkuId(skuId);
                        uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                        uccSkuPutCirReqBO.setUptype(Integer.valueOf(1));
                        uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr((Date)new Date()));
                        uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                        uccSkuPutCirReqBO.setRemark("\u6062\u590d\u4e0a\u67b6");
                        this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                    }
                }
                catch (Exception e) {
                    throw new BusinessException("8888", "\u66f4\u65b0\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                }
            }
            if (needAuditCnt == 1 && noAuditCnt == 0) {
                rspBO.setRespDesc("\u8be5\u5546\u54c1\u5173\u8054\u4e86\u5e73\u53f0\u534f\u8bae\uff0c\u6b63\u5728\u4e0a\u67b6\u5ba1\u6838\u4e2d");
                continue;
            }
            if (needAuditCnt == 0 && noAuditCnt == 1) {
                rspBO.setRespDesc("\u4e0a\u67b6\u6210\u529f");
                continue;
            }
            if (needAuditCnt == 0 && noAuditCnt == 0) {
                rspBO.setRespDesc("\u6210\u529f");
                continue;
            }
            rspBO.setRespDesc(noAuditCnt + "\u6761\u5546\u54c1\u5df2\u4e0a\u67b6\u5b8c\u6210\uff0c" + needAuditCnt + "\u6761\u5546\u54c1\u5173\u8054\u4e86\u5e73\u53f0\u534f\u8bae\uff0c\u6b63\u5728\u4e0a\u67b6\u5ba1\u6838\u4e2d");
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId, UccUserdefinedSkuRestoremerchandisingAbilityReqBO reqBO) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (ModelRuleConstant.SKU_STATUS_ON_SHELF.equals(newStatus)) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

