/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.api.AgrOperAgreementItemListSysnAbilityService;
import com.tydic.agreement.ability.api.AgrQryAgreementDetailAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementItemBO;
import com.tydic.agreement.ability.bo.AgrOperAgreementItemListSysnAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrOperAgreementItemListSysnAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementDetailAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementDetailAbilityRspBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.api.UccNewSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.dao.UccOrgSkuMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccOrgSkuPO;
import com.tydic.commodity.po.UccSkuAgrAgreementItemPO;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.zone.ability.bo.UccUserdefinedSkuTheshelvesserviceAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccUserdefinedSkuTheshelvesserviceAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccUserdefinedSkuTheshelvesserviceBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccUserdefinedSkuTheshelvesserviceBusiServiceImpl
implements UccUserdefinedSkuTheshelvesserviceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUserdefinedSkuTheshelvesserviceBusiServiceImpl.class);
    @Value(value="${ARG_OFF_SHELF_PROCESS}")
    private String process;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccApproveCreationAtomService uccApproveCreationAtomService;
    @Autowired
    private UccNewSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UccOrgSkuMapper uccOrgSkuMapper;
    @Autowired
    private AgrOperAgreementItemListSysnAbilityService agrOperAgreementItemListSysnAbilityService;
    @Autowired
    private AgrQryAgreementDetailAbilityService agrQryAgreementDetailAbilityService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @Override
    public UccUserdefinedSkuTheshelvesserviceAbilityRspBO dealUccUserdefinedSkuTheshelvesservice(UccUserdefinedSkuTheshelvesserviceAbilityReqBO reqBO) {
        UccUserdefinedSkuTheshelvesserviceAbilityRspBO rspBO = new UccUserdefinedSkuTheshelvesserviceAbilityRspBO();
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        List<Object> skus = new ArrayList();
        for (Long supplierShopId : mapSku.keySet()) {
            skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List uccSkuPos = null;
            uccSkuPos = this.uccSkuMapper.batchQrySku(skus, supplierShopId);
            if (uccSkuPos.size() < skus.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u5355\u54c1\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                return rspBO;
            }
            List collect = uccSkuPos.stream().filter(uccSkuPo -> SkuStatusEnum.ON_SHELVES_STATUS.getStatus().equals(uccSkuPo.getSkuStatus()) && !ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO.equals(uccSkuPo.getApprovalStatus())).collect(Collectors.toList());
            if (collect.size() != uccSkuPos.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5b58\u5728\u5355\u54c1\u72b6\u6001\u6216\u5ba1\u6838\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                return rspBO;
            }
            this.updateSkuStatus(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus(), "", "", skus, supplierShopId, reqBO);
            try {
                for (Long l : skus) {
                    UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                    uccSkuPutCirReqBO.setSkuId(l);
                    uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                    uccSkuPutCirReqBO.setDownType(Integer.valueOf(1));
                    uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr((Date)new Date()));
                    uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                    uccSkuPutCirReqBO.setRemark("\u624b\u5de5\u4e0b\u67b6");
                    this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                }
            }
            catch (Exception e) {
                log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5355\u54c1\u4e0b\u67b6\u5904\u7406]-\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25|", (Throwable)e);
                throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
            }
            this.syncAgrInfo(skus, "1");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId, UccUserdefinedSkuTheshelvesserviceAbilityReqBO reqBO) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (newStatus == ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }

    private void syncAgrInfo(List<Long> skuIds, String type) {
        List uccSkuAgrAgreementItemPOS = this.uccOrgSkuMapper.qrySkuAgrList(skuIds);
        if (!CollectionUtils.isEmpty((Collection)uccSkuAgrAgreementItemPOS)) {
            ArrayList<UccSkuAgrAgreementItemPO> needDownAgreementItemPOS = new ArrayList<UccSkuAgrAgreementItemPO>();
            ArrayList<Long> virtualSkuIds = new ArrayList<Long>();
            for (UccSkuAgrAgreementItemPO agrAgreementItemPO : uccSkuAgrAgreementItemPOS) {
                if (agrAgreementItemPO.getOrgSkuStatus() == 12) continue;
                AgrQryAgreementDetailAbilityReqBO agreementDetailReqBO = new AgrQryAgreementDetailAbilityReqBO();
                agreementDetailReqBO.setAgreementId(agrAgreementItemPO.getAgreementId());
                AgrQryAgreementDetailAbilityRspBO agreementDetailAbilityRspBO = this.agrQryAgreementDetailAbilityService.qryAgreementDetail(agreementDetailReqBO);
                if (!Objects.nonNull(agreementDetailAbilityRspBO) || !"0000".equals(agreementDetailAbilityRspBO.getRespCode()) || !"2".equals(agreementDetailAbilityRspBO.getAgrAgreementBO().getAgreementMode()) || "4".equals(agreementDetailAbilityRspBO.getAgrAgreementBO().getAgreementStatus()) || "5".equals(agreementDetailAbilityRspBO.getAgrAgreementBO().getAgreementStatus())) continue;
                UccOrgSkuPO set = new UccOrgSkuPO();
                UccOrgSkuPO where = new UccOrgSkuPO();
                set.setSkuStatus(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus());
                set.setAgreementItemStatus("2");
                where.setSkuId(agrAgreementItemPO.getSkuId());
                where.setAgreementId(agrAgreementItemPO.getAgreementId());
                where.setSkuStatus(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
                this.uccOrgSkuMapper.updateBy(set, where);
                needDownAgreementItemPOS.add(agrAgreementItemPO);
                virtualSkuIds.add(agrAgreementItemPO.getVirtualSkuId());
            }
            if (!CollectionUtils.isEmpty(needDownAgreementItemPOS)) {
                String json = JSONArray.toJSONString(needDownAgreementItemPOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
                List agrAgreementItemBOs = JSONArray.parseArray((String)json, AgrAgreementItemBO.class);
                agrAgreementItemBOs.stream().forEach(e -> e.setAgreementItemStatus("2"));
                AgrOperAgreementItemListSysnAbilityReqBO agrReq = new AgrOperAgreementItemListSysnAbilityReqBO();
                agrReq.setAgrAgreementItemBOs(agrAgreementItemBOs);
                agrReq.setOperType(type);
                log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5355\u54c1\u4e0b\u67b6\u5904\u7406]-dealUccUserdefinedSkuTheshelvesservice\uff1a\u540c\u6b65\u534f\u8bae\u5546\u54c1\u4fe1\u606f\u5165\u53c2|agrReq:{}", (Object)JSONObject.toJSONString((Object)agrReq));
                AgrOperAgreementItemListSysnAbilityRspBO agrOperAgreementItemListSysnAbilityRspBO = this.agrOperAgreementItemListSysnAbilityService.operAgreementItemListSysn(agrReq);
                log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5355\u54c1\u4e0b\u67b6\u5904\u7406]-dealUccUserdefinedSkuTheshelvesservice\uff1a\u540c\u6b65\u534f\u8bae\u5546\u54c1\u4fe1\u606f\u51fa\u53c2|agrOperAgreementItemListSysnAbilityRspBO:{}", (Object)JSONObject.toJSONString((Object)agrOperAgreementItemListSysnAbilityRspBO));
                if (!agrOperAgreementItemListSysnAbilityRspBO.getRespCode().equals("0000")) {
                    throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), "\u540c\u6b65\u534f\u8bae\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
    }
}

