/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.atom.bo.UocProRpcMockAtomRemoteReqBo;
import com.tydic.uoc.busibase.atom.bo.UocProRpcMockAtomRemoteRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UocProRpcMockAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocProRpcMockAtomService.class);
    @Value(value="${uoc.mock.rpc.url:http://10.100.50.82:10130/deploy/federate/noauth/rpc}")
    private String rpcCallUrl;
    private static final String SUCCESS_CODE = "0";

    public <T> T rpcMockData(String interClassName, String methodName, Object data, Class<T> returnClass) {
        this.validateArg(interClassName, methodName, data, returnClass);
        UocProRpcMockAtomRemoteReqBo remoteReqBo = new UocProRpcMockAtomRemoteReqBo();
        remoteReqBo.setInterClass(interClassName);
        remoteReqBo.setMethod(methodName);
        remoteReqBo.setData(data);
        String jsonStr = JSON.toJSONString((Object)remoteReqBo);
        String body = null;
        try {
            body = HttpRequest.post((String)this.rpcCallUrl).body(jsonStr).timeout(60000).execute().body();
        }
        catch (HttpException e) {
            e.printStackTrace();
            log.info("rpc mock\u8c03\u7528URL\uff1a=========\u300b\u300b\u300b\u300b" + this.rpcCallUrl);
            log.info("rpc mock\u8c03\u7528\u5165\u53c2\uff1a=========\u300b\u300b\u300b\u300b" + jsonStr);
        }
        UocProRpcMockAtomRemoteRspBo remoteRspBo = (UocProRpcMockAtomRemoteRspBo)JSON.parseObject((String)body, UocProRpcMockAtomRemoteRspBo.class);
        String code = remoteRspBo.getCode();
        if (SUCCESS_CODE.equals(code)) {
            Object rspObj = JSON.parseObject((String)remoteRspBo.getData(), returnClass);
            return (T)rspObj;
        }
        log.info("rpc mock\u8c03\u7528\u5165\u53c2\uff1a=========\u300b\u300b\u300b\u300b" + jsonStr);
        log.error("RPC\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u5931\u8d25\u4fe1\u606f\uff1a" + remoteRspBo.getMessage() + ",\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)remoteRspBo));
        throw new UocProBusinessException("211002", "RPC\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u5931\u8d25\u4fe1\u606f\uff1a" + remoteRspBo.getMessage());
    }

    private void validateArg(String interClassName, String methodName, Object data, Class returnClass) {
        if (ObjectUtil.isEmpty((Object)interClassName)) {
            throw new UocProBusinessException("211002", "[interClassName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)methodName)) {
            throw new UocProBusinessException("211002", "[methodName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)data)) {
            throw new UocProBusinessException("211002", "[data]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)returnClass)) {
            throw new UocProBusinessException("211002", "[returnClass]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

