/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.ESBParamUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebIntfAfsCancelAbilityService;
import com.tydic.uoc.busibase.busi.bo.PebIntfAfsCancelReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfAfsCancelRspBO;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PebIntfAfsCancelAbilityServiceImpl
implements PebIntfAfsCancelAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfAfsCancelAbilityService.class);

    @Override
    public PebIntfAfsCancelRspBO cancelServiceOrder(PebIntfAfsCancelReqBO reqBO) {
        PebIntfAfsCancelRspBO rspBO;
        try {
            String reqStr = this.initPostStr(reqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)"ESB_SERVICE_CANCEL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("2000", "\u7535\u5546\u552e\u540e\u53d6\u6d88ESB[http_status=" + httpRetBean.getStatus() + "], [http_url=" + OrderPropertiesUtil.getProperty((String)"ESB_SERVICE_CANCEL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB \u7535\u5546\u552e\u540e\u53d6\u6d88ESB\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u7535\u5546\u552e\u540e\u53d6\u6d88ESB:" + e.getMessage());
            throw new UocProBusinessException("6000", "\u7535\u5546\u552e\u540e\u53d6\u6d88ESB\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initPostStr(PebIntfAfsCancelReqBO reqBO) {
        String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupplierId()));
        String esbReqParam = ESBParamUtil.getEsbReqParam((Object)reqBO, (String)hsn, (String)"BUSINESS_ORDER");
        LOGGER.info("\u7535\u5546\u552e\u540e\u53d6\u6d88ESB\u63a5\u53e3" + OrderPropertiesUtil.getProperty((String)"ESB_SERVICE_CANCEL") + "\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        return esbReqParam;
    }

    private PebIntfAfsCancelRspBO resolveRsp(String returnString) {
        LOGGER.debug("\u7535\u5546\u552e\u540e\u53d6\u6d88ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        PebIntfAfsCancelRspBO rspBO = new PebIntfAfsCancelRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
        } else {
            rspBO.setRespCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)rspJsonObject.get((Object)"resultMessage"));
        }
        return rspBO;
    }
}

