/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.ESBParamUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebIntfConfirmOrderBusiService;
import com.tydic.uoc.busibase.busi.bo.ConfirmOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.ConfirmOrderRspBO;
import java.net.URI;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebIntfConfirmOrderBusiService")
public class PebIntfConfirmOrderBusiServiceImpl
implements PebIntfConfirmOrderBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfConfirmOrderBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    @Override
    public ConfirmOrderRspBO confirmOrder(ConfirmOrderReqBO confirmOrderReqBO) {
        ConfirmOrderRspBO rspBO;
        try {
            String reqStr = this.initPostStr(confirmOrderReqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)"ESB_CONFIRM_ORDER_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u8ba2\u5355\u786e\u8ba4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + OrderPropertiesUtil.getProperty((String)"ESB_CONFIRM_ORDER_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "\u8ba2\u5355\u786e\u8ba4\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u8ba2\u5355\u786e\u8ba4\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8ba2\u5355\u786e\u8ba4\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u8ba2\u5355\u786e\u8ba4\u670d\u52a1\u63a5\u53e3\u5f02\u5e38" + e);
            throw new UocProBusinessException("6000", "\u8ba2\u5355\u786e\u8ba4\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u8ba2\u5355\u786e\u8ba4\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initPostStr(ConfirmOrderReqBO confirmOrderReqBO) {
        String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + confirmOrderReqBO.getSupplierId()));
        String esbReqParam = ESBParamUtil.getEsbReqParam((Object)confirmOrderReqBO, (String)hsn, (String)"BUSINESS_ORDER");
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u8ba2\u5355\u786e\u8ba4ESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        }
        return esbReqParam;
    }

    private ConfirmOrderRspBO resolveRsp(String returnString) {
        LOGGER.debug("\u8c03\u7528\u8ba2\u5355\u786e\u8ba4ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        ConfirmOrderRspBO rspBO = new ConfirmOrderRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (jsonObject.getBoolean("success").booleanValue()) {
            rspBO.setResult(jsonObject.getBoolean("success"));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setResult(jsonObject.getBoolean("result"));
            rspBO.setRespCode((String)jsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        }
        return rspBO;
    }
}

