/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.enums.LogisticsCompanyCode;
import com.tydic.uoc.base.enums.LogisticsStateCode;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebIntfLogisticsBusiService;
import com.tydic.uoc.busibase.busi.bo.LogisticsItemBO;
import com.tydic.uoc.busibase.busi.bo.QueryLogisticsReqBO;
import com.tydic.uoc.busibase.busi.bo.QueryLogisticsRspBO;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pebIntfLogisticsBusiService")
public class PebIntfLogisticsBusiServiceImpl
implements PebIntfLogisticsBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebIntfLogisticsBusiServiceImpl.class);

    @Override
    public QueryLogisticsRspBO dealLogistics(QueryLogisticsReqBO reqBO) {
        QueryLogisticsRspBO rspBO;
        try {
            if (!StringUtils.isBlank((CharSequence)reqBO.getCellphoneWeb())) {
                reqBO.setCellphone(reqBO.getCellphoneWeb());
            }
            String reqStr = this.initPostStr(reqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)"ESB_QRY_ORDER_LOGISTICS_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u5feb\u9012100\u63a5\u53e3\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + OrderPropertiesUtil.getProperty((String)"ESB_QRY_ORDER_LOGISTICS_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new UocProBusinessException("2001", "\u8c03\u7528\u5feb\u9012100\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5feb\u9012100\u63a5\u53e3\u5f02\u5e38" + e);
            throw new UocProBusinessException("6000", "\u8c03\u7528\u5feb\u9012100\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String code(QueryLogisticsReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("num", (Object)reqBO.getSaleVoucherNo());
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)"ESB_QRY_ORDER_LOGISTICS_CODE_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])jsonObject.toJSONString().getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            String returnString = httpRetBean.getStr();
            JSONObject result = JSONObject.parseObject((String)returnString);
            return result.getString("comCode");
        }
        catch (Exception e) {
            return null;
        }
    }

    private String initPostStr(QueryLogisticsReqBO queryLogisticsReqBO) {
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        String companyCode = this.code(queryLogisticsReqBO);
        if (StringUtils.isBlank((CharSequence)companyCode)) {
            companyCode = LogisticsCompanyCode.companyCode((String)queryLogisticsReqBO.getCompany());
        }
        param.put("com", companyCode);
        param.put("num", queryLogisticsReqBO.getSaleVoucherNo());
        param.put("from", queryLogisticsReqBO.getFrom() == null ? "" : queryLogisticsReqBO.getFrom());
        param.put("phone", queryLogisticsReqBO.getCellphone() == null ? "" : queryLogisticsReqBO.getCellphone());
        param.put("to", queryLogisticsReqBO.getTo() == null ? "" : queryLogisticsReqBO.getTo());
        param.put("resultv2", "1");
        param.put("show", "0");
        param.put("order", "");
        String reqParam = JSON.toJSONString(param);
        log.debug("\u8c03\u7528\u5feb\u9012100\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + reqParam);
        return reqParam;
    }

    private QueryLogisticsRspBO resolveRsp(String returnString) {
        log.debug("\u8c03\u7528\u7269\u6d41\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        QueryLogisticsRspBO rspBO = new QueryLogisticsRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (200 == jsonObject.getIntValue("status")) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            if (null != jsonObject.get((Object)"data")) {
                String jsonStr = JSONObject.toJSONString((Object)jsonObject.get((Object)"data"));
                List logisticsContentBos = JSON.parseArray((String)jsonStr, LogisticsItemBO.class);
                Integer isCheck = jsonObject.getInteger("ischeck");
                String companyCode = jsonObject.getString("com");
                String orderNo = jsonObject.getString("nu");
                Integer state = jsonObject.getInteger("state");
                String companyName = LogisticsCompanyCode.companyName((String)companyCode);
                String logisticsState = LogisticsStateCode.logisticsState((Integer)state);
                rspBO.setIsCheck(isCheck);
                rspBO.setOrderNo(orderNo);
                rspBO.setStreamCompany(companyName);
                rspBO.setState(logisticsState);
                rspBO.setLogisticsInfo(logisticsContentBos);
            }
        } else {
            rspBO.setRespCode((String)jsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        }
        return rspBO;
    }
}

