/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebIntfSelectInspestionAmtService;
import com.tydic.uoc.busibase.busi.bo.BusiInspectionInfoRspBO;
import com.tydic.uoc.busibase.busi.bo.BusiInspectionItemInfoBO;
import com.tydic.uoc.busibase.busi.bo.BusiInspectionPushInfoReqBO;
import com.tydic.uoc.dao.OrdInspectionItemMapper;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.po.OrdInspectionPO;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebIntfSelectInspestionAmtServiceImpl
implements PebIntfSelectInspestionAmtService {
    private static final Logger log = LoggerFactory.getLogger(PebIntfSelectInspestionAmtServiceImpl.class);
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdInspectionItemMapper ordInspectionItemMapper;

    @Override
    public BusiInspectionInfoRspBO selectAmt(BusiInspectionPushInfoReqBO inspectionPushInfoReqBO) {
        BusiInspectionInfoRspBO rsp = new BusiInspectionInfoRspBO();
        OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
        ordInspectionPO.setInspectionVoucherId(inspectionPushInfoReqBO.getInspectionId());
        List<OrdInspectionPO> list = this.ordInspectionMapper.getList(ordInspectionPO);
        if (null != list && list.size() > 0) {
            OrdInspectionPO ordInspectionPO1 = list.get(0);
            try {
                rsp.setInspectionPurAmt(MoneyUtils.Long2BigDecimal((Long)ordInspectionPO1.getInspTotalPurchaseFee()));
                rsp.setInspectionSaleAmt(MoneyUtils.Long2BigDecimal((Long)ordInspectionPO1.getInspTotalSaleFee()));
            }
            catch (Exception e) {
                log.error("[\u67e5\u8be2\u9a8c\u6536\u5355\u91d1\u989d\u4ee5\u53ca\u660e\u7ec6\u91d1\u989d]-\u8f6c\u6362\u91d1\u989d\u62a5\u9519");
                throw new UocProBusinessException("6000", "[\u67e5\u8be2\u9a8c\u6536\u5355\u91d1\u989d\u4ee5\u53ca\u660e\u7ec6\u91d1\u989d]-\u8f6c\u6362\u91d1\u989d\u62a5\u9519");
            }
            BigDecimal returnSalePrice = BigDecimal.ZERO;
            BigDecimal returnPurPrice = BigDecimal.ZERO;
            List<BusiInspectionItemInfoBO> inspectionItemByID = this.ordInspectionItemMapper.getInspectionItemGroupByItem(inspectionPushInfoReqBO.getInspectionId());
            if (null != inspectionItemByID && inspectionItemByID.size() > 0) {
                for (BusiInspectionItemInfoBO inspectionItemInfoBO : inspectionItemByID) {
                    if (null == inspectionItemInfoBO.getAlreadyReturnCount()) continue;
                    inspectionItemInfoBO.setCount(inspectionItemInfoBO.getCount().subtract(inspectionItemInfoBO.getAlreadyReturnCount()));
                    inspectionItemInfoBO.setSkuPurAmt(inspectionItemInfoBO.getSkuPurPrice().multiply(inspectionItemInfoBO.getCount()));
                    inspectionItemInfoBO.setSkuSaleAmt(inspectionItemInfoBO.getSkuSalePrice().multiply(inspectionItemInfoBO.getCount()));
                    returnPurPrice = returnPurPrice.add(inspectionItemInfoBO.getSkuPurPrice().multiply(inspectionItemInfoBO.getAlreadyReturnCount()));
                    returnSalePrice = returnSalePrice.add(inspectionItemInfoBO.getSkuSalePrice().multiply(inspectionItemInfoBO.getAlreadyReturnCount()));
                }
                if (returnSalePrice.compareTo(BigDecimal.ZERO) != 0) {
                    rsp.setInspectionPurAmt(rsp.getInspectionPurAmt().subtract(returnPurPrice));
                    rsp.setInspectionSaleAmt(rsp.getInspectionSaleAmt().subtract(returnSalePrice));
                }
                rsp.setInspectionItemInfoBOS(inspectionItemByID);
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }
}

