/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.bo.UocProBaseRspBo;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfSettlementAbilityService;
import com.tydic.uoc.busibase.busi.bo.PebIntfAddOrDropMoneyToSettleReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfAddOrDropMoneyToSettleRspBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfMakingOrderPayReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfMakingOrderPayRspBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfMakingOrderRefundReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfMakingOrderRefundRspBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfQryPayAgentInfoReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfQryPayAgentInfoRspBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfRecordWaterReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfRecordWaterRspBO;
import com.tydic.uoc.dao.OrdInterLogMapper;
import com.tydic.uoc.po.OrdInterLogPO;
import java.util.Date;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PebIntfSettlementAbilityServiceImpl
implements PebIntfSettlementAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfSettlementAbilityServiceImpl.class);
    @Value(value="${qryPayAgentInfoUrl:http://10.100.50.213:8080/rest/service/routing/nouser/qryPayAgentInfoService}")
    String qryPayAgentInfoUrl;
    @Value(value="${makingOrderPayUrl:http://10.100.50.213:8080/rest/service/routing/nouser/busiOrderPayService}")
    String makingOrderPayUrl;
    @Value(value="${makingOrderRefundUrl:http://10.100.50.213:8080/rest/service/routing/nouser/busiOrderRefundService}")
    String makingOrderRefundUrl;
    @Value(value="${recordWaterUrl:http://10.100.50.213:8080/rest/service/routing/nouser/recordWaterService}")
    String recordWaterUrl;
    @Autowired
    private OrdInterLogMapper ordInterLogMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;

    @Override
    public PebIntfQryPayAgentInfoRspBO qryPayAgentInfo(PebIntfQryPayAgentInfoReqBO reqBO) {
        if (reqBO == null || StringUtils.isEmpty((Object)reqBO.getParamOrgId())) {
            return (PebIntfQryPayAgentInfoRspBO)UocProRspBoUtil.failed((String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", PebIntfQryPayAgentInfoRspBO.class);
        }
        return this.doUrlPostRequest(reqBO, this.qryPayAgentInfoUrl, PebIntfQryPayAgentInfoRspBO.class);
    }

    @Override
    public PebIntfAddOrDropMoneyToSettleRspBO addOrDropMoneyToSettle(PebIntfAddOrDropMoneyToSettleReqBO reqBO) {
        this.validParams(reqBO);
        if (PebExtConstant.settlePayType.YF_PAY.equals(reqBO.getPayType())) {
            if ("20".equals(reqBO.getBusinessType())) {
                PebIntfMakingOrderPayRspBO pebIntfMakingOrderPayRspBO = this.makingOrderPay((PebIntfMakingOrderPayReqBO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), PebIntfMakingOrderPayReqBO.class));
                return (PebIntfAddOrDropMoneyToSettleRspBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)pebIntfMakingOrderPayRspBO)), PebIntfAddOrDropMoneyToSettleRspBO.class));
            }
            if ("21".equals(reqBO.getBusinessType())) {
                PebIntfMakingOrderRefundRspBO pebIntfMakingOrderRefundRspBO = this.makingOrderRefund((PebIntfMakingOrderRefundReqBO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), PebIntfMakingOrderRefundReqBO.class));
                return (PebIntfAddOrDropMoneyToSettleRspBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)pebIntfMakingOrderRefundRspBO)), PebIntfAddOrDropMoneyToSettleRspBO.class));
            }
            LOGGER.error("[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u6682\u4e0d\u660e\u786e\u7684\u4e1a\u52a1\u7c7b\u578b");
            throw new UocProBusinessException("8888", "\u6682\u4e0d\u660e\u786e\u7684\u4e1a\u52a1\u7c7b\u578b");
        }
        if (PebExtConstant.settlePayType.AGENT_PAY.equals(reqBO.getPayType())) {
            PebIntfRecordWaterRspBO pebIntfRecordWaterRspBO = this.recordWater((PebIntfRecordWaterReqBO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), PebIntfRecordWaterReqBO.class));
            return (PebIntfAddOrDropMoneyToSettleRspBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)pebIntfRecordWaterRspBO)), PebIntfAddOrDropMoneyToSettleRspBO.class));
        }
        LOGGER.error("[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u5165\u53c2\u4e1a\u52a1\u7c7b\u578b\u6709\u8bef");
        throw new UocProBusinessException("8888", "[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u5165\u53c2\u4e1a\u52a1\u7c7b\u578b\u6709\u8bef");
    }

    private void validParams(PebIntfAddOrDropMoneyToSettleReqBO reqBO) {
        if (reqBO.getPayType() == null) {
            throw new UocProBusinessException("8888", "[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!PebExtConstant.settlePayType.YF_PAY.equals(reqBO.getPayType()) && !PebExtConstant.settlePayType.AGENT_PAY.equals(reqBO.getPayType())) {
            throw new UocProBusinessException("8888", "[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u6709\u8bef");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderNo())) {
            throw new UocProBusinessException("8888", "[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getServiceNo())) {
            throw new UocProBusinessException("8888", "[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u5165\u53c2\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderAmt() == null) {
            throw new UocProBusinessException("8888", "[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u5165\u53c2\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private PebIntfRecordWaterRspBO recordWater(PebIntfRecordWaterReqBO reqBO) {
        return this.doUrlPostRequest(reqBO, this.recordWaterUrl, PebIntfRecordWaterRspBO.class);
    }

    public PebIntfMakingOrderPayRspBO makingOrderPay(PebIntfMakingOrderPayReqBO reqBO) {
        return this.doUrlPostRequest(reqBO, this.makingOrderPayUrl, PebIntfMakingOrderPayRspBO.class);
    }

    public PebIntfMakingOrderRefundRspBO makingOrderRefund(PebIntfMakingOrderRefundReqBO reqBO) {
        return this.doUrlPostRequest(reqBO, this.makingOrderRefundUrl, PebIntfMakingOrderRefundRspBO.class);
    }

    private <T extends UocProBaseRspBo> T doUrlPostRequest(Object paramObj, String requestUrl, Class<T> tClass) {
        try {
            UocProBaseRspBo t = (UocProBaseRspBo)tClass.newInstance();
            Map requestMap = PropertyUtils.describe((Object)paramObj);
            requestMap.remove("class");
            LOGGER.debug("[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u8c03\u7528\u7ed3\u7b97\u4ed8\u6b3e\u9000\u6b3e\u670d\u52a1\u5165\u53c2\uff5c{}", (Object)JSON.toJSONString((Object)requestMap));
            String returnString = null;
            try {
                returnString = HttpRequest.post((String)requestUrl).form(requestMap).timeout(30000).execute().body();
            }
            catch (HttpException e) {
                LOGGER.error("[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u8c03\u7528\u7ed3\u7b97\u4ed8\u6b3e\u9000\u6b3e\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                returnString = "[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u8c03\u7528\u7ed3\u7b97\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5";
            }
            this.saveLog((Long)requestMap.get("ordId"), (Long)requestMap.get("objId"), JSON.toJSONString((Object)requestMap), returnString, String.valueOf(requestMap.get("serviceNo")), "\u8bb0\u5f55\u7ed3\u7b97\u63a5\u53e3\u65e5\u5fd7", "66666");
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u8c03\u7528\u7ed3\u7b97\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
            LOGGER.debug("[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u8c03\u7528\u7ed3\u7b97\u4e2d\u5fc3\u51fa\u53c2|{}", (Object)returnString);
            if (!"0000".equals(jsonObjectReturn.getString("respCode"))) {
                t.setRespCode(jsonObjectReturn.getString("respCode"));
                t.setRespDesc("\u8c03\u7528\u7ed3\u7b97\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25!" + jsonObjectReturn.getString("respDesc"));
                return (T)t;
            }
            String resultData = jsonObjectReturn.getString("data");
            if (!StringUtils.isEmpty((Object)resultData)) {
                UocProBaseRspBo data = (UocProBaseRspBo)JSONObject.parseObject((String)resultData, tClass);
                data.setRespCode("0000");
                data.setRespDesc("\u8c03\u7528\u7ed3\u7b97\u4e2d\u5fc3\u63a5\u53e3\u6210\u529f");
                return (T)data;
            }
            t.setRespCode("8888");
            t.setRespDesc("\u8c03\u7528\u7ed3\u7b97\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25!\u8fd4\u56dedata\u6570\u636e\u4e3a\u7a7a");
            return (T)t;
        }
        catch (Exception e) {
            throw new UocProBusinessException("[\u7ed3\u7b97\u5bf9\u63a5\u670d\u52a1\u5b9e\u73b0\u7c7b]-\u8c03\u7528\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\u5f02\u5e38|", e.getMessage());
        }
    }

    private void saveLog(Long orderId, Long saleId, String in, String out, String sn, String code, String errCode) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)out)) {
            out = "out";
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)in)) {
            in = "in";
        }
        int max = 3096;
        if (out.length() > max) {
            out = out.substring(0, max - 1);
        }
        if (in.length() > max) {
            in = in.substring(0, max - 1);
        }
        OrdInterLogPO logBO = new OrdInterLogPO();
        logBO.setCallCount(1);
        logBO.setCallState("1");
        logBO.setCallTime(new Date());
        logBO.setCreateLoginId("1");
        logBO.setErrCode(errCode);
        logBO.setErrDetail("1");
        logBO.setFlowFlag(1);
        logBO.setInContent(in);
        logBO.setInterCode(code);
        logBO.setInterSn(sn);
        logBO.setOutContent(out);
        logBO.setRetTime(new Date());
        logBO.setOrderId(orderId);
        logBO.setObjId(saleId);
        logBO.setObjType(UocConstant.OBJ_TYPE.JIE_SUAN);
        logBO.setId(this.idUtil.nextId());
        try {
            this.ordInterLogMapper.insert(logBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

