/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebSelcetScaleBySupplierService;
import com.tydic.uoc.busibase.busi.bo.MonthReportGeneralReqBO;
import com.tydic.uoc.busibase.busi.bo.MonthReportGeneralRspBO;
import com.tydic.uoc.busibase.busi.bo.OrderAmtBySupplierRspBO;
import com.tydic.uoc.busibase.busi.bo.SelectScaleBySupplierRspBO;
import com.tydic.uoc.common.ability.api.BusiMonthReportYfService;
import com.tydic.uoc.common.ability.bo.BusiMonthReportYfReqBO;
import com.tydic.uoc.common.ability.bo.BusiMonthReportYfRspBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocMonrpSupplierMapper;
import com.tydic.uoc.po.UocMonrpSupplierPO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebSelcetScaleBySupplierService")
public class PebSelcetScaleBySupplierServiceImpl
implements PebSelcetScaleBySupplierService {
    private static final Logger log = LoggerFactory.getLogger(PebSelcetScaleBySupplierServiceImpl.class);
    @Value(value="${orderAmtBySupplierUrl}")
    String orderAmtBySupplierUrl;
    @Autowired
    private UocMonrpSupplierMapper uocMonrpSupplierMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private BusiMonthReportYfService busiMonthReportYfService;

    @Override
    public MonthReportGeneralRspBO selectOrderAmtBySupplier(MonthReportGeneralReqBO monthReportGeneralReqBO) {
        log.info("[\u6708\u62a5-\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0b\u5355\u91d1\u989d\u670d\u52a1]-\u5165\u53c2|{}", (Object)JSONObject.toJSONString((Object)((Object)monthReportGeneralReqBO)));
        Integer isCreate = 0;
        MonthReportGeneralRspBO monthReportGeneralRspBO = new MonthReportGeneralRspBO();
        SelectScaleBySupplierRspBO rspBO = this.selectOrderAmtAndDayRspBO(monthReportGeneralReqBO);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date monthDate = null;
        try {
            monthDate = simpleDateFormat.parse(monthReportGeneralReqBO.getMonthDate());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(monthDate);
        Date startTime = calendar.getTime();
        calendar.add(2, 1);
        Date endTime = calendar.getTime();
        List<OrderAmtBySupplierRspBO> orderAmtAndSupplier = this.ordSaleMapper.getOrderAmtAndSupplier(startTime, endTime, monthReportGeneralReqBO.getPurchaseNos());
        orderAmtAndSupplier.addAll(rspBO.getOrderAmtBySupplierRspBOS());
        String orderList = null;
        for (OrderAmtBySupplierRspBO orderAmtBySupplierRspBO : orderAmtAndSupplier) {
            if (null == orderList) {
                orderList = orderAmtBySupplierRspBO.getSupOrderList();
                continue;
            }
            orderList = orderList + "," + orderAmtBySupplierRspBO.getSupOrderList();
        }
        BigDecimal bigDecimal = this.seleAmt(monthReportGeneralReqBO, orderList).divide(new BigDecimal("10000"), 2, 4);
        for (OrderAmtBySupplierRspBO orderAmtBySupplierRspBO : orderAmtAndSupplier) {
            int i;
            UocMonrpSupplierPO uocMonrpSupplierPO = new UocMonrpSupplierPO();
            uocMonrpSupplierPO.setMonrpNo(monthReportGeneralReqBO.getMonrpNo());
            uocMonrpSupplierPO.setOrgid(monthReportGeneralReqBO.getPurchaseNos());
            uocMonrpSupplierPO.setOrgname(monthReportGeneralReqBO.getPurchaseNosName());
            uocMonrpSupplierPO.setCreateDate(new Date());
            uocMonrpSupplierPO.setSupplierNo(orderAmtBySupplierRspBO.getSupplierNo());
            uocMonrpSupplierPO.setSupplierName(orderAmtBySupplierRspBO.getSupplierName());
            uocMonrpSupplierPO.setMonOrderAmt(bigDecimal);
            uocMonrpSupplierPO.setSupOrderAmt(this.seleAmt(monthReportGeneralReqBO, orderAmtBySupplierRspBO.getSupOrderList()).divide(new BigDecimal("10000"), 2, 4));
            uocMonrpSupplierPO.setSupOrderNum(orderAmtBySupplierRspBO.getSupOrderNum());
            if (bigDecimal.compareTo(BigDecimal.ZERO) != 0) {
                uocMonrpSupplierPO.setSupOrderScale(uocMonrpSupplierPO.getSupOrderAmt().divide(bigDecimal, 2, 4));
            } else {
                uocMonrpSupplierPO.setSupOrderScale(BigDecimal.ZERO);
            }
            if ((i = this.uocMonrpSupplierMapper.insertSelective(uocMonrpSupplierPO)) != 1) continue;
            isCreate = 1;
        }
        monthReportGeneralRspBO.setIsCreate(isCreate);
        return monthReportGeneralRspBO;
    }

    public BigDecimal seleAmt(MonthReportGeneralReqBO monthReportGeneralReqBO, String codeList) {
        BusiMonthReportYfReqBO yfReqBO = new BusiMonthReportYfReqBO();
        yfReqBO.setMonthDate(monthReportGeneralReqBO.getMonthDate());
        yfReqBO.setPurchaseNo(monthReportGeneralReqBO.getPurchaseNos());
        yfReqBO.setOrderCodes(codeList);
        BusiMonthReportYfRspBO yfRspBO = this.busiMonthReportYfService.queryYfInfo(yfReqBO);
        return yfRspBO.getMonOrderAmt();
    }

    public SelectScaleBySupplierRspBO selectOrderAmtAndDayRspBO(MonthReportGeneralReqBO reqBO) {
        Map requestMap = null;
        SelectScaleBySupplierRspBO rspBO = new SelectScaleBySupplierRspBO();
        try {
            requestMap = PropertyUtils.describe((Object)((Object)reqBO));
            requestMap.remove("class");
            log.info("[\u6708\u62a5-\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0b\u5355\u91d1\u989d\u670d\u52a1]-\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)requestMap));
            String returnString = null;
            try {
                returnString = HttpRequest.post((String)this.orderAmtBySupplierUrl).form(requestMap).timeout(30000).execute().body();
            }
            catch (HttpException e) {
                log.error("[\u6708\u62a5-\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0b\u5355\u91d1\u989d\u670d\u52a1]-\u8bf7\u6c42\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5", (Throwable)e);
                returnString = "[\u6708\u62a5-\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0b\u5355\u91d1\u989d\u670d\u52a1]-\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5";
            }
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "[\u6708\u62a5-\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0b\u5355\u91d1\u989d\u670d\u52a1]-\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
            log.info("[\u6708\u62a5-\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0b\u5355\u91d1\u989d\u670d\u52a1]-\u54cd\u5e94\u62a5\u6587|{}", (Object)returnString);
            if (!"0000".equals(jsonObjectReturn.getString("respCode"))) {
                rspBO.setCode(jsonObjectReturn.getString("respCode"));
                rspBO.setMessage("\u6708\u62a5-\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0b\u5355\u91d1\u989d\u670d\u52a1!" + jsonObjectReturn.getString("respDesc"));
                return rspBO;
            }
            String resultData = jsonObjectReturn.getString("data");
            if (!StringUtils.isEmpty((Object)resultData)) {
                rspBO = (SelectScaleBySupplierRspBO)((Object)JSONObject.parseObject((String)resultData, SelectScaleBySupplierRspBO.class));
                rspBO.setCode("0000");
                rspBO.setMessage("\u8c03\u7528\u6708\u62a5-\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0b\u5355\u91d1\u989d\u670d\u52a1\u6210\u529f");
                return rspBO;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspBO;
    }
}

