/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebSelectOrderAmtByDayService;
import com.tydic.uoc.busibase.busi.bo.BusiSelecOrderRspBO;
import com.tydic.uoc.busibase.busi.bo.BusiSelectOrderAmtAndDayRspBO;
import com.tydic.uoc.busibase.busi.bo.MonthReportGeneralReqBO;
import com.tydic.uoc.busibase.busi.bo.OrderAmtAndDayBO;
import com.tydic.uoc.busibase.busi.bo.SelectOrderAmtAndDayRspBO;
import com.tydic.uoc.common.ability.api.BusiMonthReportYfService;
import com.tydic.uoc.common.ability.bo.BusiMonthReportYfReqBO;
import com.tydic.uoc.common.ability.bo.BusiMonthReportYfRspBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrderAmtAndDayPO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebSelectOrderAmtByDayService")
public class PebSelectOrderAmtByDayServiceImpl
implements PebSelectOrderAmtByDayService {
    private static final Logger log = LoggerFactory.getLogger(PebSelectOrderAmtByDayServiceImpl.class);
    @Value(value="${orderAmtAndDayUrl}")
    String orderAmtAndDayUrl;
    @Value(value="${orderCountUrl}")
    String orderCountUrl;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private BusiMonthReportYfService busiMonthReportYfService;

    @Override
    public BusiSelectOrderAmtAndDayRspBO selectOrderAmtByDay(MonthReportGeneralReqBO monthReportGeneralReqBO) {
        OrderAmtAndDayBO rspBo;
        log.info("[\u67e5\u8be2\u6708\u62a5-\u6bcf\u65e5\u4e0b\u5355\u670d\u52a1]-\u5165\u53c2|{}", (Object)JSON.toJSONString((Object)((Object)monthReportGeneralReqBO)));
        BusiSelectOrderAmtAndDayRspBO busiSelectOrderAmtAndDayRspBO = new BusiSelectOrderAmtAndDayRspBO();
        ArrayList<OrderAmtAndDayBO> bos = new ArrayList<OrderAmtAndDayBO>();
        SelectOrderAmtAndDayRspBO rspBO = this.selectOrderAmtAndDayRspBO(monthReportGeneralReqBO);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date monthDate = null;
        try {
            monthDate = simpleDateFormat.parse(monthReportGeneralReqBO.getMonthDate());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(monthDate);
        Date startTime = calendar.getTime();
        int actualMaximum = calendar.getActualMaximum(5);
        calendar.add(2, 1);
        Date endTime = calendar.getTime();
        Map<Object, Object> dayAndCode = new HashMap();
        List<OrderAmtAndDayPO> orderAmtAndDay = this.ordSaleMapper.getOrderAmtAndDay(startTime, endTime, monthReportGeneralReqBO.getPurchaseNos(), actualMaximum);
        dayAndCode = rspBO.getDayAndcode();
        for (OrderAmtAndDayPO orderAmtAndDayPO : orderAmtAndDay) {
            if (dayAndCode.containsKey(orderAmtAndDayPO.getDay())) {
                if (null != dayAndCode.get(orderAmtAndDayPO.getDay()) && ((String)dayAndCode.get(orderAmtAndDayPO.getDay())).length() > 0) {
                    orderAmtAndDayPO.setOrderIds((String)dayAndCode.get(orderAmtAndDayPO.getDay()) + "," + orderAmtAndDayPO.getOrderIds());
                } else {
                    orderAmtAndDayPO.setOrderIds(orderAmtAndDayPO.getOrderIds());
                }
                orderAmtAndDayPO.setOrderAmt(this.seleAmt(monthReportGeneralReqBO, orderAmtAndDayPO.getOrderIds()).divide(new BigDecimal("10000"), 2, 4));
                dayAndCode.remove(orderAmtAndDayPO.getDay());
            }
            rspBo = new OrderAmtAndDayBO();
            BeanUtils.copyProperties((Object)orderAmtAndDayPO, (Object)rspBo);
            bos.add(rspBo);
        }
        if (null != dayAndCode && dayAndCode.size() > 0) {
            for (String string : dayAndCode.keySet()) {
                rspBo = new OrderAmtAndDayBO();
                rspBo.setDay(string);
                rspBo.setOrderAmt(this.seleAmt(monthReportGeneralReqBO, (String)dayAndCode.get(string)).divide(new BigDecimal("10000"), 2, 4));
                bos.add(rspBo);
            }
        }
        log.info("\u67e5\u8be2\u6708\u62a5-\u6bcf\u65e5\u4e0b\u5355\u51fa\u53c2\u6570---------->" + ((Object)bos).toString());
        busiSelectOrderAmtAndDayRspBO.setOrderAmtAndDayBOS(bos);
        busiSelectOrderAmtAndDayRspBO.setCode("0");
        busiSelectOrderAmtAndDayRspBO.setMessage("\u67e5\u8be2\u6708\u62a5-\u6bcf\u65e5\u4e0b\u5355\u6210\u529f");
        return busiSelectOrderAmtAndDayRspBO;
    }

    public BigDecimal seleAmt(MonthReportGeneralReqBO monthReportGeneralReqBO, String codeList) {
        BusiMonthReportYfReqBO yfReqBO = new BusiMonthReportYfReqBO();
        yfReqBO.setMonthDate(monthReportGeneralReqBO.getMonthDate());
        yfReqBO.setPurchaseNo(monthReportGeneralReqBO.getPurchaseNos());
        yfReqBO.setOrderCodes(codeList);
        BusiMonthReportYfRspBO yfRspBO = this.busiMonthReportYfService.queryYfInfo(yfReqBO);
        return yfRspBO.getMonOrderAmt();
    }

    @Override
    public BusiSelecOrderRspBO selectOrder(MonthReportGeneralReqBO monthReportGeneralReqBO) {
        log.info("\u67e5\u8be2\u6708\u62a5-\u4e0b\u5355\u8ba2\u5355\u7f16\u53f7\u5165\u53c2---------->" + monthReportGeneralReqBO.toString());
        BusiSelecOrderRspBO rspBO = new BusiSelecOrderRspBO();
        ArrayList bos = new ArrayList();
        rspBO = this.selectOrderCount(monthReportGeneralReqBO);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date monthDate = null;
        try {
            monthDate = simpleDateFormat.parse(monthReportGeneralReqBO.getMonthDate());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(monthDate);
        Date startTime = calendar.getTime();
        calendar.add(2, 1);
        Date endTime = calendar.getTime();
        calendar.add(2, -1);
        calendar.set(calendar.get(1), 0, 1, 0, 0, 0);
        Date time = calendar.getTime();
        List<String> orderCode = this.ordSaleMapper.getOrderCode(startTime, endTime, monthReportGeneralReqBO.getPurchaseNos());
        List<String> yearList = this.ordSaleMapper.getOrderCode(time, endTime, monthReportGeneralReqBO.getPurchaseNos());
        rspBO.getCodeList().addAll(orderCode);
        rspBO.getYearCodeList().addAll(yearList);
        return rspBO;
    }

    public SelectOrderAmtAndDayRspBO selectOrderAmtAndDayRspBO(MonthReportGeneralReqBO reqBO) {
        Map requestMap = null;
        SelectOrderAmtAndDayRspBO rspBO = new SelectOrderAmtAndDayRspBO();
        try {
            requestMap = PropertyUtils.describe((Object)((Object)reqBO));
            requestMap.remove("class");
            log.info("[\u67e5\u8be2\u6708\u62a5-\u6bcf\u65e5\u4e0b\u5355\u670d\u52a1]-\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u6bcf\u6708\u6bcf\u5929\u4e0b\u5355\u91d1\u989d\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)requestMap));
            String returnString = null;
            try {
                returnString = HttpRequest.post((String)this.orderAmtAndDayUrl).form(requestMap).timeout(30000).execute().body();
            }
            catch (HttpException e) {
                log.error("[\u67e5\u8be2\u6708\u62a5-\u6bcf\u65e5\u4e0b\u5355\u670d\u52a1]-\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u6bcf\u6708\u6bcf\u5929\u4e0b\u5355\u91d1\u989d\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                returnString = "[\u67e5\u8be2\u6708\u62a5-\u6bcf\u65e5\u4e0b\u5355\u670d\u52a1]-\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u6bcf\u6708\u6bcf\u5929\u4e0b\u5355\u91d1\u989d\u670d\u52a1\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5";
            }
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u6bcf\u6708\u6bcf\u5929\u4e0b\u5355\u91d1\u989d\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
            log.info("[\u67e5\u8be2\u6708\u62a5-\u6bcf\u65e5\u4e0b\u5355\u670d\u52a1]-\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u6bcf\u6708\u6bcf\u5929\u4e0b\u5355\u91d1\u989d\u670d\u52a1\u51fa\u53c2|{}", (Object)jsonObjectReturn.toJSONString());
            if (!"0000".equals(jsonObjectReturn.getString("respCode"))) {
                rspBO.setCode(jsonObjectReturn.getString("respCode"));
                rspBO.setMessage("\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u6bcf\u6708\u6bcf\u5929\u4e0b\u5355\u91d1\u989d\u670d\u52a1!" + jsonObjectReturn.getString("respDesc"));
                return rspBO;
            }
            JSONObject resultData = jsonObjectReturn.getJSONObject("data");
            log.info("\u51fa\u53c2\u65701\uff1a" + resultData.toJSONString());
            if (null != resultData) {
                JSONObject dayAndAmt = resultData.getJSONObject("dayAndAmt");
                rspBO.setCode("0000");
                rspBO.setMessage("\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u6bcf\u6708\u6bcf\u5929\u4e0b\u5355\u91d1\u989d\u670d\u52a1\u6210\u529f");
                rspBO.setDayAndcode((Map<String, String>)dayAndAmt);
                return rspBO;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspBO;
    }

    public BusiSelecOrderRspBO selectOrderCount(MonthReportGeneralReqBO reqBO) {
        Map requestMap = null;
        BusiSelecOrderRspBO rspBO = new BusiSelecOrderRspBO();
        try {
            requestMap = PropertyUtils.describe((Object)((Object)reqBO));
            requestMap.remove("class");
            log.info("\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u8ba2\u5355\u7f16\u53f7\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)requestMap));
            String returnString = null;
            try {
                returnString = HttpRequest.post((String)this.orderCountUrl).form(requestMap).timeout(30000).execute().body();
            }
            catch (HttpException e) {
                e.printStackTrace();
                returnString = "\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u8ba2\u5355\u7f16\u53f7\u670d\u52a1\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5";
            }
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u8ba2\u5355\u7f16\u53f7\u670d\u52a1\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
            log.info("\u51fa\u53c2\u6570\uff1a" + jsonObjectReturn.toJSONString());
            log.info("\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u8ba2\u5355\u7f16\u53f7\u670d\u52a1\u54cd\u5e94\u62a5\u6587", (Object)returnString);
            if (!"0000".equals(jsonObjectReturn.getString("respCode"))) {
                log.info("\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u8ba2\u5355\u7f16\u53f7\u670d\u52a1\u5931\u8d25URL===>\uff1a{}", (Object)this.orderAmtAndDayUrl);
                log.info("\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u8ba2\u5355\u7f16\u53f7\u670d\u52a1\u5165\u53c2===>\uff1a{}", (Object)JSON.toJSONString((Object)requestMap));
                rspBO.setCode(jsonObjectReturn.getString("respCode"));
                rspBO.setMessage("\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u8ba2\u5355\u7f16\u53f7\u670d\u52a1!" + jsonObjectReturn.getString("respDesc"));
                return rspBO;
            }
            JSONObject resultData = jsonObjectReturn.getJSONObject("data");
            log.info("\u51fa\u53c2\u65701\uff1a" + resultData.toJSONString());
            if (null != resultData) {
                rspBO = (BusiSelecOrderRspBO)((Object)JSONObject.parseObject((String)String.valueOf(resultData), BusiSelecOrderRspBO.class));
                rspBO.setCode("0000");
                rspBO.setMessage("\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u8ba2\u5355\u7f16\u53f7\u670d\u52a1\u6210\u529f");
                return rspBO;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspBO;
    }
}

