/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebSelectSkuTopDetailService;
import com.tydic.uoc.busibase.busi.bo.BusiSkuTopByMonthAndCataLogRspBO;
import com.tydic.uoc.busibase.busi.bo.CatalogAndAmtRspBO;
import com.tydic.uoc.busibase.busi.bo.MonthReportGeneralReqBO;
import com.tydic.uoc.busibase.busi.bo.MonthReportGeneralRspBO;
import com.tydic.uoc.busibase.busi.bo.SkuTopByMonthRspBO;
import com.tydic.uoc.common.ability.api.BusiMonthReportYfService;
import com.tydic.uoc.common.ability.bo.BusiMonthReportYfReqBO;
import com.tydic.uoc.common.ability.bo.BusiMonthReportYfRspBO;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.UocMonrpSkuMapper;
import com.tydic.uoc.po.UocMonrpSkuPO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebSelectSkuTopDetailService")
public class PebSelectSkuTopDetailServiceImpl
implements PebSelectSkuTopDetailService {
    private static final Logger log = LoggerFactory.getLogger(PebSelectSkuTopDetailServiceImpl.class);
    @Value(value="${skuTopUrl}")
    String skuTopUrl;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocMonrpSkuMapper uocMonrpSkuMapper;
    @Autowired
    private BusiMonthReportYfService busiMonthReportYfService;

    @Override
    public MonthReportGeneralRspBO selectSkuTopDetail(MonthReportGeneralReqBO monthReportGeneralReqBO) {
        Integer isCreate = 0;
        MonthReportGeneralRspBO monthReportGeneralRspBO = new MonthReportGeneralRspBO();
        BusiSkuTopByMonthAndCataLogRspBO busiSkuTopByMonthAndCataLogRspBO = this.selectOrderAmtAndDayRspBO(monthReportGeneralReqBO);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date monthDate = null;
        try {
            monthDate = simpleDateFormat.parse(monthReportGeneralReqBO.getMonthDate());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(monthDate);
        Date startTime = calendar.getTime();
        calendar.add(2, 1);
        Date endTime = calendar.getTime();
        List<SkuTopByMonthRspBO> skuTopByMonth = this.ordItemMapper.getSkuTopByMonth(startTime, endTime, monthReportGeneralReqBO.getPurchaseNos());
        skuTopByMonth.addAll(busiSkuTopByMonthAndCataLogRspBO.getSkuTopByMonthRspBOList());
        Collections.sort(skuTopByMonth, new Comparator<SkuTopByMonthRspBO>(){

            @Override
            public int compare(SkuTopByMonthRspBO ele1, SkuTopByMonthRspBO ele2) {
                return ele2.getSkuTotalNum().compareTo(ele1.getSkuTotalNum());
            }
        });
        List<CatalogAndAmtRspBO> catalogAndAmtRspBOS = this.ordItemMapper.getCatalogNumTop(startTime, endTime, monthReportGeneralReqBO.getPurchaseNos());
        catalogAndAmtRspBOS.addAll(busiSkuTopByMonthAndCataLogRspBO.getCatalogAndAmtRspBOS());
        for (CatalogAndAmtRspBO catalogAndAmtRspBO : catalogAndAmtRspBOS) {
            catalogAndAmtRspBO.setAmt(this.seleAmt(monthReportGeneralReqBO, catalogAndAmtRspBO.getOrderCodeList()).divide(new BigDecimal("10000"), 2, 4));
        }
        Collections.sort(catalogAndAmtRspBOS, new Comparator<CatalogAndAmtRspBO>(){

            @Override
            public int compare(CatalogAndAmtRspBO ele1, CatalogAndAmtRspBO ele2) {
                return ele2.getAmt().compareTo(ele1.getAmt());
            }
        });
        for (int i = 0; i < 10; ++i) {
            int i1;
            UocMonrpSkuPO uocMonrpSkuPO = new UocMonrpSkuPO();
            uocMonrpSkuPO.setMonrpNo(monthReportGeneralReqBO.getMonrpNo());
            uocMonrpSkuPO.setOrgid(monthReportGeneralReqBO.getPurchaseNos());
            uocMonrpSkuPO.setOrgname(monthReportGeneralReqBO.getPurchaseNosName());
            uocMonrpSkuPO.setCreateDate(new Date());
            if (i < skuTopByMonth.size()) {
                SkuTopByMonthRspBO skuTopByMonthRspBO = skuTopByMonth.get(i);
                uocMonrpSkuPO.setSkuId(skuTopByMonthRspBO.getSkuId());
                uocMonrpSkuPO.setExtSkuId(skuTopByMonthRspBO.getExtSkuId());
                uocMonrpSkuPO.setNewSkuId(skuTopByMonthRspBO.getNewSkuId());
                uocMonrpSkuPO.setSkuName(skuTopByMonthRspBO.getSkuName());
                uocMonrpSkuPO.setSkuOrderNun(skuTopByMonthRspBO.getSkuTotalNum());
                uocMonrpSkuPO.setSkuOrderAmt(this.seleAmt(monthReportGeneralReqBO, skuTopByMonthRspBO.getOrderCodeList()).divide(new BigDecimal("10000"), 2, 4));
            }
            if (i < catalogAndAmtRspBOS.size()) {
                CatalogAndAmtRspBO catalogAndAmtRspBO = catalogAndAmtRspBOS.get(i);
                uocMonrpSkuPO.setCatalogId(catalogAndAmtRspBO.getCatalogId());
                uocMonrpSkuPO.setCatalogName(catalogAndAmtRspBO.getCatalogName());
                uocMonrpSkuPO.setElementOne(String.valueOf(catalogAndAmtRspBO.getAmt().setScale(2, 4)));
            }
            if ((i1 = this.uocMonrpSkuMapper.insertSelective(uocMonrpSkuPO)) != 1) continue;
            isCreate = 1;
        }
        monthReportGeneralRspBO.setIsCreate(isCreate);
        return monthReportGeneralRspBO;
    }

    public BigDecimal seleAmt(MonthReportGeneralReqBO monthReportGeneralReqBO, String codeList) {
        BusiMonthReportYfReqBO yfReqBO = new BusiMonthReportYfReqBO();
        yfReqBO.setMonthDate(monthReportGeneralReqBO.getMonthDate());
        yfReqBO.setPurchaseNo(monthReportGeneralReqBO.getPurchaseNos());
        yfReqBO.setOrderCodes(codeList);
        BusiMonthReportYfRspBO yfRspBO = this.busiMonthReportYfService.queryYfInfo(yfReqBO);
        return yfRspBO.getMonOrderAmt();
    }

    public BusiSkuTopByMonthAndCataLogRspBO selectOrderAmtAndDayRspBO(MonthReportGeneralReqBO reqBO) {
        Map requestMap = null;
        BusiSkuTopByMonthAndCataLogRspBO rspBO = new BusiSkuTopByMonthAndCataLogRspBO();
        try {
            requestMap = PropertyUtils.describe((Object)((Object)reqBO));
            requestMap.remove("class");
            log.info("[\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u5546\u54c1top\u670d\u52a1]-\u5165\u53c2|{}", (Object)JSON.toJSONString((Object)requestMap));
            String returnString = null;
            try {
                returnString = HttpRequest.post((String)this.skuTopUrl).form(requestMap).timeout(30000).execute().body();
            }
            catch (HttpException e) {
                log.error("[\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u5546\u54c1top\u670d\u52a1]-\u8c03\u7528\u63a5\u53e3\u5931\u8d25", (Throwable)e);
                returnString = "\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u5546\u54c1top\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5";
            }
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u5546\u54c1top\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
            log.info("[\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u5546\u54c1top\u670d\u52a1]-\u54cd\u5e94\u62a5\u6587|{}", (Object)returnString);
            if (!"0000".equals(jsonObjectReturn.getString("respCode"))) {
                rspBO.setCode(jsonObjectReturn.getString("respCode"));
                rspBO.setMessage("\u8c03\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u5546\u54c1top\u670d\u52a1!" + jsonObjectReturn.getString("respDesc"));
                return rspBO;
            }
            String resultData = jsonObjectReturn.getString("data");
            if (!StringUtils.isEmpty((Object)resultData)) {
                rspBO = (BusiSkuTopByMonthAndCataLogRspBO)((Object)JSONObject.parseObject((String)resultData, BusiSkuTopByMonthAndCataLogRspBO.class));
                rspBO.setCode("0000");
                rspBO.setMessage("\u8c03\u8c03\u7528\u67e5\u8be2\u7efc\u5408\u533a\u5546\u54c1top\u670d\u52a1\u6210\u529f");
                return rspBO;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspBO;
    }
}

