/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agreement.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.common.ability.api.UccSkuManagementListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryBO;
import com.tydic.dyc.zone.agreement.api.IcascAgrAnalysisAgreementItemListService;
import com.tydic.dyc.zone.agreement.bo.IcascAgrAgreementItemExportBO;
import com.tydic.dyc.zone.agreement.bo.IcascAgrAnalysisAgreementItemListReqBO;
import com.tydic.dyc.zone.agreement.bo.IcascAgrAnalysisAgreementItemListRspBO;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IcascAgrAnalysisAgreementItemListServiceImpl
implements IcascAgrAnalysisAgreementItemListService {
    private static final Logger log = LoggerFactory.getLogger(IcascAgrAnalysisAgreementItemListServiceImpl.class);
    private static final String XLSX = "xlsx";
    private static final String XLS = "xls";
    private static final Integer SWITCH_ON = 1;
    private static final Integer SWITCH_OFF = 0;
    @Autowired
    private UccSkuManagementListQryAbilityService uccSkuManagementListQryAbilityService;

    public IcascAgrAnalysisAgreementItemListRspBO analysisAgreementItemList(IcascAgrAnalysisAgreementItemListReqBO reqBO) {
        XSSFWorkbook workbook;
        HashMap<Long, String> poiMap;
        HashSet<Long> skuIds;
        block20: {
            skuIds = new HashSet<Long>();
            poiMap = new HashMap<Long, String>();
            this.validate(reqBO);
            workbook = null;
            InputStream inputStream = null;
            String fileUrl = reqBO.getFilreUrl();
            URL url = null;
            try {
                url = new URL(fileUrl);
            }
            catch (MalformedURLException e) {
                throw new ZTBusinessException("\u4ece\u7f51\u7edc\u8bfb\u53d6excel\u51fa\u9519");
            }
            try {
                inputStream = url.openStream();
                if (fileUrl.toLowerCase().endsWith(XLSX)) {
                    workbook = new XSSFWorkbook(inputStream);
                    break block20;
                }
                if (fileUrl.toLowerCase().endsWith(XLS)) {
                    workbook = new HSSFWorkbook(inputStream);
                    break block20;
                }
                throw new ZTBusinessException("\u4e0d\u662f\u88ab\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u8bfb\u53d6excel\u5931\u8d25");
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    log.error("\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25|", (Throwable)e);
                }
            }
        }
        Sheet sheet = workbook.getSheetAt(0);
        int rowCount = sheet.getPhysicalNumberOfRows();
        int cellCount = 0;
        log.info("\u5f53\u524dexcel\u7684\u884c\u6570\uff1a" + rowCount);
        for (int i = 0; i < rowCount; ++i) {
            Row row = sheet.getRow(i);
            if (row.getCell(1).toString().equals("") || row.getCell(1).toString() == null) {
                log.info("excel\u4e0d\u5339\u914d\uff0c\u76f4\u63a5\u7ed3\u675f");
                break;
            }
            if (row != null && i == 0) {
                cellCount = row.getPhysicalNumberOfCells();
                log.info("\u5f53\u524dexcel\u7684\u5217\u6570\uff1a" + cellCount);
                this.validateTemplate(row, cellCount);
            }
            if (row == null || i == 0) continue;
            ArrayList<String> list = new ArrayList<String>();
            DecimalFormat decimalFormat = new DecimalFormat("0");
            String id = row.getCell(1).toString();
            if (reqBO.getSkuIds() != null && reqBO.getSkuIds().contains(Long.valueOf(id))) {
                log.info("\u5df2\u7ecf\u5b58\u5728\u4e8e\u5546\u54c1\u7f16\u7801\u96c6\u5408\u4e2d");
                continue;
            }
            for (int j = 0; j < cellCount; ++j) {
                if (row.getCell(j) != null) {
                    if (row.getCell(j).getCellType() == CellType.NUMERIC && (j == 13 || j == 14 || j == 15)) {
                        String format = decimalFormat.format(row.getCell(j).getNumericCellValue());
                        list.add(format);
                        continue;
                    }
                    list.add(row.getCell(j).toString());
                    continue;
                }
                list.add(" ");
            }
            log.info("\u5546\u54c1\u7f16\u7801\uff1a" + (String)list.get(1) + " \u6298\u6263\u7387\uff1a" + (String)list.get(12) + " \u4f9b\u8d27\u5468\u671f\u5929\uff1a" + (String)list.get(13) + " \u6700\u5c0f\u8d77\u8ba2\u91cf\uff1a" + (String)list.get(14) + " \u662f\u5426\u542f\u7528\u9636\u68af\u4ef7\u9500\u552e\uff1a" + (String)list.get(15));
            boolean add = skuIds.add(Long.valueOf((String)list.get(1)));
            if (!add) continue;
            poiMap.put(Long.valueOf((String)list.get(1)), (String)list.get(12) + "&" + (String)list.get(13) + "&" + (String)list.get(14) + "&" + (String)list.get(15));
        }
        log.info("\u5546\u54c1skuIds\uff1a" + JSON.toJSONString(new ArrayList(skuIds)));
        log.info("\u5546\u54c1poiMap" + JSON.toJSONString(poiMap));
        IcascAgrAnalysisAgreementItemListRspBO rspBO = new IcascAgrAnalysisAgreementItemListRspBO();
        rspBO.setMessage("\u534f\u8bae\u5e94\u7528\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u6210\u529f");
        rspBO.setCode("0000");
        rspBO.setRows(this.getInfoFromUcc(new ArrayList<Long>(skuIds), poiMap, reqBO.getCatalogIds()));
        return rspBO;
    }

    public void validate(IcascAgrAnalysisAgreementItemListReqBO reqBO) {
        if (reqBO.getFilreUrl() == null || reqBO.getFilreUrl().equals("")) {
            throw new ZTBusinessException("\u534f\u8bae\u5e94\u7528\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6587\u4ef6\u89e3\u6790API-fileUrl\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<IcascAgrAgreementItemExportBO> getInfoFromUcc(List<Long> skuIds, Map<Long, String> poiMap, List<Long> catalogIds) {
        ArrayList<IcascAgrAgreementItemExportBO> list = new ArrayList<IcascAgrAgreementItemExportBO>();
        if (CollectionUtils.isEmpty(skuIds)) {
            return list;
        }
        UccSkuManagementListQryAbilityReqBO uccReqBO = new UccSkuManagementListQryAbilityReqBO();
        uccReqBO.setSkuIds(skuIds);
        uccReqBO.setPageNo(1);
        uccReqBO.setCommodityType(Integer.valueOf(1));
        uccReqBO.setPageSize(Integer.MAX_VALUE);
        uccReqBO.setCatalogIds(catalogIds);
        UccSkuManagementListQryAbilityRspBO skuManagementListQry = this.uccSkuManagementListQryAbilityService.getSkuManagementListQry(uccReqBO);
        log.info("\u67e5\u8be2\u5546\u54c1\u51fa\u53c2:" + JSON.toJSONString((Object)skuManagementListQry));
        if (!"0000".equals(skuManagementListQry.getRespCode())) {
            throw new ZTBusinessException(skuManagementListQry.getRespDesc());
        }
        List skuManagementListQryRows = JSONArray.parseArray((String)JSON.toJSONString((Object)skuManagementListQry.getRows())).toJavaList(UccSkuManagementListQryBO.class);
        if (!CollectionUtils.isEmpty((Collection)skuManagementListQryRows)) {
            for (UccSkuManagementListQryBO skuManagementListQryRow : skuManagementListQryRows) {
                IcascAgrAgreementItemExportBO itemExportBO = (IcascAgrAgreementItemExportBO)JSON.parseObject((String)JSON.toJSONString((Object)skuManagementListQryRow), IcascAgrAgreementItemExportBO.class);
                itemExportBO.setSkuCode(skuManagementListQryRow.getSkuId());
                itemExportBO.setSkuId(skuManagementListQryRow.getSkuId());
                String param = poiMap.get(itemExportBO.getSkuCode());
                String[] split = param.split("&");
                itemExportBO.setAgrDiscountRate(split[0].equals(" ") ? null : new BigDecimal(split[0]));
                itemExportBO.setPreDeliverDay(split[1]);
                itemExportBO.setMoq(split[2].equals(" ") ? null : new BigDecimal(split[2]));
                itemExportBO.setAgrSalePrice(String.valueOf(skuManagementListQryRow.getAgreementPrice()));
                itemExportBO.setSpec(skuManagementListQryRow.getSpec());
                itemExportBO.setModel(skuManagementListQryRow.getModel());
                itemExportBO.setSkuMainPicUrl(skuManagementListQryRow.getPicUrl());
                list.add(itemExportBO);
            }
        } else {
            log.info("\u8c03\u7528\u5546\u54c1\u63a5\u53e3\u6ca1\u6709\u6570\u636e");
        }
        return list;
    }

    public Integer getSwitch(String switchOn) {
        if (switchOn.equals("\u662f")) {
            return SWITCH_ON;
        }
        if (switchOn.equals("\u5426")) {
            return SWITCH_OFF;
        }
        return null;
    }

    private void validateTemplate(Row row, int cellCount) {
        if (cellCount != 16) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(1).toString().equals("\u5546\u54c1\u7f16\u7801")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(2).toString().equals("\u5546\u54c1\u540d\u79f0")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(3).toString().equals("\u54c1\u724c")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(4).toString().equals("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(5).toString().equals("\u5546\u54c1\u7c7b\u76ee")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(6).toString().equals("\u662f\u5426\u6210\u54c1\u6cb9")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(7).toString().equals("\u9500\u552e\u5355\u4f4d")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(8).toString().equals("\u7ed3\u7b97\u5355\u4f4d")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(9).toString().equals("\u5e02\u573a\u4ef7")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(10).toString().equals("\u9500\u552e\u4ef7")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(11).toString().equals("\u534f\u8bae\u91c7\u8d2d\u4ef7")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(12).toString().equals("\u6298\u6263\u7387")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(13).toString().equals("\u4f9b\u8d27\u5468\u671f\u5929")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(14).toString().equals("\u6700\u5c0f\u8d77\u8ba2\u91cf")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
        if (!row.getCell(15).toString().equals("\u662f\u5426\u542f\u7528\u9636\u68af\u4ef7\u9500\u552e")) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u822a\u5929\u5546\u57ce\u4e0b\u8f7d\u7684\u534f\u8bae\u6a21\u677f");
        }
    }

    public Integer stringToInteger(String a) {
        if ("".equals(a)) {
            return null;
        }
        return Double.valueOf(a).intValue();
    }

    public BigDecimal stringToBig(String a) {
        if ("".equals(a)) {
            return null;
        }
        return BigDecimal.valueOf(Double.valueOf(a));
    }

    public Long stringToLong(String a) {
        if ("".equals(a)) {
            return null;
        }
        return Long.valueOf(a);
    }
}

