/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agreement.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.agreement.ability.api.AgrOperAgreementDetailAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementItemBO;
import com.tydic.agreement.ability.bo.AgrLadderPriceBO;
import com.tydic.agreement.ability.bo.AgrOperAgreementDetailAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrOperAgreementDetailAbilityRspBO;
import com.tydic.dyc.zone.agreement.api.IcascAgrOperAgreementDetailService;
import com.tydic.dyc.zone.agreement.bo.IcascAgrAttachBO;
import com.tydic.dyc.zone.agreement.bo.IcascAgrLadderPriceBO;
import com.tydic.dyc.zone.agreement.bo.IcascAgrOperAgreementDetailReqBO;
import com.tydic.dyc.zone.agreement.bo.IcascAgrOperAgreementDetailRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class IcascAgrOperAgreementDetailServiceImpl
implements IcascAgrOperAgreementDetailService {
    private static final Logger log = LoggerFactory.getLogger(IcascAgrOperAgreementDetailServiceImpl.class);
    @Autowired
    private AgrOperAgreementDetailAbilityService agrOperAgreementDetailAbilityService;

    public IcascAgrOperAgreementDetailRspBO operAgreementDetail(IcascAgrOperAgreementDetailReqBO reqBO) {
        this.validate(reqBO);
        AgrOperAgreementDetailAbilityReqBO agrOperAgreementDetailAbilityReqBO = new AgrOperAgreementDetailAbilityReqBO();
        List<Object> agrAgreementItemBOs = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgrAgreementItemBOs())) {
            agrAgreementItemBOs = reqBO.getAgrAgreementItemBOs().stream().map(bo -> {
                AgrAgreementItemBO agrAgreementItemBO = new AgrAgreementItemBO();
                BeanUtils.copyProperties((Object)bo, (Object)agrAgreementItemBO);
                if (0 == bo.getSwitchOn()) {
                    agrAgreementItemBO.setMarketPrice(bo.getMarketPrice().multiply(new BigDecimal(10000)));
                    agrAgreementItemBO.setSalePrice(new BigDecimal(bo.getSalePrice()).multiply(new BigDecimal(10000)));
                    agrAgreementItemBO.setAgrPrice(new BigDecimal(bo.getAgrPrice()).multiply(new BigDecimal(10000)));
                    if (bo.getAgrSalePrice() == null) {
                        throw new ZTBusinessException("agrSalePrice\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    agrAgreementItemBO.setAgrSalePrice(new BigDecimal(bo.getAgrSalePrice()).multiply(new BigDecimal(10000)));
                    if (bo.getSettlementSinglePrice() == null) {
                        throw new ZTBusinessException("settlementSinglePrice\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    agrAgreementItemBO.setSettlementSinglePrice(new BigDecimal(bo.getSettlementSinglePrice()).multiply(new BigDecimal(10000)));
                } else {
                    agrAgreementItemBO.setMarketPrice(bo.getMarketPrice().multiply(new BigDecimal(10000)));
                }
                if (!CollectionUtils.isEmpty((Collection)bo.getAgrLadderPriceBOs())) {
                    List list = bo.getAgrLadderPriceBOs().stream().map(bo1 -> {
                        AgrLadderPriceBO agrLadderPriceBO = new AgrLadderPriceBO();
                        BeanUtils.copyProperties((Object)bo1, (Object)agrLadderPriceBO);
                        agrLadderPriceBO.setPrice(bo1.getPrice().multiply(new BigDecimal(10000)));
                        return agrLadderPriceBO;
                    }).collect(Collectors.toList());
                }
                return agrAgreementItemBO;
            }).collect(Collectors.toList());
        }
        reqBO.setAgrAgreementItemBOs(null);
        String reqJsonStr = JSON.toJSONString((Object)reqBO);
        agrOperAgreementDetailAbilityReqBO = (AgrOperAgreementDetailAbilityReqBO)JSONObject.parseObject((String)reqJsonStr, AgrOperAgreementDetailAbilityReqBO.class);
        agrOperAgreementDetailAbilityReqBO.setAgrAgreementItemBOs(agrAgreementItemBOs);
        AgrOperAgreementDetailAbilityRspBO agrOperAgreementDetailAbilityRspBO = this.agrOperAgreementDetailAbilityService.operAgreementDetail(agrOperAgreementDetailAbilityReqBO);
        if ("0000".equals(agrOperAgreementDetailAbilityRspBO.getRespCode())) {
            IcascAgrOperAgreementDetailRspBO rsp = new IcascAgrOperAgreementDetailRspBO();
            rsp.setAgreementId(agrOperAgreementDetailAbilityRspBO.getAgreementId());
            return rsp;
        }
        throw new ZTBusinessException(agrOperAgreementDetailAbilityRspBO.getRespDesc());
    }

    private void validate(IcascAgrOperAgreementDetailReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getOperType())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAgrAgreementBO()) {
            throw new ZTBusinessException("\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("2".equals(reqBO.getOperType()) && null == reqBO.getAgreementId()) {
            throw new ZTBusinessException("\u534f\u8bae\u7f16\u8f91\u65f6\uff0c\u534f\u8baeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getUserName())) {
            throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgrAttachBOs())) {
            for (IcascAgrAttachBO bo2 : reqBO.getAgrAttachBOs()) {
                if (!StringUtils.hasText((String)bo2.getAttachUrl())) {
                    throw new ZTBusinessException("agrAttachBOs.attachUrl\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.hasText((String)bo2.getAttachName())) continue;
                throw new ZTBusinessException("agrAttachBOs.attachName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAgrCatalogScopeBOs())) {
            throw new ZTBusinessException("agrCatalogScopeBOs\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (IcascAgrAttachBO bo2 : reqBO.getAgrCatalogScopeBOs()) {
            if (null == bo2.getCatalogId()) {
                throw new ZTBusinessException("agrCatalogScopeBOs.catalogId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null != bo2.getAddPriceRate()) continue;
            throw new ZTBusinessException("agrCatalogScopeBOs.addPriceRate\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!"1".equals(reqBO.getAgrAgreementBO().getApplicationScopeType())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getAgrApplicationScopeBOs()) && "1".equals(reqBO.getAgrAgreementBO().getServiceType())) {
                throw new ZTBusinessException("agrApplicationScopeBOs\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!CollectionUtils.isEmpty((Collection)reqBO.getAgrApplicationScopeBOs())) {
                reqBO.getAgrApplicationScopeBOs().forEach(bo -> {
                    if (!StringUtils.hasText((String)bo.getApplicationScopeType())) {
                        throw new ZTBusinessException("agrApplicationScopeBOs.applicationScopeType\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                });
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgrAgreementItemBOs())) {
            for (IcascAgrAttachBO bo2 : reqBO.getAgrAgreementItemBOs()) {
                if (null == bo2.getSkuId()) {
                    throw new ZTBusinessException("agrAgreementItemBOs.skuId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo2.getCatalogId()) {
                    throw new ZTBusinessException("agrAgreementItemBOs.catalogId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo2.getMarketPrice()) {
                    throw new ZTBusinessException("agrAgreementItemBOs.marketPrice\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo2.getAgrDiscountRate()) {
                    throw new ZTBusinessException("agrAgreementItemBOs.agrDiscountRate\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo2.getOldSwitchOn()) {
                    throw new ZTBusinessException("agrAgreementItemBOs.oldSwitchOn\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo2.getSwitchOn()) {
                    throw new ZTBusinessException("agrAgreementItemBOs.switchOn\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (0 == bo2.getSwitchOn()) {
                    if (!StringUtils.hasText((String)bo2.getSalePrice())) {
                        throw new ZTBusinessException("agrAgreementItemBOs.salePrice\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!StringUtils.hasText((String)bo2.getAgrPrice())) {
                        throw new ZTBusinessException("agrAgreementItemBOs.agrPrice\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!StringUtils.hasText((String)bo2.getAgrSalePrice())) {
                        throw new ZTBusinessException("agrAgreementItemBOs.agrSalePrice\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!StringUtils.hasText((String)bo2.getSettlementSinglePrice())) {
                        throw new ZTBusinessException("agrAgreementItemBOs.settlementSinglePrice\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                } else {
                    if (CollectionUtils.isEmpty((Collection)bo2.getAgrLadderPriceBOs())) {
                        throw new ZTBusinessException("agrAgreementItemBOs.agrLadderPriceBOs\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    List priceType = bo2.getAgrLadderPriceBOs().stream().map(IcascAgrLadderPriceBO::getPriceType).collect(Collectors.toList());
                    if (!priceType.contains("1")) {
                        throw new ZTBusinessException("agrAgreementItemBOs.agrLadderPriceBOs\u4e2d\u9500\u552e\u4ef7\u9636\u68af\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!priceType.contains("2")) {
                        throw new ZTBusinessException("agrAgreementItemBOs.agrLadderPriceBOs\u4e2d\u534f\u8bae\u4ef7\u9636\u68af\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!priceType.contains("3")) {
                        throw new ZTBusinessException("agrAgreementItemBOs.agrLadderPriceBOs\u4e2d\u534f\u8bae\u9500\u552e\u4ef7\u9636\u68af\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!priceType.contains("4")) {
                        throw new ZTBusinessException("agrAgreementItemBOs.agrLadderPriceBOs\u4e2d\u7ed3\u7b97\u5355\u4ef7\u9636\u68af\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                }
                if (null != bo2.getRefinedOil()) {
                    bo2.setIsOil(bo2.getRefinedOil());
                }
                if (null != bo2.getSettlementUnitRate()) {
                    bo2.setSettlementConversionRate(bo2.getSettlementUnitRate());
                }
                log.info("\u662f\u5426\u6210\u54c1\u6cb9\uff1a" + bo2.getRefinedOil() + " \u7ed3\u7b97\u8f6c\u6362\u7387\uff1a" + bo2.getSettlementUnitRate() + " \u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff1a" + bo2.getTaxCatCode());
            }
        }
    }
}

