/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agreement.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.agreement.ability.api.AgrQryAgreementItemListWithHisAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementItemBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementItemListWithHisAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementItemListWithHisAbilityRspBO;
import com.tydic.commodity.zone.ability.api.UccBatchQrySkuInfoAbilityService;
import com.tydic.commodity.zone.ability.bo.UccBatchQrySkuInfoAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccBatchQrySkuInfoAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccNormSpuManageQryListBO;
import com.tydic.dyc.zone.agreement.api.IcascAgrQryAgreementItemListWithHisService;
import com.tydic.dyc.zone.agreement.bo.IcascAgrAgreementItemBO;
import com.tydic.dyc.zone.agreement.bo.IcascAgrLadderPriceBO;
import com.tydic.dyc.zone.agreement.bo.IcascAgrQryAgreementItemListWithHisReqBO;
import com.tydic.dyc.zone.agreement.bo.IcascAgrQryAgreementItemListWithHisRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IcascAgrQryAgreementItemListWithHisServiceImpl
implements IcascAgrQryAgreementItemListWithHisService {
    private static final Logger log = LoggerFactory.getLogger(IcascAgrQryAgreementItemListWithHisServiceImpl.class);
    @Autowired
    private AgrQryAgreementItemListWithHisAbilityService agrQryAgreementItemListWithHisAbilityService;
    private static final String SALE_PRICE_TYPE = "1";
    private static final String AGR_PRICE_TYPE = "2";
    private static final String AGR_SALE_PRICE_TYPE = "3";
    private static final String SETTLEMENT_SINGLE_PRICE_TYPE = "4";
    @Autowired
    private UccBatchQrySkuInfoAbilityService uccBatchQrySkuInfoAbilityService;

    public IcascAgrQryAgreementItemListWithHisRspBO qryAgreementItemListWithHis(IcascAgrQryAgreementItemListWithHisReqBO reqBO) {
        this.validate(reqBO);
        AgrQryAgreementItemListWithHisAbilityReqBO centerReqBO = (AgrQryAgreementItemListWithHisAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), AgrQryAgreementItemListWithHisAbilityReqBO.class);
        AgrQryAgreementItemListWithHisAbilityRspBO centerRspBO = this.agrQryAgreementItemListWithHisAbilityService.qryAgreementItemListWithHis(centerReqBO);
        if (!"0000".equals(centerRspBO.getRespCode())) {
            throw new ZTBusinessException(centerRspBO.getRespDesc());
        }
        IcascAgrQryAgreementItemListWithHisRspBO rspBO = (IcascAgrQryAgreementItemListWithHisRspBO)JSON.parseObject((String)JSON.toJSONString((Object)centerRspBO), IcascAgrQryAgreementItemListWithHisRspBO.class);
        rspBO.setRows(this.getRows(centerRspBO.getRows()));
        return rspBO;
    }

    private void validate(IcascAgrQryAgreementItemListWithHisReqBO reqBO) {
        if (reqBO.getRelativeId() == null) {
            throw new ZTBusinessException("\u534f\u8bae\u5e94\u7528\u534f\u8bae\u660e\u7ec6\u5217\u8868\u67e5\u8be2(\u542b\u5220\u9664\u5386\u53f2)-relativeId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<IcascAgrAgreementItemBO> getRows(List<AgrAgreementItemBO> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return null;
        }
        Map<Object, Object> esSkuMaps = new HashMap();
        List skus = rows.stream().map(AgrAgreementItemBO::getSkuId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(skus)) {
            UccBatchQrySkuInfoAbilityReqBO qrySkuInfoAbilityReqBO = new UccBatchQrySkuInfoAbilityReqBO();
            qrySkuInfoAbilityReqBO.setSkuIds(skus);
            UccBatchQrySkuInfoAbilityRspBO qrySkuInfoAbilityRspBO = this.uccBatchQrySkuInfoAbilityService.qryBatchSkuInfo(qrySkuInfoAbilityReqBO);
            if (qrySkuInfoAbilityRspBO != null && "0000".equals(qrySkuInfoAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)qrySkuInfoAbilityRspBO.getBatchSkuInfoList())) {
                log.info("qrySkuInfoAbilityRspBO.getBatchSkuInfoList()=" + JSONObject.toJSONString((Object)qrySkuInfoAbilityRspBO.getBatchSkuInfoList()));
                esSkuMaps = qrySkuInfoAbilityRspBO.getBatchSkuInfoList().stream().collect(Collectors.groupingBy(UccNormSpuManageQryListBO::getSkuId));
            }
        }
        ArrayList<IcascAgrAgreementItemBO> list = new ArrayList<IcascAgrAgreementItemBO>();
        for (AgrAgreementItemBO row : rows) {
            IcascAgrAgreementItemBO icascAgrAgreementBO = (IcascAgrAgreementItemBO)JSON.parseObject((String)JSON.toJSONString((Object)row), IcascAgrAgreementItemBO.class);
            if (icascAgrAgreementBO.getSwitchOn() == 1) {
                List agrLadderPriceBOs = icascAgrAgreementBO.getAgrLadderPriceBOs();
                ArrayList<IcascAgrLadderPriceBO> agrSaleLadderPriceBOs = new ArrayList<IcascAgrLadderPriceBO>();
                ArrayList<IcascAgrLadderPriceBO> agrAgreementLadderPriceBOs = new ArrayList<IcascAgrLadderPriceBO>();
                ArrayList<IcascAgrLadderPriceBO> agrAgreementSaleLadderPriceBOs = new ArrayList<IcascAgrLadderPriceBO>();
                ArrayList<IcascAgrLadderPriceBO> agrsettlementSingleLadderPriceBOs = new ArrayList<IcascAgrLadderPriceBO>();
                for (IcascAgrLadderPriceBO agrLadderPriceBO : agrLadderPriceBOs) {
                    if (agrLadderPriceBO.getPriceType().equals(SALE_PRICE_TYPE)) {
                        agrSaleLadderPriceBOs.add(agrLadderPriceBO);
                    }
                    if (agrLadderPriceBO.getPriceType().equals(AGR_PRICE_TYPE)) {
                        agrAgreementLadderPriceBOs.add(agrLadderPriceBO);
                    }
                    if (agrLadderPriceBO.getPriceType().equals(AGR_SALE_PRICE_TYPE)) {
                        agrAgreementSaleLadderPriceBOs.add(agrLadderPriceBO);
                    }
                    if (!agrLadderPriceBO.getPriceType().equals(SETTLEMENT_SINGLE_PRICE_TYPE)) continue;
                    agrsettlementSingleLadderPriceBOs.add(agrLadderPriceBO);
                }
                if (this.verify(agrSaleLadderPriceBOs).booleanValue()) {
                    Collections.sort(agrSaleLadderPriceBOs, Comparator.comparing(IcascAgrLadderPriceBO::getSerial));
                }
                if (this.verify(agrAgreementLadderPriceBOs).booleanValue()) {
                    Collections.sort(agrAgreementLadderPriceBOs, Comparator.comparing(IcascAgrLadderPriceBO::getSerial));
                }
                if (this.verify(agrAgreementSaleLadderPriceBOs).booleanValue()) {
                    Collections.sort(agrAgreementSaleLadderPriceBOs, Comparator.comparing(IcascAgrLadderPriceBO::getSerial));
                }
                if (this.verify(agrsettlementSingleLadderPriceBOs).booleanValue()) {
                    Collections.sort(agrsettlementSingleLadderPriceBOs, Comparator.comparing(IcascAgrLadderPriceBO::getSerial));
                }
                icascAgrAgreementBO.setAgrSaleLadderPriceBOs(agrSaleLadderPriceBOs);
                icascAgrAgreementBO.setAgrAgreementLadderPriceBOs(agrAgreementLadderPriceBOs);
                icascAgrAgreementBO.setAgrAgreementSaleLadderPriceBOs(agrAgreementSaleLadderPriceBOs);
                icascAgrAgreementBO.setAgrsettlementSingleLadderPriceBOs(agrsettlementSingleLadderPriceBOs);
                icascAgrAgreementBO.setSalePrice(this.getTemplate(agrSaleLadderPriceBOs));
                icascAgrAgreementBO.setAgrPrice(this.getTemplate(agrAgreementLadderPriceBOs));
                icascAgrAgreementBO.setAgrSalePrice(this.getTemplate(agrAgreementSaleLadderPriceBOs));
                icascAgrAgreementBO.setSettlementSinglePrice(this.getTemplate(agrsettlementSingleLadderPriceBOs));
                icascAgrAgreementBO.setMarketPrice(row.getMarketPrice() == null ? null : this.getMoney(row.getMarketPrice()));
            } else {
                icascAgrAgreementBO.setSalePrice(row.getSalePrice() == null ? "" : String.valueOf(this.getMoney(row.getSalePrice())));
                icascAgrAgreementBO.setMarketPrice(row.getMarketPrice() == null ? null : this.getMoney(row.getMarketPrice()));
                icascAgrAgreementBO.setAgrPrice(row.getAgrPrice() == null ? "" : String.valueOf(this.getMoney(row.getAgrPrice())));
                icascAgrAgreementBO.setAgrSalePrice(row.getAgrSalePrice() == null ? "" : String.valueOf(this.getMoney(row.getAgrSalePrice())));
                icascAgrAgreementBO.setSettlementSinglePrice(row.getSettlementSinglePrice() == null ? "" : String.valueOf(this.getMoney(row.getSettlementSinglePrice())));
            }
            if (esSkuMaps != null && !esSkuMaps.isEmpty() && esSkuMaps.containsKey(icascAgrAgreementBO.getSkuId())) {
                UccNormSpuManageQryListBO newEsSkuInfo = (UccNormSpuManageQryListBO)((List)esSkuMaps.get(icascAgrAgreementBO.getSkuId())).get(0);
                icascAgrAgreementBO.setSpec(newEsSkuInfo.getSpec());
                icascAgrAgreementBO.setModel(newEsSkuInfo.getModel());
                icascAgrAgreementBO.setSkuMainPicUrl(newEsSkuInfo.getSkuPicUrl());
            }
            list.add(icascAgrAgreementBO);
        }
        return list;
    }

    public BigDecimal getMoney(BigDecimal money) {
        return money.divide(new BigDecimal(10000), 2, 4);
    }

    public String getTemplate(List<IcascAgrLadderPriceBO> agrLadderPriceBOs) {
        String price = "";
        if (CollectionUtils.isEmpty(agrLadderPriceBOs)) {
            return price;
        }
        for (IcascAgrLadderPriceBO agrLadderPriceBO : agrLadderPriceBOs) {
            price = price + agrLadderPriceBO.getStart() + "<=\u6570\u91cf<" + (agrLadderPriceBO.getStop() == null ? "\u221e" : agrLadderPriceBO.getStop()) + " \uffe5" + agrLadderPriceBO.getPrice() + "\n";
        }
        return price;
    }

    public Boolean verify(List<IcascAgrLadderPriceBO> list) {
        if (!CollectionUtils.isEmpty(list) && list.get(0).getSerial() != null) {
            return true;
        }
        return false;
    }
}

