/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.commodity.impl;

import cn.hutool.core.lang.Snowflake;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.enumType.FindgoodsMatchTypeEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.zone.ability.api.UccFindGoodsMatchSkuListQryAbilityService;
import com.tydic.commodity.zone.ability.bo.UccFindGoodsMatchSkuListQryAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccFindGoodsMatchSkuListQryAbilityRspBO;
import com.tydic.dyc.base.utils.HttpUtil;
import com.tydic.dyc.base.utils.SSLClient;
import com.tydic.dyc.zone.commodity.api.IcascUccFindGoodsMatchSkuListQryAbilityService;
import com.tydic.dyc.zone.commodity.bo.IcascUccBatchSkuBO;
import com.tydic.dyc.zone.commodity.bo.IcascUccBatchSkuInfoInfceBO;
import com.tydic.dyc.zone.commodity.bo.IcascUccExtSupSearchSkuRspBO;
import com.tydic.dyc.zone.commodity.bo.IcascUccFindGoodsMatchSkuBO;
import com.tydic.dyc.zone.commodity.bo.IcascUccFindGoodsMatchSkuListQryAbilityReqBO;
import com.tydic.dyc.zone.commodity.bo.IcascUccFindGoodsMatchSkuListQryAbilityRspBO;
import com.tydic.dyc.zone.commodity.bo.IcascUccSearchBarEsBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class IcascUccFindGoodsMatchSkuListQryAbilityServiceImpl
implements IcascUccFindGoodsMatchSkuListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(IcascUccFindGoodsMatchSkuListQryAbilityServiceImpl.class);
    @Autowired
    private UccFindGoodsMatchSkuListQryAbilityService matchSkuListQryAbilityService;
    @Value(value="${icasc.ucc.address}")
    private String ADDRESS;
    private static final String SERVICE = "/rest/service/routing/nouser/searchBarEsService";
    private static final String BATCH_SKU_SERVICE = "/rest/service/routing/nouser/batQrySkuIntfceService";
    private static final String RESP_CODE_SUCCESS = "0000";
    private static final String NULL_RESPDESC_LOG_CODE = "20003";

    public IcascUccFindGoodsMatchSkuListQryAbilityRspBO getUccFindGoodsMatchSkuList(IcascUccFindGoodsMatchSkuListQryAbilityReqBO reqBO) {
        UccFindGoodsMatchSkuListQryAbilityReqBO abilityReqBO = new UccFindGoodsMatchSkuListQryAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)abilityReqBO);
        UccFindGoodsMatchSkuListQryAbilityRspBO abilityRspBO = this.matchSkuListQryAbilityService.getUccFindGoodsMatchSkuList(abilityReqBO);
        if (RESP_CODE_SUCCESS.equals(abilityRspBO.getRespCode())) {
            String resultData = JSON.toJSONString((Object)abilityRspBO);
            IcascUccFindGoodsMatchSkuListQryAbilityRspBO result = (IcascUccFindGoodsMatchSkuListQryAbilityRspBO)JSONObject.parseObject((String)resultData, IcascUccFindGoodsMatchSkuListQryAbilityRspBO.class);
            IcascUccExtSupSearchSkuRspBO searchSkuRspBO = this.qryBatchSkuInfo(result);
            if (searchSkuRspBO != null && !CollectionUtils.isEmpty((Map)searchSkuRspBO.getSkuInfoInfceRspMap())) {
                log.info("getUccFindGoodsMatchSkuList::searchSkuRspBO=" + JSONObject.toJSONString((Object)searchSkuRspBO));
                for (IcascUccFindGoodsMatchSkuBO matchSkuBO : result.getRows()) {
                    if (searchSkuRspBO.getSkuInfoInfceRspMap().containsKey(matchSkuBO.getVendorId() + "_" + matchSkuBO.getExtSkuId())) {
                        IcascUccBatchSkuInfoInfceBO searchResultBO = (IcascUccBatchSkuInfoInfceBO)searchSkuRspBO.getSkuInfoInfceRspMap().get(matchSkuBO.getVendorId() + "_" + matchSkuBO.getExtSkuId());
                        matchSkuBO.setSalePrice(searchResultBO.getSalePrice());
                        matchSkuBO.setAgreementPrice(searchResultBO.getAgreementPrice());
                        matchSkuBO.setMarketPrice(searchResultBO.getMarketPrice());
                        if (searchResultBO.getSkuStatus() != null && SkuStatusEnum.PENDING_SHELF_STATUS.getStatus().equals(searchResultBO.getSkuStatus())) {
                            matchSkuBO.setSkuStatus(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
                            matchSkuBO.setSkuStatusDesc(SkuStatusEnum.ON_SHELVES_STATUS.getStatusDesc());
                            continue;
                        }
                        if (searchResultBO.getSkuStatus() != null && SkuStatusEnum.REJECT_STATUS.getStatus().equals(searchResultBO.getSkuStatus())) {
                            matchSkuBO.setSkuStatus(SkuStatusEnum.EC_DOWN_STATUS.getStatus());
                            matchSkuBO.setSkuStatusDesc(SkuStatusEnum.EC_DOWN_STATUS.getStatusDesc());
                            continue;
                        }
                        if (searchResultBO.getSkuStatus() != null && SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(searchResultBO.getSkuStatus())) {
                            matchSkuBO.setSkuStatus(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus());
                            matchSkuBO.setSkuStatusDesc(SkuStatusEnum.DOWN_FRAME_STATUS.getStatusDesc());
                            continue;
                        }
                        if (searchResultBO.getSkuStatus() == null || !SkuStatusEnum.INVALID_STATUS.getStatus().equals(searchResultBO.getSkuStatus())) continue;
                        matchSkuBO.setSkuStatus(SkuStatusEnum.INVALID_STATUS.getStatus());
                        matchSkuBO.setSkuStatusDesc(SkuStatusEnum.INVALID_STATUS.getStatusDesc());
                        continue;
                    }
                    if (matchSkuBO.getChannelId() == null || matchSkuBO.getChannelId() != 1001L || FindgoodsMatchTypeEnum.NO_MATCH_TYPE.getType().equals(matchSkuBO.getMatchTypeCode())) continue;
                    matchSkuBO.setSkuStatus(SkuStatusEnum.EC_DOWN_STATUS.getStatus());
                    matchSkuBO.setSkuStatusDesc(SkuStatusEnum.EC_DOWN_STATUS.getStatusDesc());
                }
            }
            log.info("getUccFindGoodsMatchSkuList::searchSkuRspBO=" + JSONObject.toJSONString((Object)searchSkuRspBO));
            List sortResults = result.getRows().stream().sorted(Comparator.comparing(IcascUccFindGoodsMatchSkuBO::getMatchTypeCode, Comparator.nullsLast(Integer::compareTo)).thenComparing(IcascUccFindGoodsMatchSkuBO::getSalePrice, Comparator.nullsLast(BigDecimal::compareTo)).thenComparing(IcascUccFindGoodsMatchSkuBO::getSkuId, Comparator.nullsLast(Long::compareTo).reversed())).collect(Collectors.toList());
            result.setRows(sortResults);
            return result;
        }
        throw new ZTBusinessException(abilityRspBO.getRespDesc());
    }

    private IcascUccExtSupSearchSkuRspBO extSupSearchSku(IcascUccFindGoodsMatchSkuListQryAbilityReqBO reqBO, IcascUccFindGoodsMatchSkuListQryAbilityRspBO rspBO) {
        IcascUccExtSupSearchSkuRspBO extRspBO = new IcascUccExtSupSearchSkuRspBO();
        extRspBO.setRespCode(RESP_CODE_SUCCESS);
        extRspBO.setRespDesc("\u6210\u529f");
        log.info("getUccFindGoodsMatchSkuList::\u8bf7\u6c42\u5730\u5740\uff1a" + this.ADDRESS + SERVICE);
        log.info("getUccFindGoodsMatchSkuList:IcascUccFindGoodsMatchSkuListQryAbilityReqBO:reqBO=" + JSON.toJSONString((Object)reqBO));
        log.info("getUccFindGoodsMatchSkuList:IcascUccFindGoodsMatchSkuListQryAbilityRspBO:rspBO=" + JSON.toJSONString((Object)rspBO));
        if (rspBO != null && !CollectionUtils.isEmpty((Map)rspBO.getSupExtSkuIdMaps())) {
            HashMap searchResultMap = new HashMap();
            for (Long supplierId : rspBO.getSupExtSkuIdMaps().keySet()) {
                for (String extSkuId : (List)rspBO.getSupExtSkuIdMaps().get(supplierId)) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("queryStr", extSkuId);
                    map.put("queryLocation", "2");
                    map.put("supplierId", String.valueOf(supplierId));
                    map.put("pageNo", String.valueOf(reqBO.getPageNo()));
                    map.put("pageSize", String.valueOf(reqBO.getPageSize()));
                    map.put("isprofess", String.valueOf(2));
                    map.put("supId", String.valueOf(supplierId));
                    map.put("userId", String.valueOf(reqBO.getUserId()));
                    try {
                        String distinctId = "A1CESHI1";
                        if (!StringUtils.isEmpty((Object)reqBO.getSenoId())) {
                            JSONObject parseObject = JSON.parseObject((String)reqBO.getSenoId());
                            distinctId = parseObject.getString("distinct_id");
                        }
                        if (reqBO.getUserId() != null) {
                            distinctId = String.valueOf(reqBO.getUserId());
                        }
                        map.put("cookieId", distinctId);
                        map.put("platform", reqBO.getPlatform());
                    }
                    catch (Exception e) {
                        log.error("\u795e\u7b56\u57cb\u70b9\u8f6c\u6362\u53c2\u6570\u5f02\u5e38", (Throwable)e);
                    }
                    if (reqBO.getFenliu() == null) {
                        Snowflake snowflake = new Snowflake(2L, 3L);
                        String cookieId = snowflake.nextIdStr();
                        Cookie cookie = new Cookie("fenliu", cookieId);
                        cookie.setPath("/");
                        map.put("flcookie", cookieId);
                        log.info("\u65b0\u5206\u6d41cookie" + cookieId);
                    } else {
                        map.put("flcookie", reqBO.getFenliu());
                        log.info("\u5c31\u8ba9\u5206\u6d41cookie" + reqBO.getFenliu());
                    }
                    log.info("getUccFindGoodsMatchSkuList::\u91cd\u65b0\u62fc\u88c5\uff1a" + JSON.toJSONString(map));
                    String s = HttpUtil.doPostNoHead((String)(this.ADDRESS + SERVICE), map);
                    log.info("getUccFindGoodsMatchSkuList::\u8bf7\u6c42\u51fa\u53c2\uff1a" + s);
                    JSONObject obj = JSON.parseObject((String)s);
                    if (NULL_RESPDESC_LOG_CODE.equals(obj.getString("respCode"))) {
                        JSONObject versionJson;
                        if (obj.containsKey((Object)"data") && (versionJson = obj.getJSONObject("data")).containsKey((Object)"searchVersion")) {
                            log.info("getUccFindGoodsMatchSkuList::searchVersion=" + versionJson.getString("searchVersion"));
                            extRspBO.setSearchVersion(versionJson.getString("searchVersion"));
                        }
                        return extRspBO;
                    }
                    if (!RESP_CODE_SUCCESS.equals(obj.getString("respCode"))) {
                        extRspBO.setRespCode(obj.getString("respCode"));
                        extRspBO.setRespDesc(obj.getString("respDesc"));
                        return extRspBO;
                    }
                    String data = obj.getString("data");
                    log.info("getUccFindGoodsMatchSkuList::\u8bf7\u6c42\u51fa\u53c2\uff1adata=" + data);
                    if (!StringUtils.hasText((String)data)) continue;
                    IcascUccSearchBarEsBO esRspBO = (IcascUccSearchBarEsBO)JSON.parseObject((String)data, IcascUccSearchBarEsBO.class);
                    if (esRspBO != null && !CollectionUtils.isEmpty((Collection)esRspBO.getResult())) {
                        searchResultMap.put(supplierId + "_" + extSkuId, esRspBO.getResult().get(0));
                    }
                    log.info("getUccFindGoodsMatchSkuList::esRspBO\uff1asearchResultMap=" + JSON.toJSONString(searchResultMap));
                }
            }
            extRspBO.setSearchResultMap(searchResultMap);
        }
        return extRspBO;
    }

    private IcascUccExtSupSearchSkuRspBO qryBatchSkuInfo(IcascUccFindGoodsMatchSkuListQryAbilityRspBO rspBO) {
        IcascUccExtSupSearchSkuRspBO extRspBO = new IcascUccExtSupSearchSkuRspBO();
        extRspBO.setRespCode(RESP_CODE_SUCCESS);
        extRspBO.setRespDesc("\u6210\u529f");
        if (rspBO != null && !CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            HashMap<String, IcascUccBatchSkuInfoInfceBO> searchResultMap = new HashMap<String, IcascUccBatchSkuInfoInfceBO>();
            List batchSkuBO = rspBO.getRows().stream().filter(a -> a.getChannelId() != null && a.getChannelId() == 1001L).map(e -> {
                IcascUccBatchSkuBO nodeBO = new IcascUccBatchSkuBO();
                nodeBO.setSkuId(e.getSkuId());
                nodeBO.setSupplierId(e.getVendorId());
                return nodeBO;
            }).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(batchSkuBO)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("skuSupplier", batchSkuBO);
                log.info("\u6279\u91cf\u67e5\u8be2\u5916\u90e8\u7535\u5546\u5165\u53c2\uff1askuSupplier=" + JSONObject.toJSONString((Object)jsonObject));
                String s = SSLClient.doPost((String)(this.ADDRESS + BATCH_SKU_SERVICE), (String)JSONObject.toJSONString((Object)jsonObject));
                log.info("\u8bf7\u6c42\u51fa\u53c2\uff1a" + s);
                JSONObject obj = JSON.parseObject((String)s);
                if (!RESP_CODE_SUCCESS.equals(obj.getString("respCode"))) {
                    throw new ZTBusinessException(obj.getString("respDesc"));
                }
                String data = obj.getString("data");
                JSONObject dataObj = JSONObject.parseObject((String)data);
                String result = dataObj.getString("results");
                List marketSkuBOS = JSONObject.parseArray((String)result, IcascUccBatchSkuInfoInfceBO.class);
                if (!CollectionUtils.isEmpty((Collection)marketSkuBOS)) {
                    for (IcascUccBatchSkuInfoInfceBO skuInfoInfceRsp : marketSkuBOS) {
                        searchResultMap.put(skuInfoInfceRsp.getSupplierId() + "_" + skuInfoInfceRsp.getExtSkuId(), skuInfoInfceRsp);
                    }
                    log.info("getUccFindGoodsMatchSkuList::esRspBO\uff1asearchResultMap=" + JSON.toJSONString(searchResultMap));
                    extRspBO.setSkuInfoInfceRspMap(searchResultMap);
                }
            }
        }
        return extRspBO;
    }
}

